/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.net.InetAddress;
import java.net.SocketException;
import java.net.VMNetworkInterface;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public final class NetworkInterface {
    private String name;
    private Vector inetAddresses;

    public final String getName() {
        return this.name;
    }

    public final Enumeration getInetAddresses() {
        SecurityManager s = System.getSecurityManager();
        if (s == null) {
            return this.inetAddresses.elements();
        }
        Vector tmpInetAddresses = new Vector(1, 1);
        Enumeration addresses = this.inetAddresses.elements();
        while (addresses.hasMoreElements()) {
            InetAddress addr = (InetAddress)addresses.nextElement();
            try {
                s.checkConnect(addr.getHostAddress(), 58000);
                tmpInetAddresses.add(addr);
            }
            catch (SecurityException e) {
                // empty catch block
            }
        }
        return tmpInetAddresses.elements();
    }

    public final String getDisplayName() {
        return this.name;
    }

    public static final NetworkInterface getByName(String name) throws SocketException {
        Enumeration e = NetworkInterface.getNetworkInterfaces();
        while (e.hasMoreElements()) {
            NetworkInterface tmp = (NetworkInterface)e.nextElement();
            if (!name.equals(tmp.getName())) continue;
            return tmp;
        }
        return null;
    }

    public static final NetworkInterface getByInetAddress(InetAddress addr) throws SocketException {
        Enumeration interfaces = NetworkInterface.getNetworkInterfaces();
        while (interfaces.hasMoreElements()) {
            NetworkInterface tmp = (NetworkInterface)interfaces.nextElement();
            Enumeration addresses = tmp.inetAddresses.elements();
            while (addresses.hasMoreElements()) {
                if (!addr.equals((InetAddress)addresses.nextElement())) continue;
                return tmp;
            }
        }
        throw new SocketException("no network interface is bound to such an IP address");
    }

    private static final Collection condense(Collection interfaces) {
        HashMap condensed = new HashMap();
        Iterator interfs = interfaces.iterator();
        while (interfs.hasNext()) {
            NetworkInterface face = (NetworkInterface)interfs.next();
            String name = face.getName();
            if (condensed.containsKey(name)) {
                NetworkInterface conface = (NetworkInterface)condensed.get(name);
                if (conface.inetAddresses.containsAll(face.inetAddresses)) continue;
                Iterator faceAddresses = face.inetAddresses.iterator();
                while (faceAddresses.hasNext()) {
                    InetAddress faceAddress = (InetAddress)faceAddresses.next();
                    if (conface.inetAddresses.contains(faceAddress)) continue;
                    conface.inetAddresses.add(faceAddress);
                }
                continue;
            }
            condensed.put(name, face);
        }
        return condensed.values();
    }

    public static final Enumeration getNetworkInterfaces() throws SocketException {
        Vector networkInterfaces = VMNetworkInterface.getInterfaces();
        if (networkInterfaces.isEmpty()) {
            return null;
        }
        Collection condensed = NetworkInterface.condense(networkInterfaces);
        return Collections.enumeration(condensed);
    }

    public final boolean equals(Object obj) {
        if (!(obj instanceof NetworkInterface)) {
            return false;
        }
        NetworkInterface tmp = (NetworkInterface)obj;
        boolean bl = false;
        if (this.name.equals(tmp.name) && this.inetAddresses.equals(tmp.inetAddresses)) {
            bl = true;
        }
        return bl;
    }

    public final int hashCode() {
        return this.name.hashCode() + this.inetAddresses.hashCode();
    }

    public final String toString() {
        String separator = System.getProperty("line.separator");
        String result = "name: " + this.getDisplayName() + " (" + this.getName() + ") addresses:" + separator;
        Enumeration e = this.inetAddresses.elements();
        while (e.hasMoreElements()) {
            InetAddress address = (InetAddress)e.nextElement();
            result = result + address.toString() + ';' + separator;
        }
        return result;
    }

    NetworkInterface(String name, InetAddress address) {
        this.name = name;
        this.inetAddresses = new Vector(1, 1);
        this.inetAddresses.add(address);
    }

    NetworkInterface(String name, InetAddress[] addresses) {
        this.name = name;
        this.inetAddresses = new Vector(addresses.length, 1);
        int i = 0;
        while (i < addresses.length) {
            this.inetAddresses.add(addresses[i]);
            ++i;
        }
    }
}

