/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;

public class TreeSet
extends AbstractSet
implements SortedSet,
Cloneable,
Serializable {
    private static final long serialVersionUID = -2479143000061671589L;
    private transient SortedMap map;

    public boolean add(Object obj) {
        boolean bl = false;
        if (this.map.put(obj, "") == null) {
            bl = true;
        }
        return bl;
    }

    public boolean addAll(Collection c) {
        boolean result = false;
        int pos = c.size();
        Iterator itr = c.iterator();
        while (--pos >= 0) {
            boolean bl = false;
            if (this.map.put(itr.next(), "") == null) {
                bl = true;
            }
            result |= bl;
        }
        return result;
    }

    public void clear() {
        this.map.clear();
    }

    public Object clone() {
        TreeSet copy = null;
        try {
            copy = (TreeSet)super.clone();
            copy.map = (SortedMap)((AbstractMap)((Object)this.map)).clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return copy;
    }

    public Comparator comparator() {
        return this.map.comparator();
    }

    public boolean contains(Object obj) {
        return this.map.containsKey(obj);
    }

    public Object first() {
        return this.map.firstKey();
    }

    public SortedSet headSet(Object to) {
        return new TreeSet(this.map.headMap(to));
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Iterator iterator() {
        return this.map.keySet().iterator();
    }

    public Object last() {
        return this.map.lastKey();
    }

    public boolean remove(Object obj) {
        boolean bl = false;
        if (this.map.remove(obj) != null) {
            bl = true;
        }
        return bl;
    }

    public int size() {
        return this.map.size();
    }

    public SortedSet subSet(Object from, Object to) {
        return new TreeSet(this.map.subMap(from, to));
    }

    public SortedSet tailSet(Object from) {
        return new TreeSet(this.map.tailMap(from));
    }

    private final void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        Iterator itr = this.map.keySet().iterator();
        int pos = this.map.size();
        s.writeObject(this.map.comparator());
        s.writeInt(pos);
        while (--pos >= 0) {
            s.writeObject(itr.next());
        }
    }

    private final void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        Comparator comparator = (Comparator)s.readObject();
        int size = s.readInt();
        this.map = new TreeMap(comparator);
        ((TreeMap)this.map).putFromObjStream(s, size, false);
    }

    public TreeSet() {
        this.map = new TreeMap();
    }

    public TreeSet(Comparator comparator) {
        this.map = new TreeMap(comparator);
    }

    public TreeSet(Collection collection) {
        this.map = new TreeMap();
        this.addAll(collection);
    }

    public TreeSet(SortedSet sortedSet) {
        this.map = new TreeMap(sortedSet.comparator());
        Iterator itr = sortedSet.iterator();
        ((TreeMap)this.map).putKeysLinear(itr, sortedSet.size());
    }

    private TreeSet(SortedMap backingMap) {
        this.map = backingMap;
    }
}

