/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageInputStreamSpi;
import javax.imageio.spi.ImageOutputStreamSpi;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ImageTranscoderSpi;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class ImageIO {
    private static File cacheDirectory;
    private static boolean useCache;
    static /* synthetic */ Class class$javax$imageio$spi$ImageReaderSpi;
    static /* synthetic */ Class class$javax$imageio$spi$ImageWriterSpi;
    static /* synthetic */ Class class$javax$imageio$spi$ImageInputStreamSpi;
    static /* synthetic */ Class class$javax$imageio$spi$ImageOutputStreamSpi;
    static /* synthetic */ Class class$javax$imageio$spi$ImageTranscoderSpi;

    private static final Iterator getReadersByFilter(Class type, ServiceRegistry.Filter filter, Object readerExtension) {
        try {
            Iterator it = ImageIO.getRegistry().getServiceProviders(type, filter, true);
            return new ImageReaderIterator(it, readerExtension);
        }
        catch (IllegalArgumentException e) {
            return Collections.EMPTY_SET.iterator();
        }
    }

    private static final Iterator getWritersByFilter(Class type, ServiceRegistry.Filter filter, Object writerExtension) {
        try {
            Iterator it = ImageIO.getRegistry().getServiceProviders(type, filter, true);
            return new ImageWriterIterator(it, writerExtension);
        }
        catch (IllegalArgumentException e) {
            return Collections.EMPTY_SET.iterator();
        }
    }

    public static final File getCacheDirectory() {
        return cacheDirectory;
    }

    public static final Iterator getImageReadersByFormatName(String formatName) {
        if (formatName == null) {
            throw new IllegalArgumentException("formatName may not be null");
        }
        Class clazz = class$javax$imageio$spi$ImageReaderSpi;
        if (clazz == null) {
            clazz = class$javax$imageio$spi$ImageReaderSpi = ImageIO.class("[Ljavax.imageio.spi.ImageReaderSpi;", false);
        }
        return ImageIO.getReadersByFilter(clazz, new ReaderFormatFilter(formatName), formatName);
    }

    public static final Iterator getImageReadersByMIMEType(String MIMEType) {
        if (MIMEType == null) {
            throw new IllegalArgumentException("MIMEType may not be null");
        }
        Class clazz = class$javax$imageio$spi$ImageReaderSpi;
        if (clazz == null) {
            clazz = class$javax$imageio$spi$ImageReaderSpi = ImageIO.class("[Ljavax.imageio.spi.ImageReaderSpi;", false);
        }
        return ImageIO.getReadersByFilter(clazz, new ReaderMIMETypeFilter(MIMEType), MIMEType);
    }

    public static final Iterator getImageReadersBySuffix(String fileSuffix) {
        if (fileSuffix == null) {
            throw new IllegalArgumentException("formatName may not be null");
        }
        Class clazz = class$javax$imageio$spi$ImageReaderSpi;
        if (clazz == null) {
            clazz = class$javax$imageio$spi$ImageReaderSpi = ImageIO.class("[Ljavax.imageio.spi.ImageReaderSpi;", false);
        }
        return ImageIO.getReadersByFilter(clazz, new ReaderSuffixFilter(fileSuffix), fileSuffix);
    }

    public static final Iterator getImageWritersByFormatName(String formatName) {
        if (formatName == null) {
            throw new IllegalArgumentException("formatName may not be null");
        }
        Class clazz = class$javax$imageio$spi$ImageWriterSpi;
        if (clazz == null) {
            clazz = class$javax$imageio$spi$ImageWriterSpi = ImageIO.class("[Ljavax.imageio.spi.ImageWriterSpi;", false);
        }
        return ImageIO.getWritersByFilter(clazz, new WriterFormatFilter(formatName), formatName);
    }

    public static final Iterator getImageWritersByMIMEType(String MIMEType) {
        if (MIMEType == null) {
            throw new IllegalArgumentException("MIMEType may not be null");
        }
        Class clazz = class$javax$imageio$spi$ImageWriterSpi;
        if (clazz == null) {
            clazz = class$javax$imageio$spi$ImageWriterSpi = ImageIO.class("[Ljavax.imageio.spi.ImageWriterSpi;", false);
        }
        return ImageIO.getWritersByFilter(clazz, new WriterMIMETypeFilter(MIMEType), MIMEType);
    }

    public static final Iterator getImageWritersBySuffix(String fileSuffix) {
        if (fileSuffix == null) {
            throw new IllegalArgumentException("fileSuffix may not be null");
        }
        Class clazz = class$javax$imageio$spi$ImageWriterSpi;
        if (clazz == null) {
            clazz = class$javax$imageio$spi$ImageWriterSpi = ImageIO.class("[Ljavax.imageio.spi.ImageWriterSpi;", false);
        }
        return ImageIO.getWritersByFilter(clazz, new WriterSuffixFilter(fileSuffix), fileSuffix);
    }

    public static final String[] getReaderFormatNames() {
        try {
            IIORegistry iIORegistry = ImageIO.getRegistry();
            Class clazz = class$javax$imageio$spi$ImageReaderSpi;
            if (clazz == null) {
                clazz = class$javax$imageio$spi$ImageReaderSpi = ImageIO.class("[Ljavax.imageio.spi.ImageReaderSpi;", false);
            }
            Iterator it = iIORegistry.getServiceProviders(clazz, true);
            ArrayList result = new ArrayList();
            while (it.hasNext()) {
                ImageReaderSpi spi = (ImageReaderSpi)it.next();
                String[] names = spi.getFormatNames();
                int i = names.length - 1;
                while (i >= 0) {
                    result.add(names[i]);
                    --i;
                }
            }
            return (String[])result.toArray(new String[result.size()]);
        }
        catch (IllegalArgumentException e) {
            return new String[0];
        }
    }

    public static final String[] getReaderMIMETypes() {
        try {
            IIORegistry iIORegistry = ImageIO.getRegistry();
            Class clazz = class$javax$imageio$spi$ImageReaderSpi;
            if (clazz == null) {
                clazz = class$javax$imageio$spi$ImageReaderSpi = ImageIO.class("[Ljavax.imageio.spi.ImageReaderSpi;", false);
            }
            Iterator it = iIORegistry.getServiceProviders(clazz, true);
            ArrayList result = new ArrayList();
            while (it.hasNext()) {
                ImageReaderSpi spi = (ImageReaderSpi)it.next();
                String[] names = spi.getMIMETypes();
                int i = names.length - 1;
                while (i >= 0) {
                    result.add(names[i]);
                    --i;
                }
            }
            return (String[])result.toArray(new String[result.size()]);
        }
        catch (IllegalArgumentException e) {
            return new String[0];
        }
    }

    private static final IIORegistry getRegistry() {
        return IIORegistry.getDefaultInstance();
    }

    public static final boolean getUseCache() {
        return useCache;
    }

    public static final String[] getWriterFormatNames() {
        try {
            IIORegistry iIORegistry = ImageIO.getRegistry();
            Class clazz = class$javax$imageio$spi$ImageWriterSpi;
            if (clazz == null) {
                clazz = class$javax$imageio$spi$ImageWriterSpi = ImageIO.class("[Ljavax.imageio.spi.ImageWriterSpi;", false);
            }
            Iterator it = iIORegistry.getServiceProviders(clazz, true);
            ArrayList result = new ArrayList();
            while (it.hasNext()) {
                ImageWriterSpi spi = (ImageWriterSpi)it.next();
                String[] names = spi.getFormatNames();
                int i = names.length - 1;
                while (i >= 0) {
                    result.add(names[i]);
                    --i;
                }
            }
            return (String[])result.toArray(new String[result.size()]);
        }
        catch (IllegalArgumentException e) {
            return new String[0];
        }
    }

    public static final String[] getWriterMIMETypes() {
        try {
            IIORegistry iIORegistry = ImageIO.getRegistry();
            Class clazz = class$javax$imageio$spi$ImageWriterSpi;
            if (clazz == null) {
                clazz = class$javax$imageio$spi$ImageWriterSpi = ImageIO.class("[Ljavax.imageio.spi.ImageWriterSpi;", false);
            }
            Iterator it = iIORegistry.getServiceProviders(clazz, true);
            ArrayList result = new ArrayList();
            while (it.hasNext()) {
                ImageWriterSpi spi = (ImageWriterSpi)it.next();
                String[] names = spi.getMIMETypes();
                int i = names.length - 1;
                while (i >= 0) {
                    result.add(names[i]);
                    --i;
                }
            }
            return (String[])result.toArray(new String[result.size()]);
        }
        catch (IllegalArgumentException e) {
            return new String[0];
        }
    }

    public static final void scanForPlugins() {
        IIORegistry.getDefaultInstance().registerApplicationClasspathSpis();
    }

    public static final void setCacheDirectory(File cacheDirectory) {
        if (cacheDirectory != null) {
            if (!cacheDirectory.isDirectory()) {
                throw new IllegalArgumentException("cacheDirectory must be a directory");
            }
            cacheDirectory.canWrite();
        }
        ImageIO.cacheDirectory = cacheDirectory;
    }

    public static final void setUseCache(boolean useCache) {
        ImageIO.useCache = useCache;
    }

    public static final boolean write(RenderedImage im, String formatName, File output) throws IOException {
        if (im == null || formatName == null || output == null) {
            throw new IllegalArgumentException("null argument");
        }
        return ImageIO.write(im, formatName, new FileOutputStream(output));
    }

    public static final boolean write(RenderedImage im, String formatName, OutputStream output) throws IOException {
        if (im == null || formatName == null || output == null) {
            throw new IllegalArgumentException("null argument");
        }
        return ImageIO.write(im, formatName, new MemoryCacheImageOutputStream(output));
    }

    public static final boolean write(RenderedImage im, String formatName, ImageOutputStream output) throws IOException {
        if (im == null || formatName == null || output == null) {
            throw new IllegalArgumentException("null argument");
        }
        Iterator writers = ImageIO.getImageWritersByFormatName(formatName);
        IIOImage img = new IIOImage(im, null, null);
        while (writers.hasNext()) {
            ImageWriter w = (ImageWriter)writers.next();
            try {
                w.setOutput(output);
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            w.write(null, img, null);
            output.close();
            return true;
        }
        return false;
    }

    public static final BufferedImage read(ImageInputStream stream) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("null argument");
        }
        IIORegistry iIORegistry = ImageIO.getRegistry();
        Class clazz = class$javax$imageio$spi$ImageReaderSpi;
        if (clazz == null) {
            clazz = class$javax$imageio$spi$ImageReaderSpi = ImageIO.class("[Ljavax.imageio.spi.ImageReaderSpi;", false);
        }
        Iterator providers = iIORegistry.getServiceProviders(clazz, true);
        while (providers.hasNext()) {
            ImageReaderSpi spi = (ImageReaderSpi)providers.next();
            if (!spi.canDecodeInput(stream)) continue;
            ImageReader reader = spi.createReaderInstance();
            reader.setInput(stream);
            return reader.read(0, null);
        }
        return null;
    }

    public static final BufferedImage read(URL input) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("null argument");
        }
        return ImageIO.read(input.openStream());
    }

    public static final BufferedImage read(InputStream input) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("null argument");
        }
        return ImageIO.read(new MemoryCacheImageInputStream(input));
    }

    public static final BufferedImage read(File input) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("null argument");
        }
        return ImageIO.read(new FileInputStream(input));
    }

    public static final ImageInputStream createImageInputStream(Object input) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("null argument");
        }
        IIORegistry iIORegistry = ImageIO.getRegistry();
        Class clazz = class$javax$imageio$spi$ImageInputStreamSpi;
        if (clazz == null) {
            clazz = class$javax$imageio$spi$ImageInputStreamSpi = ImageIO.class("[Ljavax.imageio.spi.ImageInputStreamSpi;", false);
        }
        Iterator spis = iIORegistry.getServiceProviders(clazz, true);
        ImageInputStreamSpi foundSpi = null;
        while (spis.hasNext()) {
            ImageInputStreamSpi spi = (ImageInputStreamSpi)spis.next();
            if (!input.getClass().equals(spi.getInputClass())) continue;
            foundSpi = spi;
            break;
        }
        return foundSpi == null ? null : foundSpi.createInputStreamInstance(input, ImageIO.getUseCache(), ImageIO.getCacheDirectory());
    }

    public static final ImageOutputStream createImageOutputStream(Object output) throws IOException {
        if (output == null) {
            throw new IllegalArgumentException("null argument");
        }
        IIORegistry iIORegistry = ImageIO.getRegistry();
        Class clazz = class$javax$imageio$spi$ImageOutputStreamSpi;
        if (clazz == null) {
            clazz = class$javax$imageio$spi$ImageOutputStreamSpi = ImageIO.class("[Ljavax.imageio.spi.ImageOutputStreamSpi;", false);
        }
        Iterator spis = iIORegistry.getServiceProviders(clazz, true);
        ImageOutputStreamSpi foundSpi = null;
        while (spis.hasNext()) {
            ImageOutputStreamSpi spi = (ImageOutputStreamSpi)spis.next();
            if (!output.getClass().equals(spi.getOutputClass())) continue;
            foundSpi = spi;
            break;
        }
        return foundSpi == null ? null : foundSpi.createOutputStreamInstance(output, ImageIO.getUseCache(), ImageIO.getCacheDirectory());
    }

    public static final ImageReader getImageReader(ImageWriter writer) {
        if (writer == null) {
            throw new IllegalArgumentException("null argument");
        }
        ImageWriterSpi spi = (ImageWriterSpi)ImageIO.getRegistry().getServiceProviderByClass(writer.getClass());
        String[] readerSpiNames = spi.getImageReaderSpiNames();
        ImageReader r = null;
        if (readerSpiNames != null) {
            try {
                Class readerClass = Class.forName(readerSpiNames[0]);
                r = (ImageReader)readerClass.newInstance();
            }
            catch (Exception e) {
                return null;
            }
        }
        return r;
    }

    public static final Iterator getImageReaders(Object input) {
        if (input == null) {
            throw new IllegalArgumentException("null argument");
        }
        IIORegistry iIORegistry = ImageIO.getRegistry();
        Class clazz = class$javax$imageio$spi$ImageReaderSpi;
        if (clazz == null) {
            clazz = class$javax$imageio$spi$ImageReaderSpi = ImageIO.class("[Ljavax.imageio.spi.ImageReaderSpi;", false);
        }
        return iIORegistry.getServiceProviders(clazz, new ReaderObjectFilter(input), true);
    }

    public static final Iterator getImageWriters(ImageTypeSpecifier type, String formatName) {
        if (type == null || formatName == null) {
            throw new IllegalArgumentException("null argument");
        }
        IIORegistry iIORegistry = ImageIO.getRegistry();
        Class clazz = class$javax$imageio$spi$ImageWriterSpi;
        if (clazz == null) {
            clazz = class$javax$imageio$spi$ImageWriterSpi = ImageIO.class("[Ljavax.imageio.spi.ImageWriterSpi;", false);
        }
        return iIORegistry.getServiceProviders(clazz, new WriterObjectFilter(type, formatName), true);
    }

    public static final ImageWriter getImageWriter(ImageReader reader) {
        if (reader == null) {
            throw new IllegalArgumentException("null argument");
        }
        ImageReaderSpi spi = (ImageReaderSpi)ImageIO.getRegistry().getServiceProviderByClass(reader.getClass());
        String[] writerSpiNames = spi.getImageWriterSpiNames();
        ImageWriter w = null;
        if (writerSpiNames != null) {
            try {
                Class writerClass = Class.forName(writerSpiNames[0]);
                w = (ImageWriter)writerClass.newInstance();
            }
            catch (Exception e) {
                return null;
            }
        }
        return w;
    }

    public static final Iterator getImageTranscoders(ImageReader reader, ImageWriter writer) {
        if (reader == null || writer == null) {
            throw new IllegalArgumentException("null argument");
        }
        IIORegistry iIORegistry = ImageIO.getRegistry();
        Class clazz = class$javax$imageio$spi$ImageTranscoderSpi;
        if (clazz == null) {
            clazz = class$javax$imageio$spi$ImageTranscoderSpi = ImageIO.class("[Ljavax.imageio.spi.ImageTranscoderSpi;", false);
        }
        return iIORegistry.getServiceProviders(clazz, new TranscoderFilter(reader, writer), true);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private ImageIO() {
    }

    static {
        useCache = true;
    }

    private static final class ImageReaderIterator
    implements Iterator {
        Iterator it;
        Object readerExtension;

        public final boolean hasNext() {
            return this.it.hasNext();
        }

        public final Object next() {
            try {
                return ((ImageReaderSpi)this.it.next()).createReaderInstance(this.readerExtension);
            }
            catch (IOException e) {
                return null;
            }
        }

        public final void remove() {
            throw new UnsupportedOperationException();
        }

        public ImageReaderIterator(Iterator it, Object readerExtension) {
            this.it = it;
            this.readerExtension = readerExtension;
        }
    }

    private static final class ImageWriterIterator
    implements Iterator {
        Iterator it;
        Object writerExtension;

        public final boolean hasNext() {
            return this.it.hasNext();
        }

        public final Object next() {
            try {
                return ((ImageWriterSpi)this.it.next()).createWriterInstance(this.writerExtension);
            }
            catch (IOException e) {
                return null;
            }
        }

        public final void remove() {
            throw new UnsupportedOperationException();
        }

        public ImageWriterIterator(Iterator it, Object writerExtension) {
            this.it = it;
            this.writerExtension = writerExtension;
        }
    }

    private static final class ReaderFormatFilter
    implements ServiceRegistry.Filter {
        private String formatName;

        public final boolean filter(Object provider) {
            if (provider instanceof ImageReaderSpi) {
                ImageReaderSpi spi = (ImageReaderSpi)provider;
                String[] formatNames = spi.getFormatNames();
                int i = formatNames.length - 1;
                while (i >= 0) {
                    if (this.formatName.equals(formatNames[i])) {
                        return true;
                    }
                    --i;
                }
            }
            return false;
        }

        public ReaderFormatFilter(String formatName) {
            this.formatName = formatName;
        }
    }

    private static final class ReaderMIMETypeFilter
    implements ServiceRegistry.Filter {
        private String MIMEType;

        public final boolean filter(Object provider) {
            if (provider instanceof ImageReaderSpi) {
                ImageReaderSpi spi = (ImageReaderSpi)provider;
                String[] mimetypes = spi.getMIMETypes();
                int i = mimetypes.length - 1;
                while (i >= 0) {
                    if (this.MIMEType.equals(mimetypes[i])) {
                        return true;
                    }
                    --i;
                }
            }
            return false;
        }

        public ReaderMIMETypeFilter(String MIMEType) {
            this.MIMEType = MIMEType;
        }
    }

    private static final class ReaderSuffixFilter
    implements ServiceRegistry.Filter {
        private String fileSuffix;

        public final boolean filter(Object provider) {
            if (provider instanceof ImageReaderSpi) {
                ImageReaderSpi spi = (ImageReaderSpi)provider;
                String[] suffixes = spi.getFileSuffixes();
                int i = suffixes.length - 1;
                while (i >= 0) {
                    if (this.fileSuffix.equals(suffixes[i])) {
                        return true;
                    }
                    --i;
                }
            }
            return false;
        }

        public ReaderSuffixFilter(String fileSuffix) {
            this.fileSuffix = fileSuffix;
        }
    }

    private static final class WriterFormatFilter
    implements ServiceRegistry.Filter {
        private String formatName;

        public final boolean filter(Object provider) {
            if (provider instanceof ImageWriterSpi) {
                ImageWriterSpi spi = (ImageWriterSpi)provider;
                String[] formatNames = spi.getFormatNames();
                int i = formatNames.length - 1;
                while (i >= 0) {
                    if (this.formatName.equals(formatNames[i])) {
                        return true;
                    }
                    --i;
                }
            }
            return false;
        }

        public WriterFormatFilter(String formatName) {
            this.formatName = formatName;
        }
    }

    private static final class WriterMIMETypeFilter
    implements ServiceRegistry.Filter {
        private String MIMEType;

        public final boolean filter(Object provider) {
            if (provider instanceof ImageWriterSpi) {
                ImageWriterSpi spi = (ImageWriterSpi)provider;
                String[] mimetypes = spi.getMIMETypes();
                int i = mimetypes.length - 1;
                while (i >= 0) {
                    if (this.MIMEType.equals(mimetypes[i])) {
                        return true;
                    }
                    --i;
                }
            }
            return false;
        }

        public WriterMIMETypeFilter(String MIMEType) {
            this.MIMEType = MIMEType;
        }
    }

    private static final class WriterSuffixFilter
    implements ServiceRegistry.Filter {
        private String fileSuffix;

        public final boolean filter(Object provider) {
            if (provider instanceof ImageWriterSpi) {
                ImageWriterSpi spi = (ImageWriterSpi)provider;
                String[] suffixes = spi.getFileSuffixes();
                int i = suffixes.length - 1;
                while (i >= 0) {
                    if (this.fileSuffix.equals(suffixes[i])) {
                        return true;
                    }
                    --i;
                }
            }
            return false;
        }

        public WriterSuffixFilter(String fileSuffix) {
            this.fileSuffix = fileSuffix;
        }
    }

    private static final class ReaderObjectFilter
    implements ServiceRegistry.Filter {
        private Object object;

        public final boolean filter(Object provider) {
            if (provider instanceof ImageReaderSpi) {
                ImageReaderSpi spi = (ImageReaderSpi)provider;
                try {
                    if (spi.canDecodeInput(this.object)) {
                        return true;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return false;
        }

        public ReaderObjectFilter(Object object) {
            this.object = object;
        }
    }

    private static final class WriterObjectFilter
    implements ServiceRegistry.Filter {
        private ImageTypeSpecifier type;
        private String formatName;

        public final boolean filter(Object provider) {
            ImageWriterSpi spi;
            if (provider instanceof ImageWriterSpi && (spi = (ImageWriterSpi)provider).canEncodeImage(this.type)) {
                String[] formatNames = spi.getFormatNames();
                int i = formatNames.length - 1;
                while (i >= 0) {
                    if (this.formatName.equals(formatNames[i])) {
                        return true;
                    }
                    --i;
                }
            }
            return false;
        }

        public WriterObjectFilter(ImageTypeSpecifier type, String formatName) {
            this.type = type;
            this.formatName = formatName;
        }
    }

    private static final class TranscoderFilter
    implements ServiceRegistry.Filter {
        private ImageReader reader;
        private ImageWriter writer;

        public final boolean filter(Object provider) {
            ImageTranscoderSpi spi;
            return provider instanceof ImageTranscoderSpi && (spi = (ImageTranscoderSpi)provider).getReaderServiceProviderName().equals(this.reader.getOriginatingProvider().getClass().getName()) && spi.getWriterServiceProviderName().equals(this.writer.getOriginatingProvider().getClass().getName());
        }

        public TranscoderFilter(ImageReader reader, ImageWriter writer) {
            this.reader = reader;
            this.writer = writer;
        }
    }
}

