/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.metadata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadataFormat;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class IIOMetadataFormatImpl
implements IIOMetadataFormat {
    public static final String standardMetadataFormatName = "javax_imageio_1.0";
    private String rootName;
    private Map nodes;
    private Map childPolicies;
    private Map childRanges;
    private String resourceBaseName;

    protected void addAttribute(String elementName, String attrName, int dataType, boolean required, String defaultValue) {
        IIOMetadataNode node2 = (IIOMetadataNode)this.nodes.get(elementName);
        node2.setAttributeNode(new IIOMetadataNodeAttr(node2, attrName, dataType, required, defaultValue));
    }

    protected void addAttribute(String elementName, String attrName, int dataType, boolean required, String defaultValue, List enumeratedValues) {
        IIOMetadataNode node2 = (IIOMetadataNode)this.nodes.get(elementName);
        node2.setAttributeNode(new IIOMetadataNodeAttrEnumerated(node2, attrName, dataType, required, defaultValue, enumeratedValues));
    }

    protected void addAttribute(String elementName, String attrName, int dataType, boolean required, String defaultValue, String minValue, String maxValue, boolean minInclusive, boolean maxInclusive) {
        IIOMetadataNode node2 = (IIOMetadataNode)this.nodes.get(elementName);
        node2.setAttributeNode(new IIOMetadataNodeAttrBounded(node2, attrName, dataType, required, defaultValue, minValue, maxValue, minInclusive, maxInclusive));
    }

    protected void addAttribute(String elementName, String attrName, int dataType, boolean required, int listMinLength, int listMaxLength) {
        IIOMetadataNode node2 = (IIOMetadataNode)this.nodes.get(elementName);
        node2.setAttributeNode(new IIOMetadataNodeAttrList(node2, attrName, dataType, required, listMinLength, listMaxLength));
    }

    protected void addBooleanAttribute(String elementName, String attrName, boolean hasDefaultValue, boolean defaultValue) {
        IIOMetadataNode node2 = (IIOMetadataNode)this.nodes.get(elementName);
        ArrayList enumeratedValues = new ArrayList();
        enumeratedValues.add("TRUE");
        enumeratedValues.add("FALSE");
        node2.setAttributeNode(new IIOMetadataNodeAttrEnumerated(node2, attrName, 1, hasDefaultValue, defaultValue ? "TRUE" : "FALSE", enumeratedValues));
    }

    protected void addChildElement(String elementName, String parentName) {
        IIOMetadataNode node2 = (IIOMetadataNode)this.nodes.get(parentName);
        node2.appendChild(new IIOMetadataNode(elementName));
        this.childPolicies.put(elementName, new Integer(5));
    }

    protected void addElement(String elementName, String parentName, int childPolicy) {
        IIOMetadataNode node2 = (IIOMetadataNode)this.nodes.get(parentName);
        node2.appendChild(new IIOMetadataNode(elementName));
        this.childPolicies.put(elementName, new Integer(childPolicy));
    }

    protected void addElement(String elementName, String parentName, int minChildren, int maxChildren) {
        this.addChildElement(elementName, parentName);
        this.childRanges.put(elementName, new int[]{minChildren, maxChildren});
    }

    private final void addNodeObject(IIOMetadataNode node2, NodeObject o) {
        node2.setUserObject(o);
    }

    private final NodeObject getNodeObject(IIOMetadataNode node2) {
        return (NodeObject)node2.getUserObject();
    }

    private final void removeNodeObject(IIOMetadataNode node2) {
        node2.setUserObject(null);
    }

    protected void addObjectValue(String elementName, Class classType, boolean required, Object defaultValue) {
        IIOMetadataNode node2 = (IIOMetadataNode)this.nodes.get(elementName);
        this.addNodeObject(node2, new NodeObject(node2, classType, required, defaultValue));
    }

    protected void addObjectValue(String elementName, Class classType, boolean required, Object defaultValue, List enumeratedValues) {
        IIOMetadataNode node2 = (IIOMetadataNode)this.nodes.get(elementName);
        this.addNodeObject(node2, new NodeObjectEnumerated(node2, classType, required, defaultValue, enumeratedValues));
    }

    protected void addObjectValue(String elementName, Class classType, Object defaultValue, Comparable minValue, Comparable maxValue, boolean minInclusive, boolean maxInclusive) {
        IIOMetadataNode node2 = (IIOMetadataNode)this.nodes.get(elementName);
        this.addNodeObject(node2, new NodeObjectBounded(node2, classType, defaultValue, minValue, maxValue, minInclusive, maxInclusive));
    }

    protected void addObjectValue(String elementName, Class classType, int arrayMinLength, int arrayMaxLength) {
        IIOMetadataNode node2 = (IIOMetadataNode)this.nodes.get(elementName);
        this.addNodeObject(node2, new NodeObjectArray((Element)node2, classType, arrayMinLength, arrayMaxLength));
    }

    public String getRootName() {
        return this.rootName;
    }

    protected String getResourceBaseName() {
        return this.resourceBaseName;
    }

    public static IIOMetadataFormat getStandardFormatInstance() {
        return new IIOMetadataFormatImpl(standardMetadataFormatName, 1){

            public final boolean canNodeAppear(String elementName, ImageTypeSpecifier specifier) {
                return true;
            }
        };
    }

    public abstract boolean canNodeAppear(String var1, ImageTypeSpecifier var2);

    protected void removeAttribute(String elementName, String attrName) {
        IIOMetadataNode node2 = (IIOMetadataNode)this.nodes.get(elementName);
        node2.removeAttribute(attrName);
    }

    protected void removeElement(String elementName) {
        this.nodes.remove(elementName);
    }

    protected void removeObjectValue(String elementName) {
        IIOMetadataNode node2 = (IIOMetadataNode)this.nodes.get(elementName);
        this.removeNodeObject(node2);
    }

    protected void setResourceBaseName(String resourceBaseName) {
        this.resourceBaseName = resourceBaseName;
    }

    public int getAttributeDataType(String elementName, String attrName) {
        IIOMetadataNode node2 = (IIOMetadataNode)this.nodes.get(elementName);
        IIOMetadataNodeAttr attr = (IIOMetadataNodeAttr)node2.getAttributeNode(attrName);
        return attr.getDataType();
    }

    public String getAttributeDefaultValue(String elementName, String attrName) {
        IIOMetadataNode node2 = (IIOMetadataNode)this.nodes.get(elementName);
        IIOMetadataNodeAttr attr = (IIOMetadataNodeAttr)node2.getAttributeNode(attrName);
        return attr.getValue();
    }

    public String getAttributeDescription(String elementName, String attrName, Locale locale) {
        return this.getDescription(elementName + '/' + attrName, locale);
    }

    public String[] getAttributeEnumerations(String elementName, String attrName) {
        IIOMetadataNode node2 = (IIOMetadataNode)this.nodes.get(elementName);
        IIOMetadataNodeAttrEnumerated attr = (IIOMetadataNodeAttrEnumerated)node2.getAttributeNode(attrName);
        Object[] attrEnums = attr.getEnumerations();
        String[] attrNames = new String[attrEnums.length];
        int i = 0;
        while (i < attrEnums.length) {
            attrNames[i] = (String)attrEnums[i];
            ++i;
        }
        return attrNames;
    }

    public int getAttributeListMaxLength(String elementName, String attrName) {
        IIOMetadataNode node2 = (IIOMetadataNode)this.nodes.get(elementName);
        IIOMetadataNodeAttrList attr = (IIOMetadataNodeAttrList)node2.getAttributeNode(attrName);
        return attr.getListMaxLength();
    }

    public int getAttributeListMinLength(String elementName, String attrName) {
        IIOMetadataNode node2 = (IIOMetadataNode)this.nodes.get(elementName);
        IIOMetadataNodeAttrList attr = (IIOMetadataNodeAttrList)node2.getAttributeNode(attrName);
        return attr.getListMinLength();
    }

    public String getAttributeMaxValue(String elementName, String attrName) {
        IIOMetadataNode node2 = (IIOMetadataNode)this.nodes.get(elementName);
        IIOMetadataNodeAttrBounded attr = (IIOMetadataNodeAttrBounded)node2.getAttributeNode(attrName);
        return attr.getMaxValue();
    }

    public String getAttributeMinValue(String elementName, String attrName) {
        IIOMetadataNode node2 = (IIOMetadataNode)this.nodes.get(elementName);
        IIOMetadataNodeAttrBounded attr = (IIOMetadataNodeAttrBounded)node2.getAttributeNode(attrName);
        return attr.getMinValue();
    }

    public String[] getAttributeNames(String elementName) {
        IIOMetadataNode node2 = (IIOMetadataNode)this.nodes.get(elementName);
        NamedNodeMap attrNodes = node2.getAttributes();
        String[] attrNames = new String[attrNodes.getLength()];
        int i = 0;
        while (i < attrNodes.getLength()) {
            attrNames[i] = attrNodes.item(i).getLocalName();
            ++i;
        }
        return attrNames;
    }

    public int getAttributeValueType(String elementName, String attrName) {
        IIOMetadataNode node2 = (IIOMetadataNode)this.nodes.get(elementName);
        IIOMetadataNodeAttr attr = (IIOMetadataNodeAttr)node2.getAttributeNode(attrName);
        return attr.getDataType();
    }

    public String[] getChildNames(String elementName) {
        IIOMetadataNode node2 = (IIOMetadataNode)this.nodes.get(elementName);
        NodeList childNodes = node2.getChildNodes();
        String[] childNames = new String[childNodes.getLength()];
        int i = 0;
        while (i < childNodes.getLength()) {
            childNames[i] = childNodes.item(i).getLocalName();
            ++i;
        }
        return childNames;
    }

    public int getChildPolicy(String elementName) {
        return (Integer)this.childPolicies.get(elementName);
    }

    private final String getDescription(String resourceName, Locale locale) {
        if (this.resourceBaseName == null) {
            return null;
        }
        Locale l = locale;
        if (l == null) {
            l = Locale.getDefault();
        }
        ResourceBundle bundle = ResourceBundle.getBundle(this.resourceBaseName, locale);
        String desc = null;
        if (bundle == null) {
            try {
                desc = bundle.getString(resourceName);
            }
            catch (MissingResourceException e) {
                desc = null;
            }
        }
        return desc;
    }

    public String getElementDescription(String elementName, Locale locale) {
        return this.getDescription(elementName, locale);
    }

    public int getElementMaxChildren(String elementName) {
        return ((int[])this.childRanges.get(elementName))[1];
    }

    public int getElementMinChildren(String elementName) {
        return ((int[])this.childRanges.get(elementName))[0];
    }

    public int getObjectArrayMaxLength(String elementName) {
        IIOMetadataNode node2 = (IIOMetadataNode)this.nodes.get(elementName);
        return (Integer)((NodeObjectArray)this.getNodeObject(node2)).getArrayMaxLength();
    }

    public int getObjectArrayMinLength(String elementName) {
        IIOMetadataNode node2 = (IIOMetadataNode)this.nodes.get(elementName);
        return (Integer)((NodeObjectArray)this.getNodeObject(node2)).getArrayMinLength();
    }

    public Class getObjectClass(String elementName) {
        IIOMetadataNode node2 = (IIOMetadataNode)this.nodes.get(elementName);
        return this.getNodeObject(node2).getClassType();
    }

    public Object getObjectDefaultValue(String elementName) {
        IIOMetadataNode node2 = (IIOMetadataNode)this.nodes.get(elementName);
        return this.getNodeObject(node2).getDefaultValue();
    }

    public Object[] getObjectEnumerations(String elementName) {
        IIOMetadataNode node2 = (IIOMetadataNode)this.nodes.get(elementName);
        return ((NodeObjectEnumerated)this.getNodeObject(node2)).getEnumerations();
    }

    public Comparable getObjectMaxValue(String elementName) {
        IIOMetadataNode node2 = (IIOMetadataNode)this.nodes.get(elementName);
        return ((NodeObjectBounded)this.getNodeObject(node2)).getMaxValue();
    }

    public Comparable getObjectMinValue(String elementName) {
        IIOMetadataNode node2 = (IIOMetadataNode)this.nodes.get(elementName);
        return ((NodeObjectBounded)this.getNodeObject(node2)).getMinValue();
    }

    public int getObjectValueType(String elementName) {
        IIOMetadataNode node2 = (IIOMetadataNode)this.nodes.get(elementName);
        NodeObject n = this.getNodeObject(node2);
        if (n == null) {
            return 0;
        }
        return n.getValueType();
    }

    public boolean isAttributeRequired(String elementName, String attrName) {
        IIOMetadataNode node2 = (IIOMetadataNode)this.nodes.get(elementName);
        return ((IIOMetadataNodeAttr)node2.getAttributeNode(attrName)).isRequired();
    }

    private final /* synthetic */ void this() {
        this.nodes = new HashMap();
        this.childPolicies = new HashMap();
        this.childRanges = new HashMap();
    }

    public IIOMetadataFormatImpl(String rootName, int childPolicy) {
        this.this();
        if (rootName == null) {
            throw new IllegalArgumentException("null argument");
        }
        if (childPolicy < 1 || childPolicy > 2 || childPolicy == 5) {
            throw new IllegalArgumentException("wrong child policy");
        }
        this.nodes.put(rootName, new IIOMetadataNode(rootName));
        this.childPolicies.put(rootName, new Integer(childPolicy));
        this.rootName = rootName;
    }

    public IIOMetadataFormatImpl(String rootName, int minChildren, int maxChildren) {
        this.this();
        if (rootName == null) {
            throw new IllegalArgumentException("null argument");
        }
        if (minChildren < 0 || maxChildren < minChildren) {
            throw new IllegalArgumentException("invalid min or max children argument");
        }
        this.nodes.put(rootName, new IIOMetadataNode(rootName));
        this.childPolicies.put(rootName, new Integer(5));
        this.childRanges.put(rootName, new int[]{minChildren, maxChildren});
        this.rootName = rootName;
    }

    static class IIOMetadataNodeAttr
    extends IIOMetadataNode
    implements Attr {
        protected Element owner;
        protected String name;
        protected int dataType;
        protected boolean required;
        protected String defaultValue;

        public String getName() {
            return this.name;
        }

        public Element getOwnerElement() {
            return this.owner;
        }

        public int getDataType() {
            return this.dataType;
        }

        public TypeInfo getSchemaTypeInfo() {
            return null;
        }

        public boolean getSpecified() {
            return false;
        }

        public String getValue() {
            return this.defaultValue;
        }

        public boolean isId() {
            return false;
        }

        public void setValue(String value) {
        }

        public boolean isRequired() {
            return this.required;
        }

        public IIOMetadataNodeAttr(Element owner, String name, String defaultValue) {
            this(owner, name, 0, true, defaultValue);
        }

        public IIOMetadataNodeAttr(Element owner, String name, int dataType, boolean required, String defaultValue) {
            this.owner = owner;
            this.name = name;
            this.dataType = dataType;
            this.required = required;
            this.defaultValue = defaultValue;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class IIOMetadataNodeAttrEnumerated
    extends IIOMetadataNodeAttr {
        protected List enumeratedValues;

        public Object[] getEnumerations() {
            return this.enumeratedValues.toArray();
        }

        public IIOMetadataNodeAttrEnumerated(Element owner, String name, int dataType, boolean required, String defaultValue, List enumeratedValues) {
            super(owner, name, dataType, required, defaultValue);
            this.enumeratedValues = new ArrayList(enumeratedValues);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class IIOMetadataNodeAttrBounded
    extends IIOMetadataNodeAttr {
        protected String minValue;
        protected String maxValue;
        protected boolean minInclusive;
        protected boolean maxInclusive;

        public String getMinValue() {
            return this.minValue;
        }

        public String getMaxValue() {
            return this.maxValue;
        }

        public IIOMetadataNodeAttrBounded(Element owner, String name, int dataType, boolean required, String defaultValue, String minValue, String maxValue, boolean minInclusive, boolean maxInclusive) {
            super(owner, name, dataType, required, defaultValue);
            this.minValue = minValue;
            this.maxValue = maxValue;
            this.minInclusive = minInclusive;
            this.maxInclusive = maxInclusive;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class IIOMetadataNodeAttrList
    extends IIOMetadataNodeAttr {
        protected int listMinLength;
        protected int listMaxLength;

        public int getListMinLength() {
            return this.listMinLength;
        }

        public int getListMaxLength() {
            return this.listMaxLength;
        }

        public IIOMetadataNodeAttrList(Element owner, String name, int dataType, boolean required, int listMinLength, int listMaxLength) {
            super(owner, name, dataType, required, null);
            this.listMinLength = listMinLength;
            this.listMaxLength = listMaxLength;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class NodeObject {
        protected Element owner;
        protected Class classType;
        protected boolean required;
        protected Object defaultValue;
        protected int valueType;

        public int getValueType() {
            return this.valueType;
        }

        public Class getClassType() {
            return this.classType;
        }

        public Element getOwnerElement() {
            return this.owner;
        }

        public Object getDefaultValue() {
            return this.defaultValue;
        }

        public boolean isRequired() {
            return this.required;
        }

        public NodeObject(Element owner, Class classType, boolean required, Object defaultValue) {
            this.owner = owner;
            this.classType = classType;
            this.required = required;
            this.defaultValue = defaultValue;
            this.valueType = 1;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class NodeObjectEnumerated
    extends NodeObject {
        protected List enumeratedValues;

        public Object[] getEnumerations() {
            return this.enumeratedValues.toArray();
        }

        public NodeObjectEnumerated(Element owner, Class classType, boolean required, Object defaultValue, List enumeratedValues) {
            super(owner, classType, false, defaultValue);
            this.enumeratedValues = enumeratedValues;
            this.valueType = 16;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class NodeObjectBounded
    extends NodeObject {
        protected Comparable minValue;
        protected Comparable maxValue;
        protected boolean minInclusive;
        protected boolean maxInclusive;

        public Comparable getMinValue() {
            return this.minValue;
        }

        public Comparable getMaxValue() {
            return this.maxValue;
        }

        public NodeObjectBounded(Element owner, Class classType, Object defaultValue, Comparable minValue, Comparable maxValue, boolean minInclusive, boolean maxInclusive) {
            super(owner, classType, false, defaultValue);
            this.minValue = minValue;
            this.maxValue = maxValue;
            this.minInclusive = minInclusive;
            this.maxInclusive = maxInclusive;
            this.valueType = minInclusive ? (maxInclusive ? 14 : 6) : (maxInclusive ? 10 : 2);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class NodeObjectArray
    extends NodeObject {
        protected Integer arrayMinLength;
        protected Integer arrayMaxLength;

        public Comparable getArrayMinLength() {
            return this.arrayMinLength;
        }

        public Comparable getArrayMaxLength() {
            return this.arrayMaxLength;
        }

        public NodeObjectArray(Element owner, Class classType, int arrayMinLength, int arrayMaxLength) {
            super(owner, classType, false, null);
            this.arrayMinLength = new Integer(arrayMinLength);
            this.arrayMaxLength = new Integer(arrayMaxLength);
            this.valueType = 32;
        }
    }
}

