// This is meant to illustrate the the
// effect of the closed keyword.
#version unofficial MegaPov 0.4;

#include "colors.inc"
#include "skies.inc"

camera {location <4.5, 4.5, 4.5> look_at <0.3, 1.3, 0> }

light_source { <-15, 30, -25> color red 1 green 1 blue 1 }
light_source { < 15, 30, -25> color red 1 green 1 blue 1 }
light_source { < -1, 1, 10> color red 1 green 1 blue 1 }
light_source { < 0, 1, 0> color red 1 green 1 blue 1 }

#init_3d_spline {"My_Spline",closed
	#declare c=0;
    #while (c<1.001) 
		,<2*sin(15*c),c*3,2*cos(15*c)>
		#declare c=c+0.05;
	#end
	}


#init_spline {"Thickness",closed=1,<0,0.1>,<0.3,0.3>,<0.6,0.2>}

blob {
  threshold 0.6
  #declare c=0;
  #while (c<1)
   sphere { eval_3d_spline("My_Spline",c),eval_spline("Thickness",c),1.5 }
   #declare c=c+0.001;
  #end
  texture {
    finish {
      ambient 0.3
      diffuse 0.8
      phong 1
    }
    normal {
      bumps 0.4
      sine_wave
      scale 0.08
    }
    pigment { color Red }
  }
}

sky_sphere { S_Cloud5 }
