//	Persistence of Vision Ray Tracer Scene Description File
//	File: trace_hf_pattern.pov
//	Date: 15/11/99
//	Demo showing the use of pattern and trace function.
	
#version unofficial MegaPov 0.4;


camera {
	location <0.0, 1.5, -1.8>
	angle 40
	look_at  <0.0, 0.0, 0.0>
}

light_source {
	<20, 80, -40>
	rgb <1.0, 1.0, 1.0>*1.3 
}

#declare Scape =
	height_field {
		pattern 400, 400 {
			hf_gray_16
			leopard
			color_map {
				[ 0.0 color rgb 0.25 ]
				[ 0.2 color rgb 0.05 ]
				[ 1.0 color rgb 0.0 ]
			}
			scale 0.1
		}
		texture { pigment { rgb 0.82} }
		translate <-0.5, -0.3, -0.5>
		no_image				//switch off to show height_field
	}
	
object { Scape } 
	
#declare j = 0;
#declare Depth = 70;
#while (j <= Depth)
	#declare i = 0;
	#declare Nr = 70;
	#while (i <= Nr)	
		#declare Norm = <0, 0, 0>;
		#declare Start = <-0.5+(i/Nr), 0.5, -0.5+(j/Depth)>;
		#declare Inter = 
			trace ( Scape, Start, <0.0, -1.0, 0.0> , Norm);	//find intersection points with hf surface
			
		#if (Norm.x != 0 | Norm.y != 0 | Norm.z != 0) 
			sphere {		//spheres placed on the intersection points with the hf surface
				Inter+0.025*y, 0.01
				texture {
					pigment { rgb <1, 0, 0> }
					finish { phong 1.0 phong_size 400 }
				}
			}
		#end 
		#declare i=i+1;
	#end
	#declare j=j+1;	
#end
	