//	Persistence of Vision Ray Tracer Scene Description File
//	File: double_illuminate.pov
//	Date: 15/11/99
//	Demo double_illuminate
	
#version unofficial MegaPov 0.4;


camera {
	location < 0.0, 5, -2.5 >

	up image_height*y
	right image_width*x
	angle 35
	look_at < 0.0, 0.0, 0.0 >
}

light_source {		//lighting from the back
	<0.0, -5, 50>
	rgb 1
	spotlight
 	point_at <0.0, 0.0, -5>
	radius 10
	falloff 40
	tightness 5
}
light_source {
	<0.0, -30, -10>
	rgb 1
	spotlight
 	point_at <0.0, 0.0, 0.0>
	radius 10
	falloff 40
	tightness 5
}
background { rgb <0.915999, 0.915984, 0.684001> }

//Left patch double_illuminated (light from the back)
bicubic_patch  {
	type 1
	flatness 0.0
	u_steps 4	v_steps 4
		< -0.5, 1.0, 0.5 >,	< -0.5, 0.0, 0.33 >,	< -0.5, 0.0, -0.33 >,< -0.5, 0.2, -1.5 >,
		< -0.33, 1.0, 0.5 >,	< -0.33, 0.0, 0.33 >,	< -0.33, 0.0, -0.33 >,< -0.33, -0.1, -0.5 >,
		< 0.33 , 1.0, 0.5 >,		< 0.33, 0.0, 0.33 >,		< 0.33, 0.0, -0.33 >,	< 0.33, -0.1, -0.5 >,
		< 0.5, 1.0, 0.5 >,	< 0.5, 0.0, 0.33 >,	< 0.5, 0.0, -0.33 >,< 0.5, 0.2, -1.5 >			
	uv_mapping
	texture {
		pigment  {
			gradient <0.0, 1.0,  0.0>
			color_map {
				[0.000 color rgbft <1.0, 0.5, 1.0, 0.0, 0.3 > ]	//violet 1
				[0.100 color rgbft <1.0, 0.5, 1.0, 0.0, 0.3 > ]	//violet 2
				[0.214 color rgbft <0.5, 0.5, 1.0, 0.0, 0.3 > ]	//indigo
				[0.328 color rgbft <0.2, 0.2, 1.0, 0.0, 0.3 > ]	//blue
				[0.442 color rgbft <0.2, 1.0, 1.0, 0.0, 0.3 > ]	//cyan
				[0.556 color rgbft <0.2, 1.0, 0.2, 0.0, 0.3 > ]	//green
				[0.670 color rgbft <1.0, 1.0, 0.2, 0.0, 0.3 > ]	//yellow
				[0.784 color rgbft <1.0, 0.5, 0.2, 0.0, 0.3 > ]	//orange
				[0.900 color rgbft <1.0, 0.2, 0.2, 0.0, 0.3 > ]	//red1
				[1.000 color rgbft <1.0, 0.2, 0.2, 0.0, 0.3 > ]	//red2
			}
			ramp_wave
		}

	}
	translate x*-0.6
	double_illuminate
}

//Right patch NOT double_illuminated
bicubic_patch  {
	type 1
	flatness 0.0
	u_steps 4		v_steps 4
		< -0.5, 1.0, 0.5 >,	< -0.5, 0.0, 0.33 >,	< -0.5, 0.0, -0.33 >,< -0.5, 0.2, -1.5 >,
		< -0.33, 1.0, 0.5 >,	< -0.33, 0.0, 0.33 >,	< -0.33, 0.0, -0.33 >,< -0.33, -0.1, -0.5 >,
		< 0.33 , 1.0, 0.5 >,		< 0.33, 0.0, 0.33 >,		< 0.33, 0.0, -0.33 >,	< 0.33, -0.1, -0.5 >,
		< 0.5, 1.0, 0.5 >,	< 0.5, 0.0, 0.33 >,	< 0.5, 0.0, -0.33 >,< 0.5, 0.2, -1.5 >			
	uv_mapping
	texture {
		pigment  {
			gradient <0.0, 1.0,  0.0>
			color_map {
				[0.000 color rgbft <1.0, 0.5, 1.0, 0.0, 0.3 > ]	//violet 1
				[0.100 color rgbft <1.0, 0.5, 1.0, 0.0, 0.3 > ]	//violet 2
				[0.214 color rgbft <0.5, 0.5, 1.0, 0.0, 0.3 > ]	//indigo
				[0.328 color rgbft <0.2, 0.2, 1.0, 0.0, 0.3 > ]	//blue
				[0.442 color rgbft <0.2, 1.0, 1.0, 0.0, 0.3 > ]	//cyan
				[0.556 color rgbft <0.2, 1.0, 0.2, 0.0, 0.3 > ]	//green
				[0.670 color rgbft <1.0, 1.0, 0.2, 0.0, 0.3 > ]	//yellow
				[0.784 color rgbft <1.0, 0.5, 0.2, 0.0, 0.3 > ]	//orange
				[0.900 color rgbft <1.0, 0.2, 0.2, 0.0, 0.3 > ]	//red1
				[1.000 color rgbft <1.0, 0.2, 0.2, 0.0, 0.3 > ]	//red2
			}
			ramp_wave
		}
	}
	translate x*0.6
}
