// Persistence Of Vision raytracer version 3.1e (isosurface patch)
// sample file by R.Suzuki   <rsuzuki@etl.go.jp>  Apr.'99
#version unofficial MegaPov 0.4;

camera {
	location <15, 25, -10>
	angle 25
	look_at <0, 0, 0>
}

light_source {<-50, 40, -20> color <1,1,1>}
light_source {<  0, 50, -50> color <1,1,1>}
background {color <0.2,0.3,0.42>}

#declare TH=function{"TH"}
#declare R=function{"R"}
#declare PH=function{"PH"}

isosurface {
     function{cos(TH*7)*0.2+min(abs(R-1.5),abs(R-3))+y*y}
     contained_by{ box {<-3.7, -0.5, -3.7>, <3.7, 0.5, 3.7>}}
//     eval
     threshold    0.5 
     accuracy 0.02
     max_gradient 1.7
     pigment {colour <0.8,0.5,0.2>}
     finish {ambient 0.2 phong 0.2}
     scale <1.25,1,1.25>
}
