// Persistence Of Vision raytracer version 3.1e (isosurface patch)
// sample file by R.Suzuki   <rsuzuki@etl.go.jp>  Apr.'99
#version unofficial MegaPov 0.4;

#include "colors.inc"

camera {
	location <65, 25, 35>
	direction <0, 0, 5.0>
	look_at <0,0,0>
}

light_source {<40, 180, 10> color White*0.8}
light_source {<-20, 40, 120> color White}
light_source {<80, 20, 80> color White*0.8}
background {color <0.35, 0.42, 0.34>}

#declare GRID1=    function  {min(min(abs(cos(z)), abs(cos(y))),abs(cos(x)))}
#declare S1= function{ - exp(-x*x-y*y-z*z) 
                        +(exp(-x*x*4-z*z*4)+exp(-y*y*4-z*z*4)+exp(-x*x*4-y*y*4))*0.5+0.175}

isosurface { function {S1}
     contained_by{box{<-0.9,-0.9,-0.9>, <0.9,0.9,0.9>}}
     method 2  
     eval
     pigment { function  {GRID1}
        color_map {[0.0, 0.05  color <.2, .2, .2> color <  1,   1, 1>]
                  [0.05, 1    color <1, 1, 1>    color <1, 0.5, 0>]}
        frequency 0.2       
        scale 0.04     
     }
     normal {       
         function GRID1
         slope_map { [0 <0,-1>]  [0.1 <-1,-1>]  [0.1 <-1, 1>]  [1 <0, 1>] }
         scale 0.04    
     }     
     finish {ambient 0.3}     
     finish {phong 0.8}
     scale 5.5
}
