//	Persistence of Vision Ray Tracer Scene Description File
//	File: var_reflect.pov
//	Date: 11-05-2000
//	Author: R. Smellenbergh
// Demo of angle dependent reflection

#version unofficial MegaPov 0.5;

camera {
	location <0.0, 0.0, -50>
	up y*image_height right x*image_width
	angle 50
	look_at <0.0, 0.0, 0.0>
	rotate x*11
}

light_source { <-1000, 200, -750> rgb 1.0 }
	

//Water with variable reflection
plane {
	<0.0, 1.0, 0.0>, 0
	texture{
		pigment { rgbt <1.0, 1.0, 1.0, 0.9> }
		//normal { ripples 0.06 turbulence 0.5 scale 0.45 }
		normal { granite 0.06 scale 20 }
		finish {
			ambient 0.05
			brilliance 1
			diffuse 0.2
			phong 1.0 phong_size 600
			reflection_type 1
			reflection_min 0.0
			reflection_max 1.0
			conserve_energy
	   }
	}
	interior { ior 1.3 }
}

//Lake bottom
plane {
	<0.0, 1.0, 0.0>, -10
	texture {
		pigment  {
			crackle
			color_map {
				[ 0.0 color rgb < 0.98, 0.88, 0.78 > ]
				[ 0.8 color rgb < 0.925002, 0.829969, 0.774975 > ]
				[ 1.0 color rgb < 0.895003, 0.658137, 0.404974 > ]
			}
			ramp_wave
			scale 0.15
		}
		normal  {
			gradient < 0.0, 0.0, 1.0 >
			1.5 //amount
			slope_map {
				[ 0.0, < 0.0, 0.0 >]
				[ 0.76531, < 0.26789, 0.09474 >]
				[ 1.00000, < -0.00000, 0.0 >]
			}
			frequency 2.4
			turbulence <0.15, 0.25, 0.2>
			scale <5, 5, 5>
		}
		finish {
			diffuse 0.7
			ambient 0.3
			roughness 0.05
			crand 0.08
		}
		rotate y*-170
	}
	rotate x*20
}

#include "colors.inc"
#include "skies.inc"
sky_sphere { S_Cloud2 rotate x*4 }

//******************** START OBJECT SPLINE ********************
#declare SplineScale = 40;
#declare Stretch = 5;
#declare POINTS = array [6] 
{
	<0.95968, 0.01210* Stretch > * SplineScale,
	<0.92742, 0.06452* Stretch > * SplineScale,
	<0.32258, 0.25403* Stretch > * SplineScale,
	<0.58871, 0.66935* Stretch > * SplineScale,
	<0.10887, 0.93145* Stretch > * SplineScale,
	<0.15323, 0.61694* Stretch > * SplineScale
}

#declare Numbers = 8;
#declare Segmts = dimension_size (POINTS,1)-3;
#declare Copies =  ((Numbers)*Segmts)+1;	
#declare Pass = 0;
#while ( Pass < Segmts)
	#declare Va = 1 + Pass;
	#declare To = 0 + (1/Numbers);
	#declare LoopEnd = 1.00000001;
	#while (To < LoopEnd)
		cylinder {
			<0, 0, 40>, <0, 0, -8>, 0.7
			texture {
				pigment {
					agate
					agate_turb 0.8
					color_map {
						[ 0.0 rgb <0.923308, 0.882429, 0.816678> ]
						[ 0.12 rgb <0.915007, 0.866819, 0.744991> ]
						[ 0.23 rgb <0.929503, 0.852628, 0.770474> ]
						[ 0.5 rgb <0.920699, 0.861540, 0.819287> ]
						[ 0.7 rgb <0.962203, 0.922469, 0.897780> ]
						[ 1.0 rgb <0.926406, 0.808301, 0.753582> ]
					}
					scallop_wave
					scale <0.1, 0.1, 0.1>
				}
				finish { ambient 0.05 }
			}
			#declare As = -0.5 *POINTS [Va-1].x + 1.5 *POINTS [Va].x - 1.5 *POINTS [Va+1].x + 0.5 *POINTS [Va+2].x;
			#declare Bs = POINTS [Va-1].x - 2.5 *POINTS [Va].x + 2.0 *POINTS [Va+1].x - 0.5 *POINTS [Va+2].x;
			#declare Cs = -0.5 * POINTS [Va-1].x + 0.5 *POINTS [Va+1].x;
			#declare Ds = POINTS [Va].x;
			#declare As2 = -0.5 *POINTS [Va-1].y + 1.5 *POINTS [Va].y - 1.5 *POINTS [Va+1].y + 0.5 *POINTS [Va+2].y;
			#declare Bs2 = POINTS [Va-1].y - 2.5 *POINTS [Va].y + 2.0 *POINTS [Va+1].y - 0.5 *POINTS [Va+2].y;
			#declare Cs2 = -0.5 *POINTS [Va-1].y + 0.5 *POINTS [Va+1].y;
			#declare Ds2 = POINTS [Va].y;
				#declare Tu = As*To*To*To+Bs*To*To+Cs*To+Ds;
				#declare Tv = As2*To*To*To+Bs2*To*To+Cs2*To+Ds2;
				#declare Tw = 5.8;
			translate <Tu, Tv, Tw> 
			rotate x*90	//flip to XZ-plane
				translate <-24, 0, -30>
		} //object
		#declare To = To +(1/Numbers);
	#end	//while To < LoopEnd
	#declare Pass = Pass + 1;
#end  //while  Pass < Segmts
//******************** END OBJECT SPLINE ********************

