#include "colors.inc"
#version unofficial MegaPov 0.4;
camera {
	location < 0, 0.0, -40 >
	angle 35
	look_at < 0, 0, 0 >
	rotate x*25
}

#declare Func = 0;
#declare falloffAmt = 3;

box {< -10, -10, 0>, < 10, 10, 1>
	texture {
		pigment {
			blob {
			#declare C = 0;
			#declare Copies = 10;
			#while ( C < Copies)
				cylinder {
					<0, -8, 0>, <0, 8, 0>, 0.5, 1
					density_function Func, falloffAmt
					translate x * (-8 + (C * (8 - (-8))/(Copies -1)))
				} //object
				#declare C = C +1;
			#end  //while (C < Copies)
			#declare C2 = 0;
			#while ( C2 < Copies)
				cylinder {
					<-8, 0, 0>, <8, 0, 0>, 0.5, 1
					density_function Func, falloffAmt
					translate y * (-8 + (C2 * (8 - (-8))/(Copies -1)))
				} //object
				#declare C2 = C2 +1;
			#end  //while (C2 < Copies)
			threshold 1.0
			max_density 0
			}
			ramp_wave
			color_map {
				[0.00 color Red]
				[0.33 color Blue]
				[0.66 color Yellow]
				[1.00 color Red]
			}
		}
		finish {ambient 1}
	}
}
