//	Persistence of Vision Ray Tracer Scene Description File
//	File: glowlits.pov
//	Date: 27-09-2000
//	Author: Chris Huff
//	Demo: glows assigned to light_sources

#version unofficial MegaPov 0.6;

global_settings {
	assumed_gamma 1.8
}

//#include "colors.inc"

camera {
	location <-5, 6,-18>
	look_at < 0, 1.5, 0>
	angle 45
}

//Types:
#declare Float = 0;
#declare Vector = < 0, 0, 0>;
#declare Color = color rgb < 0, 0, 0>;

#macro SRand(RS) (rand(RS)*2 - 1) #end
#macro RRand(RS, Min, Max) (rand(RS)*(Max-Min) + Min) #end
#macro Clamp(V, Min, Max) (min(Max, max(Min, V))) #end
#macro Range(V, Rmn, Rmx) (V*(Rmx-Rmn) + Rmn) #end
#macro RClamp(V, Rmn, Rmx, Min, Max) (Clamp(Range(V, Rmn, Rmx), Min, Max)) #end

#declare RsA = seed(574647);

#declare J = Float;
#declare J = 0;
#while(J<52)
	light_source {< SRand(RsA)*8, rand(RsA)*4, SRand(RsA)*8> color rgb 0.045*< rand(RsA), rand(RsA), rand(RsA)>
		glow {size rand(RsA)*0.65 type int(rand(RsA))}
		fade_distance 4 fade_power 2
	}
	#declare J = J + 1;
#end

box {<-15, 0,-10>, < 15, 0, 10>
	pigment {checker color rgb 0.05, color rgb 1}
	finish {
		reflection 0.75 diffuse 0.25 ambient 0
		metallic reflect_metallic
	}
}

sphere {< 0, 2, 0>, 2
	pigment {rgb 1}
	finish {
		reflection 0.85 diffuse 0.15 ambient 0
		metallic reflect_metallic
	}
}
