//	Persistence of Vision Ray Tracer Scene Description File
//	File: obj_controls.pov
//	Date: 14/11/99
//	Showing no_image, no_reflection, no_shadow and projected through
	
#version unofficial MegaPov 0.4;


camera {
	location <0.0, 3, -20>

	up image_height*y right image_width*x
	look_at <0.0, 0.0, 0.0>
	angle 25
}

light_source {
	<0.0, 50, -50>
	rgb <1.0, 1.0, 1.0>*1.2
}

box {		//bottom
	<-30, -1.1, 1.5>, <30, -1.0, 20>
	texture {
		pigment { rgb 0.75 }
		finish { reflection 0.7 diffuse 0.3}
	}
}
box {		//back
	<-30, -1.0, 20>, <30, 10, 20.5>
	texture { pigment { rgb 0.75 } }
	no_reflection
}
cylinder {		//To show projected_through text object
	<-30, 1.5, 0>, <30, 1.5, 0>, 0.4
	scale <1, 1, 0.5>
	translate z*20
	no_reflection
	texture { pigment { rgb 0.75 } }
}

#declare Offset = 5.6;
#declare Sphere =
	sphere  {
		<0.0, 0.0, 12>, 0.7
		texture {
			pigment {
				gradient <0.0, 1.0,  0.0>
				color_map {
					[0.000 rgbft <1.0, 0.5, 1.0, 0.0, 0.0> ]	//violet 1
					[0.100 rgbft <1.0, 0.5, 1.0, 0.0, 0.0> ]	//violet 2
					[0.670 rgbft <1.0, 1.0, 0.2, 0.0, 0.0> ]	//yellow
					[0.784 rgbft <1.0, 0.5, 0.2, 0.0, 0.0> ]	//orange
					[0.900 rgbft <1.0, 0.2, 0.2, 0.0, 0.0> ]	//red1
					[1.000 rgbft <1.0, 0.2, 0.2, 0.0, 0.0> ]	//red2
				}
				scale <0.5, 0.5, 0.5>
			}
		}
	}
	
#declare NoReflect =
	text {
		ttf "Arial.ttf", "no_reflection"
		0.5, <0.0, 0.0, 0.0>
		position 1
		texture { pigment { rgb 1.2 } }
		scale <0.25, 0.3, 0.2>
		rotate x*20
		translate z*-1
		no_reflection
	}
	
#declare NoShadow =
	text  {
		ttf "Arial.ttf", "no_shadow"
		0.4, <0.0, 0.0, 0.0>
		position 1
		texture { pigment { rgb 0.95 } }
		scale <0.25, 0.3, 0.2>
		rotate x*20
		translate <0, -0.4,-1.0>
		no_reflection
	}
	
#declare NoImage =
	text  {
		ttf "Arial.ttf", "no_image"
		0.4, <0.0, 0.0, 0.0>
		position 1
		texture { pigment { rgb 0.95 } }
		scale <0.25, 0.3, 0.2>
		rotate x*20
		translate <0, -0.8, -1.0>
		no_reflection
	}

//Sphere giving no reflection
object { Sphere translate x*-Offset no_reflection /*light_group "!Slide"*/}
object { NoReflect translate <-Offset/1.6, -1.15, 0> }

//Sphere casting no shadow
object { Sphere translate x*-Offset/2 no_shadow /*light_group "!Slide"*/}
object { NoShadow translate <-Offset/3, -1.15, 0> }

//Invisible sphere, reflected and casting shadow
object { Sphere translate x*0 	no_image 	light_group "!Slide" }
object { NoImage translate <0, -1.15, 0> }

//Invisible sphere without shadow and not reflected
object { Sphere translate x*Offset/2 no_shadow no_image no_reflection}
object { NoReflect translate <Offset/3, -1.15, 0> }
object { NoShadow translate <Offset/3, -1.15, 0> }
object { NoImage translate <Offset/3, -1.15, 0> }

//Invisible sphere reflected and casting shadow
//Box without shadow and not reflected at the same spot
object { Sphere translate x*Offset  no_image light_group "!Slide"}
box {
	<-0.36, -0.25, -0.36>, 0.36
	scale 2.0
	rotate y*-30
	pigment { rgb <0, 0, 1> }
	translate <Offset, 0, 12>
	no_shadow
	no_reflection
	light_group "!Slide"
}
text  {
	ttf "Arial.ttf", "box"
	0.4, < 0.0, 0.0, 0.0 >
	position 1
	texture { pigment { rgb 0.95 } }
	scale <0.25, 0.2, 0.2>
	rotate x*20
	translate <Offset/1.6, -0.85, -1.0>
}

object { NoReflect translate <Offset/1.6, -1.15, 0> }
object { NoShadow translate <Offset/1.6, -1.15, 0> }
text  {
	ttf "Arial.ttf", "sphere"
	0.4, < 0.0, 0.0, 0.0 >
	position 1
	texture { pigment { color rgb 0.95} }
	scale <0.25, 0.2, 0.2>
	rotate x*20
	translate <Offset/1.6, -1.15-0.8, -1.0>
}
object { NoImage translate <Offset/1.6, -1.55, 0> }

//Light of "shape" will be projected through this text object 
#declare ProTru =
	text  {
		ttf "Arial.ttf", "projected_through"
		0.2, <0.0, 0.0, 0.0>
		position 1
		texture { finish { ambient 0.0 } }	//Make object completely dark
		translate <0, 2.0, 10>
		light_group "shape"
	}

light_source {
	<0.0, 5, -20>
	rgb <1, 0, 0>
	color_map {
		[ 0.0 rgb <0, 0, 0> ]
		[ 0.35 rgb <0.159579, 0.960403, 0.626688> ]
		[ 0.4 rgb <0.8, 0.9, 0.4> ]
		[ 1.0 rgb <1, 0, 0> ]
	}
	spotlight
 	point_at <0.0, 2.0, 20>
	radius 10 	falloff 15 tightness 10
	groups "shape"
	projected_through { ProTru }	//This light goes through the ProTru object
}

