// Persistence Of Vision raytracer version 3.1e (isosurface patch)
// sample file.
// By R.Suzuki
#version unofficial MegaPov 0.4;
global_settings { assumed_gamma 1.8 }

camera {  
	location <20, 20, -26>
	angle 25
	look_at <0,0,0>
}

light_source { <140, 160, -110> color rgb <1.0, 1.0, 1.0>*1.2 }
light_source { <-10, 20, 50> color rgb <1.0, 1.0, 1.0> }

background { color red 0.184314 green 0.309804 blue 0.309804 }

//=====================================
//   mesh1
//     P0:   period X
//     P0:   period Y
//     P2:   shape parameter : use with "eval"
//     P3:   amplitude
//     P4:   shape parameter2
//=====================================

isosurface {
	function { "mesh1", <1, 1, 1, 0.17,  1> }
	contained_by { box { <-5, -0.35, -5>, <5, 0.35, 5> } }
	eval
	threshold 0.18
	texture {
		pigment { color red 1.0 green 0.8 blue 0.5 }
		finish { phong 0.6 }
	}
	translate <0, -1.4, 0>
}

isosurface {
	function { "mesh1", <0.5, 0.5, 1, 0.0,  1> }
	contained_by { box { <-2.0, -0.08, -2.0>, <2.0, 0.08, 2.0> } }
	open
	threshold 0.08
	texture {
		pigment { color red 0.6 green 0.6 blue 1.0 }
		finish { phong 0.6 }
	}
	scale 2
	translate <0, 3.0, 0>
}

