//	Persistence of Vision Ray Tracer Scene Description File
//	Isosurface function demo
#version unofficial MegaPov 0.4;
	
#include "colors.inc"
#include "textures.inc"

#version 3.1;
#default { texture { pigment { color rgb < 1, 0, 0 > } finish { ambient 0.4 } } }

camera {
	perspective 
	location < 0.0, 0.25, -2 >
	up y*image_height right x*image_width
	angle 45
	look_at < 0.0, 0.0, 0.0 >
	rotate y*3.5
}

light_source {
	< 0.0, 100, -100 >
	color rgb < 1.0, 1.0, 1.0 > 
	area_light < 50, 0.0,  0.0 >,   < 0.0,  50, 0.0 >,  8,  8
	adaptive 2
	jitter 
}

isosurface {
	function {
		abs(x*y*(x+y)*(x-y))
	}
	contained_by { sphere  { < 0.0, 0.0, 0.0 >, 0.6 } }
	accuracy 0.0001
	threshold 0.0000075
	eval
	texture { 
		pigment  {
			onion
			color_map {
				[0.000 color rgbft <1.0, 0.5, 1.0, 0.0, 0.0 > ]	//violet 1
				[0.100 color rgbft <1.0, 0.5, 1.0, 0.0, 0.0 > ]	//violet 2
				[0.214 color rgbft <0.5, 0.5, 1.0, 0.0, 0.0 > ]	//indigo
				[0.328 color rgbft <0.2, 0.2, 1.0, 0.0, 0.0 > ]	//blue
				[0.442 color rgbft <0.2, 1.0, 1.0, 0.0, 0.0 > ]	//cyan
				[0.556 color rgbft <0.2, 1.0, 0.2, 0.0, 0.0 > ]	//green
				[0.670 color rgbft <1.0, 1.0, 0.2, 0.0, 0.0 > ]	//yellow
				[0.784 color rgbft <1.0, 0.5, 0.2, 0.0, 0.0 > ]	//orange
				[0.900 color rgbft <1.0, 0.2, 0.2, 0.0, 0.0 > ]	//red1
				[1.000 color rgbft <1.0, 0.2, 0.2, 0.0, 0.0 > ]	//red2
			}
		}
	}
	scale <1, 1, 0.8>
}
