// Start of PoV code
// ==== Standard POV-Ray Includes ====
#version unofficial MegaPov 0.4;

#include "colors.inc"    // Standard Color definitions
#include "textures.inc"    // Standard Texture definitions

camera {
  location  <0.0 , 20.0 ,-50.0>
  direction <0.0 , 0.0 , 1.0>
  look_at   <0.0 , 40.0 , 0.0>
}

global_settings { assumed_gamma 1.0 }

#declare LightLoc = <-20000, 40000, -20000>;

fog {
    distance 200
// The next line is used by my fog extension to 
// say how much colour is to be added ...
//    use_colour 0.5
    color SkyBlue /*rgb 0.3 transmit 0.0*/
    fog_type 2
    fog_offset -20 // 50
    fog_alt 40
}

// Cloud function: Lambda, octaves, omega, octave offset, ridge offset.
#declare FNC = function { "ridge", <3,5,1/2.5,0.0,0.5> }

#declare C = clock;

isosurface {
// this gives a flat bottom, taller top, sheered right. Experiment!
    function { 
        max(y*0.1,-cub(y)) 
        - FNC(x*0.1-y*0.1-C*5,y*0.1-C,z*0.1) 
        + 0.6 
    }
    contained_by { box { <-300,-1.1,-300>, <300,10.5,500> } }
    eval
    accuracy 0.0001
    texture {
        pigment { 
            slope 4*vnormalize(LightLoc), y, <0,1>, <-1,10>
            colour_map {
                [0   White*1.2]
                [0.4 White*1.5 ]
                [0.7 White*3 transmit 0.6]
                [1.0 SkyBlue transmit 1.0]
            }
        }
        finish { ambient 0.6 diffuse 0.0 reflection 0 metallic }
    }
    translate 200*z
    scale 10
    translate -100*z
    translate 100*y
}

background {color SkyBlue}

// End of PoV code
//
//    Have fun!
//
//        Mike Andrews.
