//	Persistence of Vision Ray Tracer Scene Description File
//	File: ridged_mf.pov
//	Date: 18/01/2000
//	Demo scene for ridged multifractal
//	Needs isosurface with build in "ridgedmf" function (MegaPov 0.4)
#version unofficial MegaPov 0.4;

camera {
	location <3,4.5,-5.25>
	angle 45
	look_at <0,0,0>
}

light_source {<-10,70,-40> rgb 1}
light_source {<-20,70,-40> rgb 1}

#declare H = 0.3;
#declare Lac = 2.0; 
#declare Octs = 5;
#declare Offset = 0.3;
#declare G= 1.0;

#declare F0=function{"ridgedMF",<H, Lac, Octs,Offset, G>}

isosurface {
	function {y-F0(x,0,z)}
	method 2
	eval
	accuracy 0.0001
	normal on
	contained_by{box{<-2, 0, -2>, <2, 2, 2>}}
	pigment {color red 0.647059 green 0.164706 blue 0.164706} 
}       

background {color red 0.196078 green 0.6 blue 0.8}