//	Persistence of Vision Ray Tracer Scene Description File
//	File: photon_group.pov
//	Date: 29/01/2000
// Author: Ren Smellenbergh
//	Demo: using light_groups with photons.
	
#version unofficial MegaPov 0.4;

global_settings {
	assumed_gamma  1.8
	photons {
		count 100000
		autostop 0.5
		jitter 1.0
		expand_thresholds 0.2, 40
		max_trace_level 20
	}
}

camera {
	location < 0.0, 0, -22>
	angle 40
	look_at < 0.0, 0.0, -3 >
	rotate x*35
}

#declare Tile =
	box {
		<-3, -0.1, -3>, <3, 0.0, 3>
		texture {
			pigment { rgb 1 }
			finish { ambient 0.12 }
		}
		translate y*-0.4
	}
	
#declare Sphere =
	 sphere {
		<0.0, 1.0, 0.0>, 1.0
		texture {
			pigment { rgbft <1.0,1.0,1.0,0.7,1.0>}
			finish  { reflection rgb 0.2 }
		}
		interior { ior 1.544 }
		photons {
			target 1.1
			refraction on
			reflection on
//			ignore_photons
		}
	}

//***************** BACK ROW  *********************
//************ Left back = green spot *****************
light_source {
	<-3.0, 3, 3>
	rgb <0.0, 1.0, 0.0>
	spotlight
 	point_at <-3.0, 0.0, 3>
	radius 40 	falloff 90 tightness 6
	photons { reflection on refraction on }
	groups "SpotPar"
}
object {
	Sphere
	translate <-3.0, 0.0, 3.0>
	light_group "SpotPar"
}
object {
	Tile
	translate <-3, 0, 3>
	light_group "SpotPar"
}

//********* Right back = red point light *****************
light_source {
	<3.0, 4, 3>
	rgb <1.0, 0.0, 0.0> 
	photons { reflection on refraction on }
	groups "Point"
}
object {
	Sphere
	translate <3.0, 0.0, 3.0>
	light_group "Point"
}
object {
	Tile
	translate <3, 0, 3>
	light_group "Point"
}

//***************** FRONT ROW *********************
//************* Left front = blue cylinder **************
light_source {
	<-3.0, 3, -3>
	rgb <0.0, 0.0, 1.0>*0.8
	cylinder
	point_at <-3.0, 0, -3>
	radius 60 	falloff 100 tightness 4
	photons { reflection on refraction on }
	groups "Cylinder"
}

object {
	Sphere
	translate <-3.0, 0.0, -3.0>
	light_group "Cylinder"
}
object {
	Tile
	translate <-3, 0, -3>
	light_group "Cylinder"
}

//************** Right front = yellow cylinder **********
light_source {
	<3.0, 4, -3>
	color rgb <1.0, 1.0, 0.0>*0.4 
	cylinder
	point_at <3.0, 0, -3>
	radius 60 	falloff 100 tightness 4
	photons { reflection on refraction on }
	groups "PointPar"
}
object {
	Sphere
	translate <3.0, 0.0, -3.0>
	light_group "PointPar"
}
object {
	Tile
	translate <3, 0, -3>
	light_group "PointPar"
}

//******* Central sphere = white point light ***************
light_source {
	< 0.5, 5, -3 >
	rgb <1.0, 1.0, 1.0>
	photons { reflection on refraction on }
	groups "Center"
}
object {
	Sphere
	translate y*-1
	scale <1.4, 0.3, 1.4>
	translate y*-0.4
	light_group "Center"
}

