//	Persistence of Vision Ray Tracer Scene Description File
#version unofficial MegaPov 0.4;

/*
  Sphere and Cylinder Scene
  for testing photon mapping
  
  Nathan Kopp
  Spring, 1999
*/

#declare refl=on;

global_settings {
  max_trace_level 4
  ambient_light 1.3

  photons {
  #if(0)
	spacing 0.05
    gather 20, 100
    autostop 0
    jitter 0.9
    load_file "spherecyl.ph" 
  #else
    // use non-adaptive search radius
	spacing 0.05
    gather 20, 100
    autostop 0
  #end
  } 
  
}

camera {  //  Camera StdCam
  location  <      0.000,     -31.875,      35.630>
  direction <        0.0,         0.0,      2.1178> // Aperture is 0.46 degrees
//  angle 10
//  angle 20
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.33333,         0.0,         0.0> // Aspect ratio
  look_at   <     -0.000,       1.019,       1.166>
//  look_at <0,1.019,5>
}

//
// *******  L I G H T S *******
//

light_source {   // Light1
  <17.904, -1.056, 11.705>
  //<17.904, -1.056, 8.705>
  color rgb <1.000, 1.000, 1.000>*.7
  fade_distance 0
  fade_power 0
}

//
// *******  T E X T U R E S *******
//

#declare Glass = 
   material  {		// Glass
      texture {      
         pigment {
            color rgbf <1.0, 1.0, 1.0, 0.7>
         }      
         finish {
            ambient 0.0
            diffuse 0.0
            specular 1.0
            roughness 0.001
            reflection 0.5
         }
      }   
      interior { ior 1.2 }
   }


#declare Chrome_Metal = 
   material  {		// Chrome_Metal
      texture {      
         pigment {
            color rgb <0.729167, 0.718733, 0.552067>
         }      
         finish {
            ambient 0.1007
            diffuse 0.884867
            brilliance 8.0
            phong 0.330933
            phong_size 52.316667
            specular 0.129467
            roughness 0.022533
            //reflection 0.575533
            reflection .9
         }
      }
   }


#declare PlexiGlass = 
   material  {		// PlexiGlass
      texture {      
         pigment {
            color rgbf <1.0, 1.0, 1.0, 0.791667>
         }      
         finish {
            ambient 0.0
            diffuse 0.0
            specular 1.0
            roughness 0.001
            reflection 0.5
         }
      }   
      interior {
         ior 1.2
         // uncomment these lines and add a spectrum to the light source to
         // get dispersion
         //dispersion 1.05
         //disp_nelems 10
      }
   }


#declare GroundTex = 
   material  {		// GroundTex
      texture {      
         pigment {
            color rgb <0.552067, 0.552067, 0.645833>
         }      
         finish {
            ambient 0.1
            diffuse 0.913667
         }
      }
   }


#declare WallTex = 
   material  {		// WallTex
      texture {      
         pigment {
            image_map {
               // change this file location
               png   "povmap.png"
            }
         }      
         finish {
            ambient 0.1007
            diffuse 0.906467
         }
      }
   }

//
// ********  OBJECTS  *******
//


box { // box by the wall
  <-1, -1, -1>, <1, 1, 1>
  material { GroundTex }
  scale <1.0, 0.748224, 3.014206>
  translate  <4.142054, 8.593331, 2.014206>
}


sphere { // ClearSphere
  <0,0,0>,1
  material { Glass
  }
  scale 2.5
  translate  <4.312204, -6.330586, 2.6>
  photons {
	target 0.5
    refraction on
#if(refl)
    reflection on
#end
    ignore_photons
  }
}

cylinder { // clear cylinder
  <0,0,1>, <0,0,0>, 1
  material {
    PlexiGlass
  }
  scale <2.0, 2.0, 10.0>
  translate  <6.305907, 4.386718, 0.10001>
  photons {
	target 0.5
    refraction on
#if(refl)
    reflection on
#end
    ignore_photons
  }
}


box { // floor
  <-1, -1, -1>, <1, 1, 1>
  material {
    GroundTex
  }
  scale <10.0, 10.0, 0.1>
}




box { // wall
  <-1, -1, -1>, <1, 1, 1>
  material {
    WallTex
    rotate 90.0*x
  }
  scale <10.0, 0.1, 10.0>
  translate  <0.0, 10.0, 10.0>
  //photons { ignore_photons }
}


//sphere { // Reflecting Sphere
//  <0,0,0>,1
box{
  -1,1
  rotate 20*z
  material {
    Chrome_Metal
  }
  scale 1.5
  translate  <-3.364552, 0.797831, 1.6>
  photons {
	target 1.0
#if(refl)
    reflection on
#end
    ignore_photons
  }
}


