//	Persistence of Vision Ray Tracer Scene Description File
//	File: postpr_06.pov
//	Date: 4/28/2000
//	Author: Chris Huff
//	Demo: New post_process filters: add, divide , exponent
//	Comment and/or uncomment lines in post_process block.

#include "colors.inc"
#include "textures.inc"
#version unofficial MegaPov 0.6;

global_settings {
	assumed_gamma 1.8
	ambient_light 1
	post_process {
//		add {color rgb <1, 0.85, 0.5>}
		add {noise_pigment {0, rgb 0.7, rgb 0.9}}
//		divide {rgb 1.5}
//		exponent {rgb 2}
	}
}

background {color White}

#declare CamLoc = <-3, 3,-8>;
camera {
	location CamLoc
	up y*image_height right x*image_width
	angle 60
	look_at < 1, 1, 0>
}

//*******************************************
light_source {<-50, 150,-100> color White}
light_source {CamLoc color White*0.2}

box {<-100, 0,-100>, < 100, 0, 10>
	texture {
		pigment {checker color rgb <1, 1, 0> color rgb <1, 0, 1>}
		finish {ambient 0.6}
	}
}

//*******************************************
//#declare RS = seed(842);
//#declare RS = seed(4863);
//#declare RS = seed(48654);
#declare RS = seed(86315);

union {
	sphere {< 0, 0, 0>, 0.5}
	cylinder {< 0, 0, 0>, < 0, 0,-1>, 0.15}
	texture {
		pigment {rgb <0, 1, 0>}
		finish {ambient 0.6}
	}
	transform { translate y*1.5 }
}
union {
	#declare J=0;
	#while(J<10)
	sphere {< 0, 0, 0>, rand(RS)*0.5 + 0.2
		texture {
			pigment {color rgb < rand(RS), 0, rand(RS)>}
			finish {ambient 0.6}
		}
		translate <rand(RS)*6, rand(RS)*6, rand(RS)*6>-3
		rotate <rand(RS)*360, rand(RS)*360, 0>
		translate <rand(RS)*6, rand(RS)*6, rand(RS)*6>-3
	}
	cone {< 0, 0, 0>, rand(RS)*0.5 < rand(RS), rand(RS), rand(RS)>*rand(RS)*3, rand(RS)*0.15
		texture {
			pigment {color rgb < rand(RS), rand(RS), 0>}
			finish {ambient 0.6}
		}
		translate <rand(RS)*6, rand(RS)*6, rand(RS)*6>-3
		rotate <rand(RS)*360, rand(RS)*360, 0>
		translate <rand(RS)*6, rand(RS)*6, rand(RS)*6>-3
	}
	box {-< rand(RS), rand(RS), rand(RS)>*rand(RS)*3, < rand(RS), rand(RS), rand(RS)>*rand(RS)*3
		texture {
			pigment {color rgb < 0, rand(RS), rand(RS)>}
			finish {ambient 0.6}
		}
		translate <rand(RS)*6, rand(RS)*6, rand(RS)*6>-3
		rotate <rand(RS)*360, rand(RS)*360, 0>
		translate <rand(RS)*6, rand(RS)*6, rand(RS)*6>-3
	}
	#declare J=J+1;
	#end
}
