//	Persistence of Vision Ray Tracer Scene Description File
#version unofficial MegaPov 0.5;

#include "colors.inc"
#include "glass.inc"

#declare clear=yes;
#declare use_photons=yes;
#declare use_light=yes;
#declare use_rad= yes;

#declare high_quality=yes;

#if(clear)
  #declare obj_finish=finish{F_Glass2}
#else
  #declare obj_finish=finish{phong 0 specular 0 diffuse .7 ambient 0}
#end

global_settings{
#if(clear & use_photons)
  photons{
	spacing 0.03
    max_trace_level 8
    gather 20, 60
    autostop 0.15
    jitter .5
  }
#end
#if(use_rad)
  ini_option "+QR"
  #if(high_quality)
  radiosity{
	pretrace_start 0.16
	pretrace_end 0.04
    count 100            // CHANGE range from 20 to 150
    nearest_count 5      // CHANGE range from 3 to 10
    error_bound 1        // CHANGE - range from 1 to 3 
    recursion_limit 4    // CHANGE
    low_error_factor .5  // leave this
    gray_threshold 0.0   // leave this
    minimum_reuse 0.015  // leave this
    brightness 1         // leave this
    adc_bailout 0.01/(18*2)  // CHANGE - use adc_bailout = 0.01 / brightest_ambient_object
    #if(!use_light)
    max_sample 200      // CHANGE - max ambient light
    #end
  }
  
  #else
  radiosity {
	pretrace_start 0.16
	pretrace_end 0.08
    count 20             // CHANGE range from 20 to 150 (at least 80 if lit by ambient)
    nearest_count 3      // CHANGE range from 3 to 10
    error_bound 2.5      // CHANGE - range from 1 to 3 - should correspond with Preview_End_Size
    recursion_limit 4    // CHANGE
    low_error_factor .5  // leave this
    gray_threshold 0.0   // leave this
    minimum_reuse 0.015  // leave this
    brightness 1         // leave this
    adc_bailout 0.01/(18*2)  // CHANGE - use adc_bailout = 0.01 / brightest_ambient_object
  }
  #end
#end
}

camera{
  location <8,0,0>
  look_at <0,0,0>
  angle 45
} 

#declare wall_finish=finish{
  phong 0 specular 0 diffuse .7 ambient 0
  brilliance .4
  //reflection .1
  //reflection .25
  //reflect_metallic
  //reflection_blur 0.8
}

#declare block_color=<.7,.7,.7>;
#declare pig1=pigment{
  gradient z
  color_map{
    [0.00 color block_color transmit 1]
    [0.05 color block_color transmit 1]
    [0.05 color block_color transmit .5]
    [0.10 color block_color transmit .5]
    [0.10 color block_color transmit 1]
    [0.90 color block_color transmit 1]
    [0.90 color block_color transmit .5]
    [0.95 color block_color transmit .5]
    [0.95 color block_color transmit 1]
    [1.00 color block_color transmit 1]
  }
}
#declare pig2=pigment{
  gradient z
  color_map{
    [0.00 color block_color transmit 1]
    [0.05 color block_color transmit 1]
    [0.05 color block_color transmit .5]
    [0.95 color block_color transmit .5]
    [0.95 color block_color transmit 1]
    [1.00 color block_color transmit 1]
  }
}
#declare box_tex=texture{
  pigment{
  gradient x
  pigment_map{
    [0.00 color block_color transmit 1]
    [0.05 color block_color transmit 1]
    [0.05 pig2]
    [0.10 pig2]
    [0.10 pig1]
    [0.90 pig1]
    [0.90 pig2]
    [0.95 pig2]
    [0.95 color block_color transmit 1]
    [1.00 color block_color transmit 1]
  }
  }
  finish{wall_finish}
}

#if(use_light)
light_source{
  <0,1.84,0>
  color <1,1,1>*11
  fade_power 1
  fade_distance .12
#if(use_photons)
  photons{reflection off}
#end
}
#end
box{
  -1,1

  texture{
    pigment{
      gradient y
      color_map{
        [0 rgbt<1,1,1,1>]
        [1 rgbt<1,1,1,0>]
      }
      scale <1,2,1>
      translate -.9*y
    }
    #if (use_light)
    finish{wall_finish ambient 1}
    #else
    finish{ambient 200 diffuse 0}
    #end
  }

  scale <.4,.05,.4>
  translate <0,1.9,0>

}

union{
sphere{
  <.2,-0.2,-1.0>,.5
  texture{
    pigment{color White//Yellow*.9+<.1,.1,.1>
      #if (clear)
      filter .9
      #end
    }
    finish{obj_finish}
  }
  interior {
    media { absorption (1.0-Yellow)*2.5 }
   ior 1.45
  }
  //interior{ fade_distance 3 fade_power 1 ior 1.3}
#if(use_photons)
  photons {
	target 0.8
    refraction on
    reflection on
    ignore_photons
  }
#end
  hollow
}

cylinder {
  0,  .6*y,  .5

  texture{
    pigment{color Blue*.7+<.3,.3,.3>
      #if (clear)
      filter .9
      #end
    }
    finish{obj_finish}
    
  }
  interior{ fade_distance 3 fade_power 1 ior 1.3}
#if(use_photons)
  photons {
	target 0.9
    refraction on
    reflection on
    ignore_photons
  }
#end
  rotate 65*z
  rotate -115*y
  translate <.9,-1.4,1.4>
}


/*box{
  -1,1
  scale .5
  rotate 30*y
  translate <1,-1.5,1>
  texture{
    pigment{color Yellow}
    finish{wall_finish}
  }
}*/

union{
torus{
  .75,.25
  texture{
    pigment{color Cyan*.8+<.2,.2,.2>
      #if (clear)
      filter .9
      #end
     }
    finish{obj_finish}
  }
  interior{ fade_distance 3 fade_power 1 ior 1.3}
#if(use_photons)
  photons{  ignore_photons}
#end
}
cone{
  1.3*y,  0.0,
  <0,0,0>, .4
  texture{
    pigment{color Green*.7+<.3,.3,.3>
      #if (clear)
      filter .9
      #end
     }
    finish{obj_finish}
  }
  interior{ fade_distance 3 fade_power 1 ior 1.3}
#if(use_photons)
  photons{  ignore_photons}
#end
}
  rotate 65*z
  rotate -135*y
  translate <-.5,-.5,.5>
#if(use_photons)
  photons {
	target 0.9
    refraction on
    reflection on
    ignore_photons
  }
#end
}  

box{
  -1,1
  scale <2,2,.01>
  translate <0,0,2>

  texture{
    pigment{color Blue}
    finish{wall_finish}
  }
  texture{box_tex rotate 90*x}
}

box{
  -1,1
  scale <2,2,.01>
  translate <0,0,-2>

  texture{
    pigment{color Red}
    finish{wall_finish}
  }
  texture{box_tex rotate 90*x}
}

box{
  -1,1
  scale <.01,2,2>
  translate <-2,0,0>

  texture{
    pigment{color White}
    finish{wall_finish}
  }
  texture{box_tex rotate 90*z}
}

box{
  -1,1
  scale <2,.01,2>
  translate <0,2,0>

  texture{
    pigment{color Yellow}
    finish{wall_finish}
  }
  texture{box_tex}
}
box{
  -1,1
  scale <2,.01,2>
  translate <0,-2,0>

  texture{
    pigment{color White}
    finish{wall_finish}
  }
  texture{box_tex}
}


}
