//	Persistence of Vision Ray Tracer Scene Description File
//	Needs MegaPov 0.6
//	Date: august 8  2000
//	Author: R. Smellenbergh
//	Demo showing some of the possibilities of the blob_pattern used as a pigment

#version unofficial MegaPov 0.6;

camera {
	location <0.0, 0.0, -25>
	up y*image_height right x*image_width
	look_at <0.0, 0.0, 0.0>
	angle 45
}

light_source { <2000, 2000, -8000> rgb 1.5}
light_source { <0, 0, -25> rgb 0.2 shadowless}

//******* Switches for the objects in the scene **************
#declare WheelOn=1;
#declare WebOn=1;
#declare LatticeOn=1;
#declare CylOn=1;

//****** Some parameters; please play with it ********************
#declare Func = 0;	//0, 1, 2, 3 or 4
#declare falloffAmt = 2;	//any positive value
#declare SwitchInv = 1;	//switch the inverse option

#if (WheelOn =1)
cylinder {
	< 0, -0.5, 0>, < 0, 0.5, 0>, 3
	texture {
		pigment {
			blob {
				threshold 0.1
				max_density 1.0
				#declare C = 0;
				#declare Copies = 12;
				#while ( C < Copies)
					box {
						<-0.6, -0.8, -0.6>, <0.6, 0.8, 0.6>, strength 0.55
						density_function Func, falloffAmt
						rotate y*45
						translate x*3
						rotate y*(C *-30)
						#if (SwitchInv =1) inverse #end
					} //box-component
					#declare C = C +1;
				#end  //while (C < Copies)
				sphere {
					< 0, 0, 0>, 4.7, strength 0.4
					density_function Func, falloffAmt
					#if (SwitchInv =1) inverse #end
				} //sphere-component
			} //blob-pattern
			ramp_wave
			color_map {
				[0.00 rgb <0.8, 0, 0.8>]
				[0.01 rgb <1, 0, 0>]
				[0.25 rgb <0, 0, 1>]
				[0.50 rgb <0, 1, 0>]
				[0.75 rgb <1, 1, 0>]
				[1.00 rgb <1, 0, 0>]
			}
		} //pigment
		finish {phong 1.0 phong_size 400}
	} //texture
	rotate z*100
	rotate y*22
	translate <-4.5, 2, -4>
} //object-cylinder
#end

#if (WebOn =1)
disc  {
	<0.0, 0.0, 0.0>, <0.0, 1, 0>, 6
	pigment {
		blob {
			threshold 0
			max_density 1.0
			#declare C1 = 0;
			#declare Copies1 = 12;
			#while ( C1 < Copies1)
				#declare C = 0;
				#declare Copies = 5;
				#while ( C < Copies)
					#declare Va1 = (C*5)/(Copies -1);
					cylinder {
						vrotate(<Va1, 0, 0>, y*15), vrotate(<Va1, 0, 0>, y*-15), 0.25, strength 0.7
						density_function Func, falloffAmt
						#if (SwitchInv =1) inverse #end
						rotate y*(C1*30)
					} //cylinder-component
					#declare C = C +1;
				#end  //while (C < Copies)
					cylinder {
						<0, 0, 0>, vrotate(<5.2, 0, 0>, y*-15), 0.25, strength 0.6
						density_function Func, falloffAmt
						#if (SwitchInv =1) inverse #end
						rotate y * (0.0 + (C1 * (30)))
					} //cylinder-component
				#declare C1 = C1 +1;
			#end  //while (C1 < Copies1)
		} //blob-pattern
		ramp_wave
		color_map { [ 0.0 rgb 1.4 ] [ 0.85 rgb <0, 0, 1> ] [ 1 rgb 0.1 ] }
	} //pigment
	rotate z*25
	rotate x*-30
	translate <2.7, -2.0, 0>
} //object-disc
#end


#if (LatticeOn=1)
box {< -12, -12, 0>, < 12, 12, 1>
	texture {
		pigment {
			blob {
				threshold 0
				max_density 1.0
				#declare C = 0;
				#declare Copies = 10;
				#while ( C < Copies)
					cylinder {
						<0, -8, 0>, <0, 8, 0>, 0.5, strength 0.42
						density_function Func, falloffAmt
						#if (SwitchInv =0) inverse #end
						translate x*(-8 + (C*(8 - (-8))/(Copies -1)))
					} //object
					#declare C = C +1;
				#end  //while (C < Copies)
				#declare C2 = 0;
				#while ( C2 < Copies)
					cylinder {
						<-8, 0, 0>, <8, 0, 0>, 0.5, strength 0.42
						density_function Func, falloffAmt
						#if (SwitchInv =0) inverse #end
						translate y*(-8 + (C2*(8 - (-8))/(Copies -1)))
					} //object
					#declare C2 = C2 +1;
				#end  //while (C2 < Copies)
			} //blob-pattern
			sine_wave
			color_map {
				[0.00 rgb <1, 0, 0>]
				[0.33 rgb <0, 0, 1>]
				[0.66 rgb <1, 1, 0>]
				[1.00 rgb <1, 0, 0>]
			}
		} //pigment
		finish {ambient 0.2}
	} //texture
	scale 1.1
	translate z*6
} //object-box
#end

#if (CylOn=1)
cylinder {
	<0, -0.5, 0.0>, <0, 0.5, 0.0>, 0.6
	texture {
		pigment {
			blob {
				threshold 0
				max_density 1.0
				#declare C = 0;
				#declare Copies = 70;
				#while ( C < Copies)
				sphere {
					<0, 0, 0>, 0.1, strength 0.95
					density_function Func, falloffAmt
					#if (SwitchInv =0) inverse #end
					scale <1.2, 1.7, 2>
					translate x*0.6
					rotate y*(C*(3.5*360)/(Copies -1))
					translate y*(-0.5 + (C*(0.5 - (-0.5))/(Copies -1)))
				} //sphere-component
				#declare C = C +1;
				#end  //while (C < Copies)
			} //blob-pattern
			scallop_wave
			color_map {
				[0.00 rgb 1.2]
				[0.33 rgb <0, 0, 1>]
				[0.66 rgb <1, 1, 0>]
				[1.00 rgb <1, 0, 0>]
			}
		}
	} //texture
	scale <2.5, 5.5, 2.5>
	rotate z*-57
	rotate y*35
	translate <1.5, 3.6, -1.0>
} //object-cylinder
#end
