//	Persistence of Vision Ray Tracer Scene Description File
#version unofficial MegaPov 0.4;

#include "colors.inc"
//Start of blob pattern demo file
camera {
	location < 0, 2.5, -8 >*2
	angle 35
	look_at < 0, 0, 0 >
}

#declare Func = 0;
#declare falloffAmt = 3;

box {< -10, -10, 0>, < 10, 10, 1>
	texture {
		pigment {
			blob {

				cylinder {<3, 2.4, 0>, < -3, 2.4, 0>, 1.0, strength 1
				density_function Func, falloffAmt}
				cylinder {<3, 2.4, 0>, < -3, 2.4, 0>, 1.0, strength 1
				rotate z*1*120  density_function Func, falloffAmt}
				cylinder {<3, 2.4, 0>, < -3, 2.4, 0>, 1.0, strength 1
				rotate z*2*120  density_function Func, falloffAmt}
				sphere {< 0, 0, 0>, 2.75,  strength 1 density_function Func, 	falloffAmt}
				threshold 0
				max_density 1
			}
			ramp_wave
			color_map {
				[0.00 color Red]
				[0.33 color Blue]
				[0.66 color Yellow]
				[1.00 color Red]
			}
		}
		finish {ambient 1}
	}
}
//End of blob pattern demo file