//	Persistence of Vision Ray Tracer Scene Description File
//	File: image_pattern.pov
//	Date: 15/11/99
// Author: Ren Smellenbergh
//	Demo image_pattern, needs "mm_paper.png" image
	
#version unofficial MegaPov 0.4;

#declare Mytex =
pigment {
	gradient y
	color_map {
		[ 0.0 rgb <0.834806, 0.746777, 0.605188> ]
		[ 0.12 rgb <0.719982, 0.583948, 0.239994> ]
		[ 0.23 rgb <0.797894, 0.577569, 0.342077> ]
		[ 0.5 rgb <0.555993, 0.373999, 0.244007> ]
		[ 0.7 rgb <0.613184, 0.374868, 0.226795> ]
		[ 1.0 rgb <0.523568, 0.272648, 0.156405> ]
	}
	scale 1.5
}

sphere {
	<0, 0, 0>, 2
	pigment {
		image_pattern {
			pattern image_height , image_height {
				hexagon  rgb 0,  rgb 0.5,  rgb 1
				scale <0.04, 1, 0.08>	//ratio to wrap around a sphere
			}
			use_color
			map_type 1	//spherical
			interpolate 0
		}
		pigment_map {
			[0 Mytex ]
			[0.5 rgb <0.738750, 0.656107, 0.793164> ]
			[1  rgb 0.4 transmit 0.95]
		}
		scale 0.8
	}
	normal {
		image_pattern {
			pattern image_height , image_height {
				hexagon  rgb 0,  rgb 0.5,  rgb 1 
				scale <0.04, 1, 0.08>	//ratio to wrap around a sphere
			}
			use_color
			map_type 1	//spherical
			interpolate 0
		}
		bump_size 3
		slope_map {
			[ 0.0,  < 0.0,  0.0 > ]
			[ 1.0,  < 1.0,  0.0 > ]
		}
		normal_map {
			[ 0.0 agate 0.5  ]
			[ 0.5 granite 0.6 scale 0.3  ]
			[ 1.0 bumps 0.9 scale 0.2  ]
		}
		scale 0.8
	}
	rotate z*45
}

camera {
	location < 0.0, 0.0, -10 >
	angle 40
	look_at < 0.0, 0.0, 0.0 >
}

light_source {
	< 10, 10, -20 >
	color rgb < 1.0, 1.0, 1.0 >*2
	area_light < 5.0,  0.0, 0.0 >,   < 0.0, 5.0,  0.0 >,  5,  5
	adaptive 2
}

light_source { 0, rgb 0.6 }

background { rgb <0.255772, 0.234699, 0.198993> }
