// Persistence of Vision Ray Tracer Scene Description File
// Needs 'polarical' and 'vturbulence' patch by Krzysztof Garus
// File: polarical_vturb.pov
// Date: 14/11/1999
// Auth: Krzysztof Garus     http://www.bigfoot.com/~kgarus/

#version unofficial MegaPov 0.4;

#include "colors.inc"

global_settings { assumed_gamma 1.8 }

camera {
	location  <0.0, 3.0, -6.0>
//	direction 1.5*z
	right x*(image_width/image_height)
	up y
	look_at <0.0, 0.0, 0.0>
	angle 50
}

light_source { <-25, 12, -30> rgb 1.4 }
light_source { <0.0, 3.0, -6.0> rgb 0.6 shadowless }

#declare New_Tex =
	texture {
		pigment {
			polarical
			frequency 2
			color_map {
				[0 Yellow]
				[.2 Blue]
				[.3 White]
				[.4 Green*.4]
				[.48 Navy]
				[.48 Clear]
				[.52 Clear]
				[.52 Navy]
				[.6 Black]
				[.7 Yellow]
				[.7 Black]
				[.71 Black]
				[.71 Yellow]
				[.8 Red*.4]
				[.9 Blue]
				[1 Yellow]
			}
		}
		finish { specular 0.7 }
	}

#declare Text_Tex =
	texture {
		pigment { Green }
		finish {
			ambient 0.3
			specular 0.6 roughness 0.001
		}
	}

union {
	intersection {
		sphere { 0,1 }
		plane { -x,0 }
		plane { y,.4 }
	}
	intersection {
		sphere { 0,1 }
		plane { x,0 }
		plane { z,.2 }
		plane { -z,.2 }
		sphere { 0,.8 inverse }
	}
	rotate y*-40
	texture { New_Tex }
	translate <-0.2,1,-2.6>
}

plane { y, 0 pigment { rgb <0.7, 0.5, 0.3> } }

blob {
	threshold 0.2
	#declare Max = 600;
	#declare c = 0;
	#while (c<=Max)
		#declare Vec1 = vrotate ( <-3+6*c/Max, 1, 0>, y*180) +z*2;
		#declare Vec2 = vturbulence (2, 0.6, 4, Vec1) +Vec1;
			sphere { Vec2, 0.06, 1 }
		#declare c = c + 1;
	#end
	pigment { Red }
	finish { phong 0.7 }
}
  
  
  
  