/****************************************************************************
*                   pattern.h
*
*  -------------------------------------------------------
*  ATTENTION:
*  This is an unofficial version of pattern.h modified by
*  Ryoichi Suzuki, rsuzuki@etl.go.jp for use with
*  "isosurface" shape type.
*  -------------------------------------------------------
*  This module contains all defines, typedefs, and prototypes for PATTERN.C.
*
*  from Persistence of Vision(tm) Ray Tracer
*  Copyright 1996,1999 Persistence of Vision Team
*---------------------------------------------------------------------------
*  NOTICE: This source code file is provided so that users may experiment
*  with enhancements to POV-Ray and to port the software to platforms other
*  than those supported by the POV-Ray Team.  There are strict rules under
*  which you are permitted to use this file.  The rules are in the file
*  named POVLEGAL.DOC which should be distributed with this file.
*  If POVLEGAL.DOC is not available or for more info please contact the POV-Ray
*  Team Coordinator by email to team-coord@povray.org or visit us on the web at
*  http://www.povray.org. The latest version of POV-Ray may be found at this site.
*
* This program is based on the popular DKB raytracer version 2.12.
* DKBTrace was originally written by David K. Buck.
* DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
*
*****************************************************************************/

/* NOTE: FRAME.H contains other pattern stuff. */

#ifndef PATTERN_H
#define PATTERN_H


/*****************************************************************************
* Global preprocessor defines
******************************************************************************/
#ifdef BlobPatternPatch
  #define LAST_SPECIAL_PATTERN     BLOB_PIGMENT
#else
#define LAST_SPECIAL_PATTERN     BITMAP_PATTERN
#endif
#define LAST_NORM_ONLY_PATTERN    DENTS_PATTERN
#define LAST_INTEGER_PATTERN     HEXAGON_PATTERN

#define FIRST_FRACTAL_PATTERN MANDEL_PATTERN
#define LAST_FRACTAL_PATTERN MAGNET2J_PATTERN

enum PATTERN_IDS
{
  NO_PATTERN = 0,
  PLAIN_PATTERN,
  AVERAGE_PATTERN,
  BITMAP_PATTERN,
#ifdef BlobPatternPatch
  BLOB_PIGMENT,
#endif
/* These former normal patterns require special handling.  They too
   must be kep seperate for now.*/

  WAVES_PATTERN,
  RIPPLES_PATTERN,
  WRINKLES_PATTERN,
  BUMPS_PATTERN,
  QUILTED_PATTERN,
  #ifdef CracklePatch
  FACETS_PATTERN,
  #endif
  DENTS_PATTERN,
#ifdef CellsPatch
  CELLS_PATTERN,
#endif
#ifdef VanSicklePatternPatch
  BLOTCHES_PATTERN,
  BANDS_PATTERN,
  SHEET_PATTERN,
#endif

/* These patterns return integer values.  They must be kept
   together in the list.  Any new integer functions added must be added
   here and the list renumbered. */

#ifdef TrianglulairSquarePatch 
	SQUARE_PATTERN,
	TERNAIRE_PATTERN,
#endif

	CHECKER_PATTERN         ,
#ifdef ObjectPatternPatch
   OBJECT_PATTERN     ,    /*Chris Huff object pattern*/
#endif
	BRICK_PATTERN           ,
	HEXAGON_PATTERN       ,


/* These patterns return float values.  They must be kept together
   and seperate from those above. */

  BOZO_PATTERN,
  MARBLE_PATTERN,
  WOOD_PATTERN,
  SPOTTED_PATTERN,
  AGATE_PATTERN,
  GRANITE_PATTERN,
  GRADIENT_PATTERN,
  ONION_PATTERN,
  LEOPARD_PATTERN,
  /* fractal patterns - if updated, must update FIRST_FRACTAL_PATTERN and
     LAST_FRACTAL_PATTERN defines, above
  */
  MANDEL_PATTERN,
  MANDEL3_PATTERN,
  MANDEL4_PATTERN,
  JULIA_PATTERN,
  JULIA3_PATTERN,
  JULIA4_PATTERN,
  MAGNET1M_PATTERN,
  MAGNET1J_PATTERN,
  MAGNET2M_PATTERN,
  MAGNET2J_PATTERN,
  /* end of fractal patterns */
  RADIAL_PATTERN,
#ifdef PolaricalPatch
	POLARICAL_PATTERN      , /* Added by bajcik */
#endif
  CRACKLE_PATTERN,
  SPIRAL1_PATTERN,
  SPIRAL2_PATTERN,
  PLANAR_PATTERN,
  SPHERICAL_PATTERN,
  BOXED_PATTERN,
  CYLINDRICAL_PATTERN,
  DENSITY_FILE_PATTERN,
#ifdef ProximityPatch
  PROXIMITY_PATTERN ,  /*Chris Huff proximity pattern*/
#endif
#ifdef BlobPatternPatch
  BLOB_PATTERN,            /*Chris Huff blob pattern*/
#endif
#ifdef SolidPatternPatch
  SOLID_PATTERN ,   /*Chris Huff solid pattern*/
#endif
#ifdef ClothPatternPatch
 CLOTH_PATTERN,    /*Chris Huff cloth pattern*/
CLOTH2_PATTERN,    /*Chris Huff cloth2 pattern*/
#endif
#ifdef TorodialPatch
 TOROIDAL_SPIRAL_PATTERN ,  /*Chris Huff cloth2 pattern*/
#endif

/** poviso: May 97 R.S. **/
#ifdef POVISO
  FUNCTION_PATTERN,
 	#endif
/** --- **/
  SLOPE_PATTERN,
#ifdef PigmentPatternPatch
  PIGMENT_PATTERN,
#endif
/* NK 1998 */
  IMAGE_PATTERN
/* NK ---- */
};


/* Pattern flags */

#define NO_FLAGS      0
#define HAS_FILTER    1
#define FULL_BLOCKING 2
#define POST_DONE     4
#ifdef NormalBugFix
#define DONT_SCALE_BUMPS_FLAG 8 /* scale bumps for normals */
#endif

#define Destroy_Turb(t) if ((t)!=NULL) POV_FREE(t);

#define RAMP_WAVE     0
#define SINE_WAVE     1
#define TRIANGLE_WAVE 2
#define SCALLOP_WAVE  3
#define CUBIC_WAVE    4
#define POLY_WAVE     5

/* Interpolation types. */

#define NO_INTERPOLATION        0
#define TRILINEAR_INTERPOLATION 1


/*****************************************************************************
* Global typedefs
******************************************************************************/


/*****************************************************************************
* Global variables
******************************************************************************/



/*****************************************************************************
* Global constants
******************************************************************************/



/*****************************************************************************
* Global functions
******************************************************************************/
/*YS*/ /*moved this from pattern.c*/
long PickInCube (VECTOR tv, VECTOR p1);
/*YS*/

DBL Evaluate_TPat (TPATTERN *TPat, VECTOR EPoint, INTERSECTION *Intersection);
void Init_TPat_Fields (TPATTERN *Tpat);
void Copy_TPat_Fields (TPATTERN *New, TPATTERN *Old);
void Destroy_TPat_Fields (TPATTERN *Tpat);
void Translate_Tpattern (TPATTERN *Tpattern, VECTOR Vector);
void Rotate_Tpattern (TPATTERN *Tpattern, VECTOR Vector);
void Scale_Tpattern (TPATTERN *Tpattern, VECTOR Vector);
void Transform_Tpattern (TPATTERN *Tpattern, TRANSFORM *Trans);
DBL quilt_cubic (DBL t,DBL p1,DBL p2);
void Search_Blend_Map (DBL value,BLEND_MAP *Blend_Map,
 BLEND_MAP_ENTRY **Prev, BLEND_MAP_ENTRY **Cur);

DENSITY_FILE *Create_Density_File (void);
DENSITY_FILE *Copy_Density_File (DENSITY_FILE *);
void Destroy_Density_File (DENSITY_FILE *);
void Read_Density_File (DENSITY_FILE *df);
#ifdef ProximityPatch
DBL eval_density_func(DBL val, DBL falloff, int func);/*Chris Huff proximity pattern*/
#endif
#ifdef EvalPatternPatch
 DBL Parse_eval_pat(void);
#endif
#ifdef EvalPigmentPatch
void Parse_eval_pig(VECTOR Vect);
#endif


#endif
