
#include "frame.h"

#ifdef SplinePatch
#include "mem.h"
#include "splines.h"


DBL interpol1(SPLINE_ENTRY * se, int i, int k, DBL p);

void fitq(SPLINE_ENTRY * se, int i, int k, DBL * a, DBL * b, DBL * c);

DBL interpol2(SPLINE_ENTRY * se, int i, int k, DBL p);

int findt(SPLINE2 * sp, DBL Time);

void mkfree(SPLINE2 * sp, int i);


DBL interpol1(SPLINE_ENTRY * se, int i, int k, DBL p)
{
  DBL p1, p2, v1, v2;
    p1 = se[i].par;
    p2 = se[i+1].par;
    v1 = se[i].vec[k];
    v2 = se[i+1].vec[k];
    return (p-p1)*(v2-v1)/(p2-p1)+v1;
}

void fitq(SPLINE_ENTRY * se, int i, int k, DBL * a, DBL * b, DBL * c)
{
  /* fit quadratic function to three point*/
  DBL n;
  DBL p1, p2, p3, 
      v1, v2, v3;
  /* assignments to make life easier */
  p1=se[i-1].par; p2=se[i].par; p3=se[i+1].par;
  v1=se[i-1].vec[k]; v2=se[i].vec[k]; v3=se[i+1].vec[k];
 
  n=(p2-p1)*(p3-p1)*(p3-p2);

  *a=(-p2*v1+p3*v1
      +p1*v2-p3*v2
      -p1*v3+p2*v3) /n;
  *b=( p2*p2*v1 - p3*p3*v1
      -p1*p1*v2 + p3*p3*v2
      +p1*p1*v3 - p2*p2*v3) /n;
  *c=(-p2*p2*p3*v1+p2*p3*p3*v1
      +p1*p1*p3*v2-p1*p3*p3*v2
      -p1*p1*p2*v3+p1*p2*p2*v3) /n;
}

DBL interpol2(SPLINE_ENTRY * se, int i, int k, DBL p)
{
    DBL a1, b1, c1;
    DBL a2, b2, c2;
    DBL v1, v2;
    DBL p1, p2;
    p1 = se[i].par;
    p2 = se[i+1].par;
    fitq(se, i,   k, &a1, &b1, &c1);
    fitq(se, i+1, k, &a2, &b2, &c2);
    v1 = (a1*p+b1)*p+c1;
    v2 = (a2*p+b2)*p+c2;
    return (p-p1)*(v2-v1)/(p2-p1)+v1;
}

int findt(SPLINE2 * sp, DBL Time)
{
  int i;
    SPLINE_ENTRY * se;
    se = sp->SplineEntries;
    if(sp->Number_Of_Entries == 0) return 0;
    
    if(Time <= se[0].par) return 0;
    
    if(Time >= se[sp->Number_Of_Entries-1].par) return sp->Number_Of_Entries;
    
    i = 1;
    while(Time>se[i].par) i++;
  return i;
}

void mkfree(SPLINE2 * sp, int i)
{
  int j;
    SPLINE_ENTRY * se;
    se = sp->SplineEntries;
    
    for (j=sp->Number_Of_Entries; j>i; j--)
        se[j] = se[j-1];
}

SPLINE2 * Create_Spline(int Type)
{
    SPLINE2 * New;
    New = (SPLINE2 *)POV_MALLOC(sizeof(SPLINE2), "spline");
    New->SplineEntries =NULL; 
    New->Number_Of_Entries = 0;
    New->Type = Type;
    return New;
}

SPLINE2 * Copy_Spline(SPLINE2 * Old)
{
    SPLINE2 * New;
    New = (SPLINE2 *)POV_MALLOC(sizeof(SPLINE2), "spline");
    if(Old->Number_Of_Entries)
    {
    New->SplineEntries =(SPLINE_ENTRY*) POV_MALLOC(Old->Number_Of_Entries*sizeof(SPLINE_ENTRY), "spline entry");
    memcpy(New->SplineEntries, Old->SplineEntries, Old->Number_Of_Entries*sizeof(SPLINE_ENTRY));
    }
    else
    {
		New->SplineEntries=NULL;
    }
    
    New->Number_Of_Entries = Old->Number_Of_Entries;
    New->Type = Old->Type;
    return New;
}

void Destroy_Spline(SPLINE2 * Spline)
{
    POV_FREE(Spline->SplineEntries);
    POV_FREE(Spline);
}

void Insert_Spline_Entry(SPLINE2 * sp, DBL p, EXPRESS v)
{
    int i, k;

    /*YS fix jan 31 2001
    	removed limit and fixed crash with declared spline. 
    	If SplineEntries==NULL, POV_REALLOC will use POV_MALLOC 
   	*/
   sp->SplineEntries=(SPLINE_ENTRY*) POV_REALLOC(sp->SplineEntries,(sp->Number_Of_Entries+1)*sizeof(SPLINE_ENTRY), "spline entry");
    
    i = findt(sp, p);
    mkfree(sp, i);
    sp->SplineEntries[i].par = p;
    
    for(k=0; k<5; k++)
        sp->SplineEntries[i].vec[k] = v[k];
    
    sp->Number_Of_Entries += 1;
}

DBL Get_Spline_Val(SPLINE2 * sp, DBL p, DBL v[])
{
  int i, k;
  int last;
    SPLINE_ENTRY * se;
    
    last = sp->Number_Of_Entries-1;
    
    se = sp->SplineEntries;
    
    if(last == 0)
    {/* if only one entry then return this */
        for(k=0; k<5; k++)
            v[k] = se[0].vec[k]; 
        return se[0].vec[0]; 
    }
    
    i = findt(sp, p);
    
    if(i == 0)
    {/* lower than first entry -> return first */
        for(k=0; k<5; k++)
            v[k] = se[0].vec[k];
        return se[0].vec[0];
    }
    if(i>last)
    {/* higher than last entry -> return last */
        for(k=0; k<5; k++)
            v[k] = se[last].vec[k]; 
      return se[last].vec[0]; 
    }
    if((sp->Type==LINEAR_SPLINE)||(i<2)||(i>last-1))
    {/* type==linear or no other than linear interpolation possible */
        for(k=0; k<5; k++)
            v[k] = interpol1(se, i-1, k, p);
        return v[0];
    }
  else
    {
        for(k=0; k<5; k++)
            v[k] = interpol2(se, i-1, k, p);
        return v[0];
    }
}

#else
 static  char dummy[2];
#endif

