/*
 *	DMA buffer calls
 */

int DMAbuf_open(int dev, int mode);
int DMAbuf_release(int dev, int mode);
int DMAbuf_read (int dev, char *user_buf, int count);
int DMAbuf_getwrbuffer(int dev, char **buf, int *size);
int DMAbuf_getrdbuffer(int dev, char **buf, int *len);
int DMAbuf_rmchars(int dev, int buff_no, int c);
int DMAbuf_start_output(int dev, int buff_no, int l);
int DMAbuf_ioctl(int dev, unsigned int cmd, unsigned int arg);
long DMAbuf_init(long mem_start);
int DMAbuf_start_dma (int chan, long physaddr, int count, int dma_mode);
int DMAbuf_open_dma (int chan);
void DMAbuf_close_dma (int chan);
void DMAbuf_reset_dma (int chan);
void DMAbuf_inputintr(int dev);
void DMAbuf_outputintr(int dev);

/*
 *	System calls for the /dev/dsp
 */

int dsp_read (struct inode *inode, struct file *file, char *buf, int count);
int dsp_write (struct inode *inode, struct file *file, char *buf, int count);
int dsp_open (struct inode *inode, struct file *filp);
void dsp_release (struct inode *inode, struct file *filp);
int dsp_ioctl (struct inode *inode, struct file *file,
	   unsigned int cmd, unsigned int arg);
int dsp_lseek (struct inode *inode, struct file *file, off_t offset, int orig);
long dsp_init (long mem_start);

/*
 *	System calls for the /dev/audio
 */

int audio_read (struct inode *inode, struct file *file, char *buf, int count);
int audio_write (struct inode *inode, struct file *file, char *buf, int count);
int audio_open (struct inode *inode, struct file *filp);
void audio_release (struct inode *inode, struct file *filp);
int audio_ioctl (struct inode *inode, struct file *file,
	   unsigned int cmd, unsigned int arg);
int audio_lseek (struct inode *inode, struct file *file, off_t offset, int orig);
long audio_init (long mem_start);

/*
 *	System calls for the /dev/sequencer
 */

int sequencer_read (struct inode *inode, struct file *file, char *buf, int count);
int sequencer_write (struct inode *inode, struct file *file, char *buf, int count);
int sequencer_open (struct inode *inode, struct file *filp);
void sequencer_release (struct inode *inode, struct file *filp);
int sequencer_ioctl (struct inode *inode, struct file *file,
	   unsigned int cmd, unsigned int arg);
int sequencer_lseek (struct inode *inode, struct file *file, off_t offset, int orig);
long sequencer_init (long mem_start);
void sequencer_midi_input(unsigned char data);
int sequencer_select(struct inode * inode, struct file * filp, int sel_type, select_table * wait);

/*
 *	System calls for the /dev/midi
 */

int MIDIbuf_read (struct inode *inode, struct file *file, char *buf, int count);
int MIDIbuf_write (struct inode *inode, struct file *file, char *buf, int count);
int MIDIbuf_open (struct inode *inode, struct file *filp);
void MIDIbuf_release (struct inode *inode, struct file *filp);
int MIDIbuf_ioctl (struct inode *inode, struct file *file,
	   unsigned int cmd, unsigned int arg);
int MIDIbuf_lseek (struct inode *inode, struct file *file, off_t offset, int orig);
void MIDIbuf_bytes_received(int dev, unsigned char *buf, int count);
long MIDIbuf_init(long mem_start);

/*
 *	Misc calls from various sources
 */

/*	From soundcard.c	*/
long soundcard_init(long mem_start);
void tenmicrosec(void);
void soundcard_load(int major);
int soundcard_unload(int major);
void soundcard_start(void);

/*	From sb_dsp.c	*/
int sb_dsp_detect (void);
long sb_dsp_init (long mem_start);
void sb_dsp_disable_midi(void);

/*	From ym3812.c	*/
int ym3812_detect (int ioaddr);
long ym3812_init(long mem_start);

/*	From opl3.c	*/
int opl3_detect (int ioaddr_left, int ioaddr_right);
long opl3_init(long mem_start);

/*	From sb_card.c	*/
long detect_sb_card(long mem_start);

/*	From adlib_card.c	*/
long detect_adlib_card(long mem_start);

/*	From pas_card.c	*/
long detect_pas_card(long mem_start);
int pas_set_intr(int mask);
int pas_remove_intr(int mask);
unsigned char pas_read(int ioaddr);
void pas_write(unsigned char data, int ioaddr);

/*	From pas_audio.c */
void pas_pcm_interrupt(unsigned char status, int cause);
long pas_pcm_init(long mem_start);

/*	From pas_mixer.c */
int pas_init_mixer(void);

/*	From pas_midi.c */
long pas_midi_init(long mem_start);
void pas_midi_interrupt(void);
