/* linux/kernel/chr_drv/sound/sound-config.h

A driver for Soundcards, misc configuration parameters.

(C) 1992  Hannu Savolainen (hsavolai@cs.helsinki.fi) */

#include "local.h"

#undef CONFIGURE_SOUNDCARD
#undef DYNAMIC_BUFFER

#ifdef KERNEL_SOUNDCARD
#define CONFIGURE_SOUNDCARD
#define DYNAMIC_BUFFER
#undef LOADABLE_SOUNDCARD
#endif

#ifdef LOADABLE_SOUNDCARD
#define CONFIGURE_SOUNDCARD
#endif

#ifdef EXCLUDE_SEQUENCER
#define EXCLUDE_MIDI
#define EXCLUDE_YM3812
#define EXCLUDE_OPL3
#else
#  if defined(EXCLUDE_MIDI) && defined(EXCLUDE_YM3812) && defined(EXCLUDE_OPL3)
#  define EXCLUDE_SEQUENCER
#  endif
#endif

#if defined(EXCLUDE_PAS) && defined(EXCLUDE_SB) && defined(EXCLUDE_YM3812)
#undef CONFIGURE_SOUNDCARD
#endif

#if defined(EXCLUDE_SEQUENCER) && defined(EXCLUDE_AUDIO)
#undef CONFIGURE_SOUNDCARD
#endif

/* ****** IO-address, DMA and IRQ settings ****

If your card has nonstandard I/O address or IRQ number, change defines
   for the following settings in your kernel Makefile */

#ifndef SBC_IO_BASE
#define SBC_IO_BASE	0x220	/* 0x220 is the factory default. */
#endif

#ifndef SBC_IRQ
#define SBC_IRQ		7	/* IQR7 is the factory default.	 */
#endif

#ifndef PAS_BASE
#define PAS_BASE	0x388
#endif

#ifndef PAS_IRQ
#define PAS_IRQ		5
#endif

#ifndef PAS_DMA
#define PAS_DMA		3
#endif

/************* PCM DMA buffer sizes *******************/

/* If you are using high playback or recording speeds, the default buffersize
   is too small. DSP_BUFFSIZE must be 64k or less.

   A rule of thumb is 64k for PAS16, 32k for PAS+, 16k for SB Pro and
   4k for SB.

   If you change the DSP_BUFFSIZE, don't modify this file.
   Change the definition in your kernel Makefile instead. */

#ifndef DSP_BUFFSIZE
#define DSP_BUFFSIZE		(4096)
#endif

#ifndef DSP_BUFFCOUNT
#define DSP_BUFFCOUNT		2	/* 2 is recommended. */
#endif


#define SND_MAJOR	14	

/* FM synth base registers. FM_MONO is the traditional AdLib/SoundBlaster
   address. FM_LEFT and FM_RIGHT are used by SoundBlaster Pro for Stereo. */

#define FM_MONO		0x388	/* This is the I/O address used by AdLib */
#define PAS_FM_LEFT	FM_MONO
#define PAS_FM_RIGHT	(PAS_FM_LEFT + 2)

#define FM_LEFT		(SBC_IO_BASE + 0)
#define FM_RIGHT	(SBC_IO_BASE + 8)

/* SEQ_MAX_QUEUE is the maximum number of sequencer events buffered by the
   driver. (There is no need to alter this) */
#define SEQ_MAX_QUEUE	512

#define SBFM_MAXINSTR		(128+16)	/* Size of the FM Instrument
						   bank				 */
/* 128 instruments for general MIDI setup and 16 unassigned	 */

#define SND_NDEVS	20	/* Number of supported devices */
#define SND_DEV_CTL	0	/* Control port /dev/sndctrl */
#define SND_DEV_SEQ	1	/* Sequencer output /dev/sequencer (FM
				   synthesizer and MIDI output) */
#define SND_DEV_MIDIN	2	/* MIDI input /dev/midin (not implemented
				   yet) */
#define SND_DEV_DSP	3	/* Digitized voice /dev/dsp */
#define SND_DEV_AUDIO	4	/* Sparc compatible /dev/audio */

#define DSP_DEFAULT_SPEED	8000	/* Compatible with Sun. Don't use
					   greater than 11000 since	 */
/* the SoundBlaster card don't support hihger recording		 */
/* frequencies.							 */

#define ON		1
#define OFF		0

#define DMA_READ		0x045
#define DMA_WRITE		0x049

#define MAX_DSP_DEV	2
#define MAX_MIXER_DEV	1
#define MAX_SYNTH_DEV	1
#define MAX_MIDI_DEV	1
