
/* linux/kernel/chr_drv/sound/soundload.c

This program loads the driver.

(C) 1992  Hannu Savolainen (hsavolai@cs.helsinki.fi) */

#include <linux/soundcard.h>
#include "sound_config.h"

#define __LIBRARY__
#include <unistd.h>
#include <sys/types.h>
#undef __LIBRARY__


#include <stdio.h>
#include <stdlib.h>
#include <a.out.h>
#include <fcntl.h>

#ifdef LOADABLE_SOUNDCARD
#include <linux/larix.h>
#endif


static _syscall4 (int, larix, void *, data, unsigned long, length, unsigned long, where, int, major);


int
main (int argc, char **argv)
{
  char *buf;
  int flen, mlen;
  FILE *fd;

  int mixer;
  struct soundcard_config conf;

  union
  {
    char buf[1024];
    struct exec exec;
  } hd;
  int type;

  type = LARIX_DEVICE;
  if (argc != 2)
    {
      fprintf (stderr, "Usage '%s <filename>\n", argv[0]);
      exit (1);
    }
  if ((fd = fopen (argv[1], "r")) == NULL)
    {
      fprintf (stderr, "Can't open '%s'.\n", argv[1]);
      exit (1);
    }

  fread (hd.buf, 1, 0x400, fd);
  flen = hd.exec.a_text + hd.exec.a_data;
  mlen = flen + hd.exec.a_bss;

  mlen += 4095;
  mlen &= ~4095;

  if ((buf = malloc (mlen)) == NULL)
    {
      fprintf (stderr, "Can't allocate enough memory.\n");
      exit (1);
    }
  if (fread (buf, 1, flen, fd) != flen)
    {
      fprintf (stderr, "Can't read enough from the file.\n");
      exit (1);
    }
  printf ("got the file, read %d bytes, now going to dump %d bytes to the kernel.\n\n", flen, mlen);
  errno = 0;
  printf ("\n\n%d\n", larix (buf, mlen, LOADADDR, SND_MAJOR | LARIX_DEVICE));
  if (errno != 0)
    {
      perror ("larix system call");
      exit (-1);
    }

  if ((mixer = open ("/dev/mixer", O_RDWR, 0)) == -1)
    {
      perror ("/dev/mixer");
      exit (-1);
    }

  conf.config_command = SNDCONF_START;

  if (ioctl (mixer, SNDCTL_CONFIGURE, &conf) == -1)
    {
      perror ("/dev/mixer");
      exit (-1);
    }

  exit (0);
}
