/*
 * linux/kernel/ldt.c
 * Copyright (C) 1992 Krishna Balasubramanian
 */

#include <linux/config.h>
#include <linux/errno.h>
#include <linux/sched.h>
#include <linux/string.h>
#include <asm/segment.h>
#include <asm/system.h>
#include <linux/ldt.h>

extern "C" int sys_modify_ldt(int func, void *ptr)
{
    struct modify_ldt_ldt_s ldt_info;
    unsigned long *lp;
    int error, i;

    switch (func)
    {
      case 0:
	if(!current->ldt){
		error = verify_area(VERIFY_WRITE, ptr, sizeof(default_ldt));
		if (error)
			return error;
		
		memcpy_tofs(ptr, &default_ldt, sizeof(default_ldt));
	} else {
		error = verify_area(VERIFY_WRITE, ptr, PAGE_SIZE);
		if (error)
			return error;
		
		memcpy_tofs(ptr, current->ldt, PAGE_SIZE);
	};
	return 0;

      case 1:
	error = verify_area(VERIFY_READ, ptr, sizeof(ldt_info));
	if (error)
	    return error;
	
	if(!current->ldt){
		for (i=1 ; i<NR_TASKS ; i++)
			if (task[i] == current) {
				current->ldt = (struct desc_struct *)
					get_free_page(GFP_KERNEL);
				memset(current->ldt, 0, PAGE_SIZE);
				set_ldt_desc(gdt+(i<<1)+FIRST_LDT_ENTRY,
					     current->ldt, 512);
				load_ldt(i);
			};
	};

	memcpy_fromfs(&ldt_info, ptr, sizeof(ldt_info));
	if (ldt_info.contents == 3 || ldt_info.entry_number >= 512)
	    return -EINVAL;

	if (ldt_info.limit_in_pages)
	{
	    if (ldt_info.base_addr + (ldt_info.limit * 4096) >= 0xC0000000)
		return -EINVAL;
	}
	else
	{
	    if (ldt_info.base_addr + ldt_info.limit >= 0xC0000000)
		return -EINVAL;
	}
	
	lp = (unsigned long *) &current->ldt[ldt_info.entry_number];
       	*lp = ((ldt_info.base_addr & 0x0000ffff) << 16) |
	      (ldt_info.limit & 0x0ffff);
	*(lp+1) = (ldt_info.base_addr & 0xff000000) |
	          ((ldt_info.base_addr & 0x00ff0000)>>16) |
		  (ldt_info.limit & 0xf0000) |
		  (ldt_info.contents << 10) |
		  ((ldt_info.read_exec_only ^ 1) << 9) |
		  (ldt_info.seg_32bit << 22) |
		  (ldt_info.limit_in_pages << 23) |
       	          0xf000;
	return 0;
    }
    
    return -ENOSYS;
}
