/* 
 *
 * $Id: k3bcuefileparser.h,v 1.5 2004/01/28 16:47:57 trueg Exp $
 * Copyright (C) 2003 Sebastian Trueg <trueg@k3b.org>
 *
 * This file is part of the K3b project.
 * Copyright (C) 1998-2004 Sebastian Trueg <trueg@k3b.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * See the file "COPYING" for the exact licensing terms.
 */

#ifndef _K3B_CUEFILE_PARSER_H_
#define _K3B_CUEFILE_PARSER_H_

#include "k3bimagefilereader.h"


/**
 * This class should be able to parse all cuefile stuff.
 * for now it only checks the ending and searches for a file
 * statement.
 */
class K3bCueFileParser : public K3bImageFileReader
{
 public:
  K3bCueFileParser( const QString& filename = QString::null );
  ~K3bCueFileParser();

  /**
   * CDRDAO does not use this image filename but replaces the extension from the cue file
   * with "bin" to get the image filename.
   * So in this case cdrecord won't be able to burn the cue file. That is why we need this hack.
   */
  bool imageFilenameInCue() const { return m_imageFilenameInCue; }

 private:
  void readFile();
  bool parseLine( QString& line );
  void simplifyWhiteSpace( QString& s );

  bool m_imageFilenameInCue;

  class Private;
  Private* d;
};

#endif
