/*
 * Copyright (C) 2003-2005 the xine-project
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 * $Id: client.c,v 1.4 2005/01/03 22:06:03 dsalt Exp $
 *
 * gxine Javascript client
 */

#include "config.h"
#include "i18n.h"

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <string.h>
#include <fcntl.h>
#include <signal.h>

#define SOCKET_FILENAME "%s/.gxine/socket"
#define BUF_LEN 1024

static volatile int done = 0;

static void sigpipe (int sig)
{
  done = 1;
  signal (SIGPIPE, sigpipe);
}

int main (int argc, char **argv) {

  int                fd;
  struct sockaddr_un cli_adr, serv_adr;
  int                length = sizeof(struct sockaddr_un);
  char               filename [1024];
  char              *tstr;
  int		     ret = 0;

  signal (SIGPIPE, sigpipe);

  /* server filename */
  snprintf (filename, 1024, SOCKET_FILENAME, getenv ("HOME")); 

  printf (_("Connecting to %s...\n"), filename);

  fd = socket (AF_UNIX, SOCK_STREAM, 0);

  /* initialize the client address structure */
  memset (&cli_adr, 0, sizeof (cli_adr));
  cli_adr.sun_family = AF_UNIX;
  tstr = tmpnam (NULL);
  strcpy (cli_adr.sun_path, tstr);
  
  unlink (tstr);

  /* bind the socket to the client's address */
  if (bind (fd, (struct sockaddr*) &cli_adr, length) < 0) {
    perror ("bind");
    exit (EXIT_FAILURE);
  }

  /* initialize the server address structure */
  memset(&serv_adr, 0, sizeof(serv_adr));
  serv_adr.sun_family = AF_UNIX;
  strcpy (serv_adr.sun_path, filename);

  if (connect (fd, (struct sockaddr *) &serv_adr, sizeof (serv_adr)) < 0) {
    perror ("connect");
    exit (EXIT_FAILURE);
  }
  
  printf (_("Connected.\n"));

  if (argc>1) {

    /* noninteractive */

    printf (_("Sending command\n"));

    write (fd, argv[1], strlen(argv[1]));
    write (fd, "\n", 1);

    printf (_("Done.\n"));

  } else {
    /* interactive mode */
    int    n;

    if (fd>STDIN_FILENO)
      n=fd+1;
    else
      n=STDIN_FILENO+1;

    while (!done) {

      char buf[10];
      fd_set rset;

      FD_ZERO (&rset);
      FD_SET  (fd, &rset);
      FD_SET  (STDIN_FILENO, &rset);

      if (select (n, &rset, NULL, NULL, NULL) <= 0) {
	perror ("client: select: ");
	ret = 2;
	break;
      }

      if (FD_ISSET (fd, &rset)) {
	if (read (fd, buf, 1)==1)
	  write (STDOUT_FILENO, buf, 1);
      }

      if (FD_ISSET (STDIN_FILENO, &rset)) {
	if (read (STDIN_FILENO, buf, 1)==1)
	  write (fd, buf, 1);
      }
    }
  }

  close(fd);

  unlink (tstr);

  return ret;
}
