#include "palettedialog.h"
#include "palette.h"

#include <kdebug.h>
#include <qpushbutton.h>
#include <klocale.h>
#include <kapplication.h>

#include <qlayout.h>

paletteDialog::paletteDialog(QPixmap *p, QWidget *parent, const char *name)
  : KDialogBase(parent, name, true, i18n( "Edit Palette" ), Ok|Cancel,
    Ok, true)
{
    resize(340, 280);
    QWidget *w = makeMainWidget();
    QVBoxLayout *box = new QVBoxLayout( w, 0 );

    pal= new paletteWidget(p, w);
    pal->move(10, 10);
    box->addWidget( pal );

    connect( pal, SIGNAL(colourSelected(int)), pal, SLOT(editColour(int)) );
}

QPixmap *paletteDialog::pixmap() const
{
  return pal->pixmap();
}

#include "palettedialog.moc"
