/* -*- mode: C++; tab-width: 4; c-basic-offset: 4; -*- */

/* AbiWord
 * Copyright (C) 2003 Francis James Franklin <fjf@alinameridon.com>
 * Copyright (C) 2003 AbiSource, Inc.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
 * 02111-1307, USA.
 */

class ABI_EXPORT UT_CSS
{
public:
	enum CSSPropertyIndex // list taken from http://www.w3.org/TR/2003/WD-CSS21-20030128/propidx.html
	{
		css_azimuth = 0,
		css_background_attachment,
		css_background_color,
		css_background_image,
		css_background_position,
		css_background_repeat,
		css_background,
		css_border_collapse,
		css_border_color,
		css_border_spacing,
		css_border_style,
		css_border_top,
		css_border_right,
		css_border_bottom,
		css_border_left,
		css_border_top_color,
		css_border_right_color,
		css_border_bottom_color,
		css_border_left_color,
		css_border_top_style,
		css_border_right_style,
		css_border_bottom_style,
		css_border_left_style,
		css_border_top_width,
		css_border_right_width,
		css_border_bottom_width,
		css_border_left_width,
		css_border_width,
		css_border,
		css_bottom,
		css_caption_side,
		css_clear,
		css_clip,
		css_color,
		css_content,
		css_counter_increment,
		css_counter_reset,
		css_cue_after,
		css_cue_before,
		css_cue,
		css_cursor,
		css_direction,
		css_display,
		css_elevation,
		css_empty_cells,
		css_float,
		css_font_family,
		css_font_size,
		css_font_style,
		css_font_variant,
		css_font_weight,
		css_font,
		css_height,
		css_left,
		css_letter_spacing,
		css_line_height,
		css_list_style_image,
		css_list_style_position,
		css_list_style_type,
		css_list_style_type,
		css_list_style,
		css_margin_right,
		css_margin_left,
		css_margin_top,
		css_margin_bottom,
		css_margin,
		css_max_height,
		css_max_width,
		css_min_height,
		css_min_width,
		css_orphans,
		css_outline_color,
		css_outline_style,
		css_outline_width,
		css_outline,
		css_overflow,
		css_padding_top,
		css_padding_right,
		css_padding_bottom,
		css_padding_left,
		css_padding,
		css_page_break_after,
		css_page_break_before,
		css_page_break_inside,
		css_pause_after,
		css_pause_before,
		css_pause,
		css_pitch_range,
		css_pitch,
		css_play_during,
		css_position,
		css_quotes,
		css_richness,
		css_right,
		css_speak_header,
		css_speak_numeral,
		css_speak_punctuation,
		css_speak,
		css_speech_rate,
		css_stress,
		css_table_layout,
		css_text_align,
		css_text_align,
		css_text_decoration,
		css_text_indent,
		css_text_transform,
		css_top,
		css_unicode_bidi,
		css_vertical_align,
		css_visibility,
		css_voice_family,
		css_volume,
		css_white_space,
		css_widows,
		css_width,
		css_word_spacing,
		css_z_index,
		css__count__
	};

	class ABI_EXPORT Listener
	{
	public:
		virtual ~Listener () { }
		virtual css_property (CSSPropertyIndex index,     const UT_UTF8String & value) = 0;
		virtual css_property (const UT_UTF8String & name, const UT_UTF8String & value) = 0; // non-CSS name
	};

	static const char * css_property_name (CSSPropertyIndex index);

	static bool css_property_lookup (const char * name, CSSPropertyIndex & index);

	static void css_parse_style_attr (const char * style, Listener * listener);

	// 
};
