
#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <kglobal.h>
#include <kapplication.h>

#include "htmlsearch.h"

static KCmdLineOptions options[] =
{
  { "lang <lang>", I18N_NOOP("The language to index.."), "en" },
   KCmdLineLastOption // End of options.
};


int main(int argc, char *argv[])
{
  KAboutData aboutData( "khtmlindex", I18N_NOOP("KHtmlIndex"),
	"$Id: index.cpp,v 1.8 2003/01/23 07:11:24 mlaurent Exp $",
	I18N_NOOP("KDE Index generator for help files."));

  KCmdLineArgs::init(argc, argv, &aboutData);
  KCmdLineArgs::addCmdLineOptions( options );

  KGlobal::locale()->setMainCatalogue("htmlsearch");
  KApplication app;
  HTMLSearch search;

  KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
  search.generateIndex(args->getOption("lang"));
}
