/***************************************************************************
                            kde_HTMLDocument.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_HTMLDOCUMENT
#define KDE_HTMLDOCUMENT

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 An <code> HTMLDocument </code> is the root of the HTML hierarchy
 and holds the entire content. Beside providing access to the
 hierarchy, it also provides some convenience methods for accessing
 certain sets of information from the document.

  The following properties have been deprecated in favor of the
 corresponding ones for the BODY element:

  <ulist> <item> alinkColor

  </item> <item> background

  </item> <item> bgColor

  </item> <item> fgColor

  </item> <item> linkColor

  </item> <item> vlinkColor

  </item> </ulist>

 
 @short *
 An <code> HTMLDocument </code> is the root of the HTML hierarchy
 and holds the entire content.
*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_HTMLDocument * kde_new_HTMLDocument();

/** *
 The parent is the widget the document should render itself in.
 Rendering information (like sizes, etc...) is only created if
 parent != 0
     
*/
kde_HTMLDocument * kde_new_HTMLDocument1(kde_KHTMLView* parent);
kde_HTMLDocument * kde_new_HTMLDocument2(kde_HTMLDocument* other);
kde_HTMLDocument * kde_new_HTMLDocument3(kde_DOMNode* other);
void kde_del_HTMLDocument( kde_HTMLDocument* p );

/** *
 The title of a document as specified by the <code> TITLE
 </code> element in the head of the document.

     
*/
kde_DOMString* kde_HTMLDocument_title(kde_HTMLDocument* instPointer);

/** *
 see @ref title
     
*/
void kde_HTMLDocument_setTitle(kde_HTMLDocument* instPointer,kde_DOMString* arg1);

/** *
 Returns the URI of the page that linked to this page. The value
 is an empty string if the user navigated to the page directly
 (not through a link, but, for example, via a bookmark).
     
*/
kde_DOMString* kde_HTMLDocument_referrer(kde_HTMLDocument* instPointer);

/** *
 The domain name of the server that served the document, or a
 null string if the server cannot be identified by a domain
 name.

     
*/
kde_DOMString* kde_HTMLDocument_domain(kde_HTMLDocument* instPointer);

/** *
 The absolute URI of the document.
     
*/
kde_DOMString* kde_HTMLDocument_URL(kde_HTMLDocument* instPointer);

/** *
 The element that contains the content for the document. In
 documents with <code> BODY </code> contents, returns the <code>
 BODY </code> element, and in frameset documents, this returns
 the outermost <code> FRAMESET </code> element.

     
*/
kde_HTMLElement* kde_HTMLDocument_body(kde_HTMLDocument* instPointer);

/** *
 see @ref body
     
*/
void kde_HTMLDocument_setBody(kde_HTMLDocument* instPointer,kde_HTMLElement* arg1);

/** *
 A collection of all the <code> IMG </code> elements in a
 document. The behavior is limited to <code> IMG </code>
 elements for backwards compatibility.

     
*/
kde_HTMLCollection* kde_HTMLDocument_images(kde_HTMLDocument* instPointer);

/** *
 A collection of all the <code> OBJECT </code> elements that
 include applets and <code> APPLET </code> ( deprecated )
 elements in a document.

     
*/
kde_HTMLCollection* kde_HTMLDocument_applets(kde_HTMLDocument* instPointer);

/** *
 A collection of all <code> AREA </code> elements and anchor (
 <code> A </code> ) elements in a document with a value for the
 <code> href </code> attribute.

     
*/
kde_HTMLCollection* kde_HTMLDocument_links(kde_HTMLDocument* instPointer);

/** *
 A collection of all the forms of a document.

     
*/
kde_HTMLCollection* kde_HTMLDocument_forms(kde_HTMLDocument* instPointer);

/** *
 A collection of all the anchor ( <code> A </code> ) elements in
 a document with a value for the <code> name </code> attribute.
 Note. For reasons of backwards compatibility, the returned set
 of anchors only contains those anchors created with the <code>
 name </code> attribute, not those created with the <code> id
 </code> attribute.

     
*/
kde_HTMLCollection* kde_HTMLDocument_anchors(kde_HTMLDocument* instPointer);

/** *
 The cookies associated with this document. If there are none,
 the value is an empty string. Otherwise, the value is a string:
 a semicolon-delimited list of "name, value" pairs for all the
 cookies associated with the page. For example, <code>
 name=value;expires=date </code> .

     
*/
kde_DOMString* kde_HTMLDocument_cookie(kde_HTMLDocument* instPointer);

/** *
 see @ref cookie
     
*/
void kde_HTMLDocument_setCookie(kde_HTMLDocument* instPointer,kde_DOMString* arg1);

/** *
 Note. This method and the ones following allow a user to add to
 or replace the structure model of a document using strings of
 unparsed HTML. At the time of writing alternate methods for
 providing similar functionality for both HTML and XML documents
 were being considered. The following methods may be deprecated
 at some point in the future in favor of a more general-purpose
 mechanism.

  Open a document stream for writing. If a document exists in
 the target, this method clears it.

     
*/
void kde_HTMLDocument_open(kde_HTMLDocument* instPointer);

/** *
 Closes a document stream opened by <code> open() </code> and
 forces rendering.

     
*/
void kde_HTMLDocument_close(kde_HTMLDocument* instPointer);

/** *
 Write a string of text to a document stream opened by <code>
 open() </code> . The text is parsed into the document's
 structure model.

     
*/
void kde_HTMLDocument_write(kde_HTMLDocument* instPointer,kde_DOMString* text);

/** *
 Write a string of text followed by a newline character to a
 document stream opened by <code> open() </code> . The text is
 parsed into the document's structure model.

     
*/
void kde_HTMLDocument_writeln(kde_HTMLDocument* instPointer,kde_DOMString* text);

/** *
 Returns the (possibly empty) collection of elements whose
 <code> name </code> value is given by <code> elementName
 </code> .

     
*/
kde_DOMNodeList* kde_HTMLDocument_getElementsByName(kde_HTMLDocument* instPointer,kde_DOMString* elementName);

/** *
 not part of the DOM

 converts the given (potentially relative) URL in a
 full-qualified one, using the baseURL / document URL for
 the missing parts.
     
*/
kde_DOMString* kde_HTMLDocument_completeURL(kde_HTMLDocument* instPointer,kde_DOMString* url);

/** *
 Not part of the DOM

 The date the document was last modified.
     
*/
kde_DOMString* kde_HTMLDocument_lastModified(kde_HTMLDocument* instPointer);

/** *
 Not part of the DOM

 A collection of all the <code>IMG</code>, <code>OBJECT</code>,
 <code>AREA</code>, <code>A</code>, forms and anchor elements of
 a document.
     
*/
kde_HTMLCollection* kde_HTMLDocument_all(kde_HTMLDocument* instPointer);

#ifdef __cplusplus
}
#endif
#endif
