/***************************************************************************
                            kde_HTMLSelectElement.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_HTMLSELECTELEMENT
#define KDE_HTMLSELECTELEMENT

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 The select element allows the selection of an option. The contained
 options can be directly accessed through the select element as a
 collection. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.html#edef-SELECT">
 SELECT element definition </a> in HTML 4.0.

 
 @short *
 The select element allows the selection of an option.
*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_HTMLSelectElement * kde_new_HTMLSelectElement();
kde_HTMLSelectElement * kde_new_HTMLSelectElement1(kde_HTMLSelectElement* other);
kde_HTMLSelectElement * kde_new_HTMLSelectElement2(kde_DOMNode* other);
void kde_del_HTMLSelectElement( kde_HTMLSelectElement* p );

/** *
 The type of control created.

     
*/
kde_DOMString* kde_HTMLSelectElement_type(kde_HTMLSelectElement* instPointer);

/** *
 The ordinal index of the selected option. The value -1 is
 returned if no element is selected. If multiple options are
 selected, the index of the first selected option is returned.

     
*/
long kde_HTMLSelectElement_selectedIndex(kde_HTMLSelectElement* instPointer);

/** *
 see @ref selectedIndex
     
*/
void kde_HTMLSelectElement_setSelectedIndex(kde_HTMLSelectElement* instPointer,long arg1);

/** *
 The current form control value.

     
*/
kde_DOMString* kde_HTMLSelectElement_value(kde_HTMLSelectElement* instPointer);

/** *
 see @ref value
     
*/
void kde_HTMLSelectElement_setValue(kde_HTMLSelectElement* instPointer,kde_DOMString* arg1);

/** *
 The number of options in this <code> SELECT </code> .

     
*/
long kde_HTMLSelectElement_length(kde_HTMLSelectElement* instPointer);

/** *

     
*/
kde_HTMLFormElement* kde_HTMLSelectElement_form(kde_HTMLSelectElement* instPointer);

/** *
 The collection of <code> OPTION </code> elements contained by
 this element.

     
*/
kde_HTMLCollection* kde_HTMLSelectElement_options(kde_HTMLSelectElement* instPointer);

/** *
 The control is unavailable in this context. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-disabled">
 disabled attribute definition </a> in HTML 4.0.

     
*/
int kde_HTMLSelectElement_disabled(kde_HTMLSelectElement* instPointer);

/** *
 see @ref disabled
     
*/
void kde_HTMLSelectElement_setDisabled(kde_HTMLSelectElement* instPointer,int arg1);

/** *
 If true, multiple <code> OPTION </code> elements may be
 selected in this <code> SELECT </code> . See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-multiple">
 multiple attribute definition </a> in HTML 4.0.

     
*/
int kde_HTMLSelectElement_multiple(kde_HTMLSelectElement* instPointer);

/** *
 see @ref multiple
     
*/
void kde_HTMLSelectElement_setMultiple(kde_HTMLSelectElement* instPointer,int arg1);

/** *
 Form control or object name when submitted with a form. See the
 <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-name-SELECT">
 name attribute definition </a> in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLSelectElement_name(kde_HTMLSelectElement* instPointer);

/** *
 see @ref name
     
*/
void kde_HTMLSelectElement_setName(kde_HTMLSelectElement* instPointer,kde_DOMString* arg1);

/** *
 Number of visible rows. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-size-SELECT">
 size attribute definition </a> in HTML 4.0.

     
*/
long kde_HTMLSelectElement_size(kde_HTMLSelectElement* instPointer);

/** *
 see @ref size
     
*/
void kde_HTMLSelectElement_setSize(kde_HTMLSelectElement* instPointer,long arg1);

/** *
 Index that represents the element's position in the tabbing
 order. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-tabindex">
 tabindex attribute definition </a> in HTML 4.0.

     
*/
long kde_HTMLSelectElement_tabIndex(kde_HTMLSelectElement* instPointer);

/** *
 see @ref tabIndex
     
*/
void kde_HTMLSelectElement_setTabIndex(kde_HTMLSelectElement* instPointer,long arg1);

/** *
 Add a new element to the collection of <code> OPTION </code>
 elements for this <code> SELECT </code> .

     
*/
void kde_HTMLSelectElement_add(kde_HTMLSelectElement* instPointer,kde_HTMLElement* element, kde_HTMLElement* before);

/** *
 Remove an element from the collection of <code> OPTION </code>
 elements for this <code> SELECT </code> . Does nothing if no
 element has the given index.

     
*/
void kde_HTMLSelectElement_remove(kde_HTMLSelectElement* instPointer,long index);

/** *
 Removes keyboard focus from this element.

     
*/
void kde_HTMLSelectElement_blur(kde_HTMLSelectElement* instPointer);

/** *
 Gives keyboard focus to this element.

     
*/
void kde_HTMLSelectElement_focus(kde_HTMLSelectElement* instPointer);

#ifdef __cplusplus
}
#endif
#endif
