/***************************************************************************
                            kde_KLocale.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KLOCALE
#define KDE_KLOCALE

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*

 KLocale provides support for country specific stuff like
 the national language.

 KLocale supports translating, as well as specifying the format
 for numbers, currency, time, and date.

 @author Stephan Kulow <coolo@kde.org>, Preston Brown <pbrown@kde.org>,
 Hans Petter Bieker <bieker@kde.org>, Lukas Tinkl <lukas.tinkl@suse.cz>

 @short class for supporting locale settings and national language.
*/
#define KLOCALE_ParensAround	0
#define KLOCALE_BeforeQuantityMoney	1
#define KLOCALE_AfterQuantityMoney	2
#define KLOCALE_BeforeMoney	3
#define KLOCALE_AfterMoney	4
#define KLOCALE_Metric	0
#define KLOCALE_Imperial	1

/** *
 Constructs a KLocale with the given catalogue name.
 The constructor looks for an entry Locale/Language in the
 configuration file.
 If no config file is specified, it will also look for languages
 using the environment variables (KDE_LANG, LC_MESSAGES, LC_ALL, LANG),
 as well as the global configuration fie. If we were not able to use
 non of the specified languages, the default language (en_US) will be
 used.

 If you specify a configuration file, it has to be valid until
 the KLocale object is destroyed.

*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_KLocale * kde_new_KLocale(qt_QString * catalogue, kde_KConfig* config);

/** *
 Copy constructor.
   
*/
kde_KLocale * kde_new_KLocale1(kde_KLocale* rhs);

/** *
 Destructor.
   
*/
void kde_del_KLocale( kde_KLocale* p );

/** *
 Translates the string into the corresponding string in
 the national language, if available. If not, returns
 the string itself.
 There is a KDE wide message file that contains the most
 often used phrases, so we can avoid duplicating the
 translation of these phrases. If a phrase is not found
 in the catalogue given to the constructor, it will search
 in the system catalog. This makes it possible to override
 some phrases for your needs.

  The argument must be an UTF-8 encoded string (If you only use
  characters that are in US-ASCII you're on the safe side. But
  for e.g. german umlauts or french accents should be recoded to
  UTF-8)

*/
qt_QString * kde_KLocale_translate(kde_KLocale* instPointer,char* index);

/** *
 Translates the string into the corresponding string in the
 national language, if available.

 The real contents of the string is in the argument fallback,
 but the meaning of it is coded into the argument index.
 In some cases you'll need this function, when english is
 too ambiguous to express it.

 Most of the times the translators will tell you if it can't
 be translated as it, but think of cases as "New", where the
 translations differs depending on what is New.
 Or simple cases as "Open", that can be used to express something
 is open or it can be used to express that you want something to
 open... There are tons of such examples.

 If translate("Open") is not enough to translate it well, use
 translate("To Open", "Open") or translate("Is Open", "Open").
 The english user will see "Open" in both cases, but the translated
 version may vary. Of course you can also use i18n()

*/
qt_QString * kde_KLocale_translate1(kde_KLocale* instPointer,char* index, char* fallback);

/** *
 Used to get the correct, translated singular or plural of a
 word.

*/
qt_QString * kde_KLocale_translate2(kde_KLocale* instPointer,char* singular, char* plural, unsigned long n);

/** *

*/

/** *
 Changes the current encoding.

*/
int kde_KLocale_setEncoding(kde_KLocale* instPointer,int mibEnum);

/** *
 Changes the current language. The current language will be left
 unchanged if failed. It will force a reload of the country specific
 configuration as well.

*/
int kde_KLocale_setLanguage(kde_KLocale* instPointer,qt_QString * language);

/** *
 Changes the list of prefed languages for the locale. The first valid
 language in the list will be used, or the default (en_US) language
 will be used if non of the specified languages were available.

*/
int kde_KLocale_setLanguage1(kde_KLocale* instPointer,qt_QStringList* languages);

/** *
 Changes the current country. The current country will be left
 unchanged if failed. It will force a reload of the country specific
 configuration.

*/
int kde_KLocale_setCountry(kde_KLocale* instPointer,qt_QString * country);

/** *
 Returns what a decimal point should look like ("." or "," etc.)
 according to the current locale or user settings.

*/
qt_QString * kde_KLocale_decimalSymbol(kde_KLocale* instPointer);

/** *
 Returns what the thousands separator should look
 like ("," or "." etc.)
 according to the current locale or user settings.

*/
qt_QString * kde_KLocale_thousandsSeparator(kde_KLocale* instPointer);

/** *
 Returns what the symbol denoting currency in the current locale
 as as defined by user settings should look like.

*/
qt_QString * kde_KLocale_currencySymbol(kde_KLocale* instPointer);

/** *
 Returns what a decimal point should look like ("." or "," etc.)
 for monetary values, according to the current locale or user
 settings.

*/
qt_QString * kde_KLocale_monetaryDecimalSymbol(kde_KLocale* instPointer);

/** *
 Returns what a thousands separator for monetary values should
 look like ("," or " " etc.) according to the current locale or
 user settings.

*/
qt_QString * kde_KLocale_monetaryThousandsSeparator(kde_KLocale* instPointer);

/** *
 Returns what a positive sign should look like ("+", " ", etc.)
 according to the current locale or user settings.

*/
qt_QString * kde_KLocale_positiveSign(kde_KLocale* instPointer);

/** *
 Returns what a negative sign should look like ("-", etc.)
 according to the current locale or user settings.

*/
qt_QString * kde_KLocale_negativeSign(kde_KLocale* instPointer);

/** *
 The number of fractional digits to include in numeric/monetary
 values (usually 2).

*/
int kde_KLocale_fracDigits(kde_KLocale* instPointer);

/** *
 If and only if the currency symbol precedes a positive value,
 this will be true.

*/
int kde_KLocale_positivePrefixCurrencySymbol(kde_KLocale* instPointer);

/** *
 If and only if the currency symbol precedes a negative value,
 this will be true.

*/
int kde_KLocale_negativePrefixCurrencySymbol(kde_KLocale* instPointer);

/** *
 Returns the position of a positive sign in relation to a
 monetary value.

*/
int kde_KLocale_positiveMonetarySignPosition(kde_KLocale* instPointer);

/** *
 Denotes where to place a negative sign in relation to a
 monetary value.

*/
int kde_KLocale_negativeMonetarySignPosition(kde_KLocale* instPointer);

/** *
 Given a double, converts that to a numeric string containing
 the localized monetary equivalent.

 e.g. given 123456, return "$ 123,456.00".

*/
qt_QString * kde_KLocale_formatMoney(kde_KLocale* instPointer,double num, qt_QString * currency, int digits);

/** *

 a QString as the argument for convenience.

*/
qt_QString * kde_KLocale_formatMoney1(kde_KLocale* instPointer,qt_QString * numStr);

/** *
 Given a double, converts that to a numeric string containing
 the localized numeric equivalent.

 e.g. given 123456.78, return "123,456.78" (for some European country).
 If precision isn't specified, 2 is used.

*/
qt_QString * kde_KLocale_formatNumber(kde_KLocale* instPointer,double num, int precision);

/** *

 a QString as the argument for convenience.

*/
qt_QString * kde_KLocale_formatNumber1(kde_KLocale* instPointer,qt_QString * numStr);

/** *
 Use this to determine whether nouns are declined in
 locale's language. This property should remain
 read-only (no setter function)

*/
int kde_KLocale_nounDeclension(kde_KLocale* instPointer);

/** *
 Returns a string formatted to the current locale's conventions
 regarding dates.

*/
qt_QString * kde_KLocale_formatDate(kde_KLocale* instPointer,qt_QDate * pDate, int shortFormat);

/** *
 Use this to determine whether in dates a possessive form of month
 name is preferred ("of January" rather than "January")

*/
int kde_KLocale_dateMonthNamePossessive(kde_KLocale* instPointer);

/** *
 Returns a string formatted to the current locale's conventions
 regarding times.

*/
qt_QString * kde_KLocale_formatTime(kde_KLocale* instPointer,qt_QTime * pTime, int includeSecs);

/** *
 Use this to determine if the user wants a 12 hour clock.

*/
int kde_KLocale_use12Clock(kde_KLocale* instPointer);

/** *

 Please use the @ref weekStartDay method instead.

 Use this to determine if the user wants the week to start on Monday.

*/
int kde_KLocale_weekStartsMonday(kde_KLocale* instPointer);

/** *
 Use this to determine which day is the first day of the week.

*/
int kde_KLocale_weekStartDay(kde_KLocale* instPointer);

/** *
 Returns a string containing the name of the month name.

*/
qt_QString * kde_KLocale_monthName(kde_KLocale* instPointer,int i, int shortName);

/** *
 Returns a string containing the possessive form of the month name.
 ("of January", "of February", etc.)
 It's needed in long format dates in some languages.

*/
qt_QString * kde_KLocale_monthNamePossessive(kde_KLocale* instPointer,int i, int shortName);

/** *
 Returns a string containing the name of the week day.

*/
qt_QString * kde_KLocale_weekDayName(kde_KLocale* instPointer,int i, int shortName);

/** *
 Returns a string formated to the current locale's conventions
 regarding both date and time.

*/
qt_QString * kde_KLocale_formatDateTime(kde_KLocale* instPointer,qt_QDateTime * pDateTime, int shortFormat, int includeSecs);

/** *
 Converts a localized monetary string to a double.

*/
double kde_KLocale_readMoney(kde_KLocale* instPointer,qt_QString * numStr, int* ok);

/** *
 Converts a localized numeric string to a double.

*/
double kde_KLocale_readNumber(kde_KLocale* instPointer,qt_QString * numStr, int* ok);

/** *
 Converts a localized date string to a QDate.
 The bool pointed by ok will be invalid if the date entered was not valid.

*/
qt_QDate * kde_KLocale_readDate(kde_KLocale* instPointer,qt_QString * str, int* ok);

/** *
 Converts a localized date string to a QDate, using the specified format.
 You will usually not want to use this method.
   
*/
qt_QDate * kde_KLocale_readDate1(kde_KLocale* instPointer,qt_QString * intstr, qt_QString * fmt, int* ok);

/** *
 Converts a localized time string to a QTime.
 The bool pointed by ok will be false if the time entered was not valid.

*/
qt_QTime * kde_KLocale_readTime(kde_KLocale* instPointer,qt_QString * str, int* ok);

/** *
 Returns the language used by this object. The domain AND the
 library translation must be available in this language.
 "en_US" is default, if no other available.

*/
qt_QString * kde_KLocale_language(kde_KLocale* instPointer);

/** *
 Returns the country code of the country where the user lives.
 "C" is default, if no other available

*/
qt_QString * kde_KLocale_country(kde_KLocale* instPointer);

/** *

*/
qt_QString * kde_KLocale_languages(kde_KLocale* instPointer);

/** *
 Returns the preferred languages as ISO 639-1 codes. This means
 that information about country is removed. If the internal language
 code might be represented by more than one 639-1 code, they will all be
 listed (but only once).

 If the selected languages are "nn, nb, pt_BR", you will get:
 "nn, no, nb, pt".

*/
qt_QStringList* kde_KLocale_languagesTwoAlpha(kde_KLocale* instPointer);

/** *
 Returns the languages selected by user. The codes returned here is the
 internal language codes.

*/
qt_QStringList* kde_KLocale_languageList(kde_KLocale* instPointer);

/** *

 This will be the charset defined in the config file.
 NOTE: This is no longer the same as encoding.
 "iso-8859-1" is default

*/

/** *
 Returns the user's preferred encoding.

*/
char* kde_KLocale_encoding(kde_KLocale* instPointer);

/** *
 Returns the user's preferred encoding.

*/
int kde_KLocale_encodingMib(kde_KLocale* instPointer);

/** *
 Returns the user's preferred encoding. Should never be NULL.

*/
qt_QTextCodec* kde_KLocale_codecForEncoding(kde_KLocale* instPointer);

/** *
 Changes the current date format.

 The format of the date is a string which contains variables that will
 be replaced:

*/
void kde_KLocale_setDateFormat(kde_KLocale* instPointer,qt_QString * format);

/** *
 Changes the current short date format.

 The format of the date is a string which contains variables that will
 be replaced:

*/
void kde_KLocale_setDateFormatShort(kde_KLocale* instPointer,qt_QString * format);

/** *
 Changes the form of month name used in dates.

*/
void kde_KLocale_setDateMonthNamePossessive(kde_KLocale* instPointer,int possessive);

/** *
 Changes the current time format.

 The format of the time is string a which contains variables that will
 be replaced:

*/
void kde_KLocale_setTimeFormat(kde_KLocale* instPointer,qt_QString * format);

/** *

 Please use @ref setWeekStartDay instead.

 Changes how KLocale defines the first day in week.

*/
void kde_KLocale_setWeekStartsMonday(kde_KLocale* instPointer,int start);

/** *
 Changes how KLocale defines the first day in week.

*/
void kde_KLocale_setWeekStartDay(kde_KLocale* instPointer,int day);

/** *
 Returns the currently selected date format.

*/
qt_QString * kde_KLocale_dateFormat(kde_KLocale* instPointer);

/** *
 Returns the currently selected short date format.

*/
qt_QString * kde_KLocale_dateFormatShort(kde_KLocale* instPointer);

/** *
 Returns the currently selected time format.

*/
qt_QString * kde_KLocale_timeFormat(kde_KLocale* instPointer);

/** *
 Changes the symbol used to identify the decimal pointer.

*/
void kde_KLocale_setDecimalSymbol(kde_KLocale* instPointer,qt_QString * symbol);

/** *
 Changes the separator used to group digits when formating numbers.

*/
void kde_KLocale_setThousandsSeparator(kde_KLocale* instPointer,qt_QString * separator);

/** *
 Changes the sign used to identify a positive number. Normally this is
 left blank.

*/
void kde_KLocale_setPositiveSign(kde_KLocale* instPointer,qt_QString * sign);

/** *
 Changes the sign used to identify a negative number.

*/
void kde_KLocale_setNegativeSign(kde_KLocale* instPointer,qt_QString * sign);

/** *
 Changes the sign position used for positive monetary values.

*/
void kde_KLocale_setPositiveMonetarySignPosition(kde_KLocale* instPointer,int signpos);

/** *
 Changes the sign position used for negative monetary values.

*/
void kde_KLocale_setNegativeMonetarySignPosition(kde_KLocale* instPointer,int signpos);

/** *
 Changes the position where the currency symbol should be printed for
 positive monetary values.

*/
void kde_KLocale_setPositivePrefixCurrencySymbol(kde_KLocale* instPointer,int prefix);

/** *
 Changes the position where the currency symbol should be printed for
 negative monetary values.

*/
void kde_KLocale_setNegativePrefixCurrencySymbol(kde_KLocale* instPointer,int prefix);

/** *
 Changes the number of digits used when formating numbers.

*/
void kde_KLocale_setFracDigits(kde_KLocale* instPointer,int digits);

/** *
 Changes the separator used to group digits when formating monetary values.

*/
void kde_KLocale_setMonetaryThousandsSeparator(kde_KLocale* instPointer,qt_QString * separator);

/** *
 Changes the symbol used to identify the decimal pointer for monetary
 values.

*/
void kde_KLocale_setMonetaryDecimalSymbol(kde_KLocale* instPointer,qt_QString * symbol);

/** *
 Changes the current currency symbol.

*/
void kde_KLocale_setCurrencySymbol(kde_KLocale* instPointer,qt_QString * symbol);

/** *
 Returns the preferred page size for printing.

*/
int kde_KLocale_pageSize(kde_KLocale* instPointer);

/** *
 Changes the preferred page size when printing.

*/
void kde_KLocale_setPageSize(kde_KLocale* instPointer,int paperFormat);

/** *
 Returns which measuring system we use.

*/
int kde_KLocale_measureSystem(kde_KLocale* instPointer);

/** *
 Changes the preferred measuring system.

*/
void kde_KLocale_setMeasureSystem(kde_KLocale* instPointer,int value);

/** *
 Adds another catalogue to search for translation lookup.
 This function is useful for extern libraries and/or code,
 that provides its own messages.

 If the catalogue does not exist for the chosen language,
 it will be ignored and en_US will be used.

*/
void kde_KLocale_insertCatalogue(kde_KLocale* instPointer,qt_QString * catalogue);

/** *
 Removes a catalog for translation lookup.

*/
void kde_KLocale_removeCatalogue(kde_KLocale* instPointer,qt_QString * catalogue);

/** *
 Sets the active catalog for translation lookup.

*/
void kde_KLocale_setActiveCatalogue(kde_KLocale* instPointer,qt_QString * catalogue);

/** *
 Translates a message as a QTranslator is supposed to.
 The parameters are similar to i18n(), but the result
 value has other semantics (it can be QString::null)

*/
qt_QString * kde_KLocale_translateQt(kde_KLocale* instPointer,char* context, char* sourceText, char* message);

/** *
 Returns list of all known ISO 639-1 codes.

*/
qt_QStringList* kde_KLocale_allLanguagesTwoAlpha(kde_KLocale* instPointer);

/** *
 Convert a ISO 639-1 code to a human readable form.

*/
qt_QString * kde_KLocale_twoAlphaToLanguageName(kde_KLocale* instPointer,qt_QString * code);

/** *
 Returns list of all known country codes.

*/
qt_QStringList* kde_KLocale_allCountriesTwoAlpha(kde_KLocale* instPointer);

/** *
 Convert a country code to a human readable form.

*/
qt_QString * kde_KLocale_twoAlphaToCountryName(kde_KLocale* instPointer,qt_QString * code);

/** *
 Returns the parts of the parameter str understood as language setting
 the format is language_COUNTRY.charset

*/
void kde_KLocale_splitLocale( qt_QString * str, qt_QString * language, qt_QString * country, qt_QString * charset);

/** *
 Use this to as main catalogue for *all* KLocales, if not the appname
 will be used. This function is best to be the very first instruction
 in your program's main function as it only has an effect before the
 first KLocale object is created (and this is in common KDE applications
 quite early).

*/
void kde_KLocale_setMainCatalogue( char* catalogue);

/** *
 Finds localized resource in resourceDir( rtype ) + <lang> + fname.

*/
qt_QString * kde_KLocale_langLookup( qt_QString * fname, char* rtype);

/** *
 Returns the name of the internal language.

*/
qt_QString * kde_KLocale_defaultLanguage( );

/** *
 Returns the name of the default country.

*/
qt_QString * kde_KLocale_defaultCountry( );

/** *

   
*/
qt_QString * kde_KLocale__initLanguage( kde_KConfigBase* config);

/** *

 pointer.
   
*/
void kde_KLocale_initInstance( );

#ifdef __cplusplus
}
#endif
#endif
