/***************************************************************************
                            kde_KURLComboBox.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KURLCOMBOBOX
#define KDE_KURLCOMBOBOX

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 This combobox shows a number of recent URLs/directories, as well as some
 default directories.
 It will manage the default dirs root-directory, home-directory and
 Desktop-directory, as well as a number of URLs set via @ref setURLs()
 and one additional entry to be set via @ref setURL().

 @author Carsten Pfeiffer <pfeiffer@kde.org>
 
 @short A combo box showing a number of recent URLs/directories.
*/
#define KURLCOMBOBOX_Files	-1
#define KURLCOMBOBOX_Directories	1
#define KURLCOMBOBOX_Both	0
#define KURLCOMBOBOX_RemoveTop	0
#define KURLCOMBOBOX_RemoveBottom	1

/** *
 Constructs a KURLComboBox.

*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_KURLComboBox * kde_new_KURLComboBox(int mode, qt_QWidget * parent, char* name);
kde_KURLComboBox * kde_new_KURLComboBox1(int mode, int rw, qt_QWidget * parent, char* name);

/** *
 Destructs the combo box.
     
*/
void kde_del_KURLComboBox( kde_KURLComboBox* p );

/** *
 Sets the current url. This combo handles exactly one url additionally
 to the default items and those set via @ref setURLs(). So you can call
 setURL() as often as you want, it will always replace the previous one
 set via setURL().
 If @p url is already in the combo, the last item will stay there
 and the existing item becomes the current item.
 The current item will always have the open-directory-pixmap as icon.

 Note that you won't receive any signals, e.g. textChanged(),
 returnPressed() or activated() upon calling this method.
     
*/
void kde_KURLComboBox_setURL(kde_KURLComboBox* instPointer,kde_KURL* url);

/** *
 Inserts @p urls into the combobox below the "default urls" (see
 @ref addDefaultURL).

 If the list of urls contains more items than maxItems, the first items
 will be stripped.
     
*/
void kde_KURLComboBox_setURLs(kde_KURLComboBox* instPointer,qt_QStringList* urls);

/** *
 Inserts @p urls into the combobox below the "default urls" (see
 @ref addDefaultURL).

 If the list of urls contains more items than maxItems, the @p remove
 parameter determines whether the first or last items will be stripped.
     
*/
void kde_KURLComboBox_setURLs1(kde_KURLComboBox* instPointer,qt_QStringList* urls, int remove);

/** *

*/
qt_QStringList* kde_KURLComboBox_urls(kde_KURLComboBox* instPointer);

/** *
 Sets how many items should be handled and displayed by the combobox.

*/
void kde_KURLComboBox_setMaxItems(kde_KURLComboBox* instPointer,int arg1);

/** *

*/
int kde_KURLComboBox_maxItems(kde_KURLComboBox* instPointer);

/** *
 Adds a url that will always be shown in the combobox, it can't be
 "rotated away". Default urls won't be returned in @ref urls() and don't
 have to be set via @ref setURLs().
 If you want to specify a special pixmap, use the overloaded method with
 the pixmap parameter.
 Default URLs will be inserted into the combobox by @ref setDefaults()
     
*/
void kde_KURLComboBox_addDefaultURL(kde_KURLComboBox* instPointer,kde_KURL* url, qt_QString * text);

/** *
 Adds a url that will always be shown in the combobox, it can't be
 "rotated away". Default urls won't be returned in @ref urls() and don't
 have to be set via @ref setURLs().
 If you don't need to specify a pixmap, use the overloaded method without
 the pixmap parameter.
 Default URLs will be inserted into the combobox by @ref setDefaults()
     
*/
void kde_KURLComboBox_addDefaultURL1(kde_KURLComboBox* instPointer,kde_KURL* url, qt_QPixmap * pix, qt_QString * text);

/** *
 Clears all items and inserts the default urls into the combo. Will be
 called implicitly upon the first call to @ref setURLs() or @ref setURL()

*/
void kde_KURLComboBox_setDefaults(kde_KURLComboBox* instPointer);

/** *
 Removes any occurence of @p url. If @p checkDefaultURLs is false
 default-urls won't be removed.
     
*/
void kde_KURLComboBox_removeURL(kde_KURLComboBox* instPointer,kde_KURL* url, int checkDefaultURLs);
void kde_KURLComboBox_init(kde_KURLComboBox* instPointer,int mode);
void kde_KURLComboBox_insertURLItem(kde_KURLComboBox* instPointer,kde_KURLComboItem* arg1);

/** *
 Uses KMimeType::pixmapForURL() to return a proper pixmap for @p url.
 In directory mode, a folder icon is always returned.
     
*/
qt_QPixmap * kde_KURLComboBox_getPixmap(kde_KURLComboBox* instPointer,kde_KURL* url);

/** *
 Updates @p item with @p pixmap and sets the url instead of the text
 of the KURLComboItem.
 Also works around a Qt bug.
     
*/
void kde_KURLComboBox_updateItem(kde_KURLComboBox* instPointer,kde_KURLComboItem* item, int index, qt_QPixmap * pix);
void kde_KURLComboBox_slotActivated(kde_KURLComboBox* instPointer,int arg1);

#ifdef __cplusplus
}
#endif
#endif
