/***************************************************************************
                            HTMLElement.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef HTMLELEMENT_H
#define HTMLELEMENT_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/Element.h>

/**

 All HTML element interfaces derive from this class. Elements that
 only expose the HTML core attributes are represented by the base
 <code> HTMLElement </code> interface. These elements are as
 follows:

  <ulist> <item> HEAD

  </item> <item> special: SUB, SUP, SPAN, BDO

  </item> <item> font: TT, I, B, U, S, STRIKE, BIG, SMALL

  </item> <item> phrase: EM, STRONG, DFN, CODE, SAMP, KBD, VAR,
 CITE, ACRONYM, ABBR

  </item> <item> list: DD, DT

  </item> <item> NOFRAMES, NOSCRIPT

  </item> <item> ADDRESS, CENTER

  </item> </ulist> Note. The <code> style </code> attribute for this
 interface is reserved for future usage.

 
 @short 
 All HTML element interfaces derive from this class.
*/

@class HTMLCollection;

@interface HTMLElement : Element 
- init;
- copyWithZone: (NSZone *) zone;
- initWithDOMNode: (DOMNode*)other;
- (void) dealloc;

/** 
 The element's identifier. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/global.-[html adef]-id">
 id attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) id;

/** 
 see @ref id
     
*/
- setId: (NSString *)arg1;

/** 
 The element's advisory title. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/global.-[html adef]-title">
 title attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) title;

/** 
 see @ref title
     
*/
- setTitle: (NSString *)arg1;

/** 
 Language code defined in RFC 1766. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/dirlang.-[html adef]-lang">
 lang attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) lang;

/** 
 see @ref lang
     
*/
- setLang: (NSString *)arg1;

/** 
 Specifies the base direction of directionally neutral text and
 the directionality of tables. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/dirlang.-[html adef]-dir">
 dir attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) dir;

/** 
 see @ref dir
     
*/
- setDir: (NSString *)arg1;

/** 
 The class attribute of the element. This attribute has been
 renamed due to conflicts with the "class" keyword exposed by
 many languages. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/global.-[html adef]-class">
 class attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) className;

/** 
 see @ref className
     
*/
- setClassName: (NSString *)arg1;

/** 
 The HTML code contained in this element.
 This function is not part of the DOM specifications as defined by the w3c.
     
*/
- (NSString *) innerHTML;

/** 
 Set the HTML content of this node.

*/
- setInnerHTML: (NSString *)html;

/** 
 The text contained in this element.
 This function is not part of the DOM specifications as defined by the w3c.
     
*/
- (NSString *) innerText;

/** 
 Set the text content of this node.

*/
- setInnerText: (NSString *)text;

/** 
 Retrieves a collection of nodes that are direct descendants of this node.
 IE-specific extension.
     
*/
- (HTMLCollection*) children;
- removeCSSProperty: (NSString *)property;
- addCSSProperty: (NSString *)property value: (NSString *)value;
@end

#endif
