/***************************************************************************
                            HTMLTableElement.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef HTMLTABLEELEMENT_H
#define HTMLTABLEELEMENT_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/HTMLElement.h>

/**

 The create* and delete* methods on the table allow authors to
 construct and modify tables. HTML 4.0 specifies that only one of
 each of the <code> CAPTION </code> , <code> THEAD </code> , and
 <code> TFOOT </code> elements may exist in a table. Therefore, if
 one exists, and the -createTHead or -createTFoot method is
 called, the method returns the existing THead or TFoot element. See
 the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.-[html edef]-TABLE">
 TABLE element definition </a> in HTML 4.0.

 
 @short 
 The create* and delete* methods on the table allow authors to
 construct and modify tables.
*/
@class HTMLCollection; 
@class HTMLTableCaptionElement; 
@class HTMLTableSectionElement; 

@interface HTMLTableElement : HTMLElement 
- init;
- copyWithZone: (NSZone *) zone;
- initWithDOMNode: (DOMNode*)other;
- (void) dealloc;

/** 
 Returns the table's <code> CAPTION </code> , or void if none
 exists.

     
*/
- (HTMLTableCaptionElement*) caption;

/** 
 see @ref caption
     
*/
- setCaption: (HTMLTableCaptionElement*)arg1;

/** 
 Returns the table's <code> THEAD </code> , or <code> null
 </code> if none exists.

     
*/
- (HTMLTableSectionElement*) tHead;

/** 
 see @ref tHead
     
*/
- setTHead: (HTMLTableSectionElement*)arg1;

/** 
 Returns the table's <code> TFOOT </code> , or <code> null
 </code> if none exists.

     
*/
- (HTMLTableSectionElement*) tFoot;

/** 
 see @ref tFoot
     
*/
- setTFoot: (HTMLTableSectionElement*)arg1;

/** 
 Returns a collection of all the rows in the table, including
 all in <code> THEAD </code> , <code> TFOOT </code> , all <code>
 TBODY </code> elements.

     
*/
- (HTMLCollection*) rows;

/** 
 Returns a collection of the defined table bodies.

     
*/
- (HTMLCollection*) tBodies;

/** 
 Specifies the table's position with respect to the rest of the
 document. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.-[html adef]-align-TABLE">
 align attribute definition </a> in HTML 4.0. This attribute is
 deprecated in HTML 4.0.

     
*/
- (NSString *) align;

/** 
 see @ref align
     
*/
- setAlign: (NSString *)arg1;

/** 
 Cell background color. See the <a
 href="http://www.w3.org/TR/REC-html40/present/graphics.-[html adef]-bgcolor">
 bgcolor attribute definition </a> in HTML 4.0. This attribute
 is deprecated in HTML 4.0.

     
*/
- (NSString *) bgColor;

/** 
 see @ref bgColor
     
*/
- setBgColor: (NSString *)arg1;

/** 
 The width of the border around the table. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.-[html adef]-border-TABLE">
 border attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) border;

/** 
 see @ref border
     
*/
- setBorder: (NSString *)arg1;

/** 
 Specifies the horizontal and vertical space between cell
 content and cell borders. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.-[html adef]-cellpadding">
 cellpadding attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) cellPadding;

/** 
 see @ref cellPadding
     
*/
- setCellPadding: (NSString *)arg1;

/** 
 Specifies the horizontal and vertical separation between cells.
 See the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.-[html adef]-cellspacing">
 cellspacing attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) cellSpacing;

/** 
 see @ref cellSpacing
     
*/
- setCellSpacing: (NSString *)arg1;

/** 
 Specifies which external table borders to render. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.-[html adef]-frame">
 frame attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) frame;

/** 
 see @ref frame
     
*/
- setFrame: (NSString *)arg1;

/** 
 Specifies which internal table borders to render. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.-[html adef]-rules">
 rules attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) rules;

/** 
 see @ref rules
     
*/
- setRules: (NSString *)arg1;

/** 
 Supplementary description about the purpose or structure of a
 table. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.-[html adef]-summary">
 summary attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) summary;

/** 
 see @ref summary
     
*/
- setSummary: (NSString *)arg1;

/** 
 Specifies the desired table width. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.-[html adef]-width-TABLE">
 width attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) width;

/** 
 see @ref width
     
*/
- setWidth: (NSString *)arg1;

/** 
 Create a table header row or return an existing one.

     
*/
- (HTMLElement*) createTHead;

/** 
 Delete the header from the table, if one exists.

     
*/
- deleteTHead;

/** 
 Create a table footer row or return an existing one.

     
*/
- (HTMLElement*) createTFoot;

/** 
 Delete the footer from the table, if one exists.

     
*/
- deleteTFoot;

/** 
 Create a new table caption object or return an existing one.

     
*/
- (HTMLElement*) createCaption;

/** 
 Delete the table caption, if one exists.

     
*/
- deleteCaption;

/** 
 Insert a new empty row in the table. Note. A table row cannot
 be empty according to HTML 4.0 Recommendation.

     
*/
- (HTMLElement*) insertRow: (long)index;

/** 
 Delete a table row.

     
*/
- deleteRow: (long)index;
@end

#endif
