/***************************************************************************
                            KStdAccel.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KSTDACCEL_H
#define KSTDACCEL_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**

 Convenient methods for access to the common accelerator keys in
 the key configuration. These are the standard keybindings that should
 be used in all KDE applications. They will be configurable,
 so do not hardcode the default behavior.

 If you want real configurable keybindings in your applications,
 please checkout the class @ref KAccel in kaccel.h
 
 @short 
 Convenient methods for access to the common accelerator keys in
 the key configuration.
*/
@class QKeyEvent; 
@class KShortcut;

@interface  KStdAccel : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}

/**  Returns the keybinding for @p accel. 
*/
- (KShortcut*) shortcut: (int)identifier;

/**  Returns a unique name for the given @p accel. 
*/
- (NSString *) name: (int)identifier;

/**  Returns a localized label for user-visible display. 
*/
- (NSString *) label: (int)identifier;

/**  Returns an extended WhatsThis description for the given accelerator. 
*/
- (NSString *) whatsThis: (int)identifier;

/** 
 Returns the hardcoded default shortcut for @p id.
 This does not take into account the user's configuration.
   
*/
- (KShortcut*) shortcutDefault: (int)identifier;

/** 
 Returns the hardcoded default 3 modifier shortcut for @p id.
 This does not take into account the user's configuration.
   
*/
- (KShortcut*) shortcutDefault3: (int)identifier;

/** 
 Returns the hardcoded default 4 modifier shortcut for @p id.
 This does not take into account the user's configuration.
   
*/
- (KShortcut*) shortcutDefault4: (int)identifier;
//- createAccelActions: (KAccelActions*)arg1;

/**  Open file. Default: Ctrl-o 
*/
- (KShortcut*) open;

/**  Create a new document (or whatever). Default: Ctrl-n 
*/
- (KShortcut*) openNew;

/**  Close current document. Default: Ctrl-w 
*/
- (KShortcut*) close;

/**  Save current document. Default: Ctrl-s 
*/
- (KShortcut*) save;

/**  Print current document. Default: Ctrl-p 
*/
- (KShortcut*) print;

/**  Quit the program. Default: Ctrl-q 
*/
- (KShortcut*) quit;

/**  Undo last operation. Default: Ctrl-z 
*/
- (KShortcut*) undo;

/**  Redo. Default: Shift-Ctrl-z 
*/
- (KShortcut*) redo;

/**  Cut selected area and store it in the clipboard. Default: Ctrl-x 
*/
- (KShortcut*) cut;

/**  Copy selected area into the clipboard. Default: Ctrl-c 
*/
- (KShortcut*) copy;

/**  Paste contents of clipboard at mouse/cursor position. Default: Ctrl-v 
*/
- (KShortcut*) paste;

/**  Reload. Default: Ctrl-A *
*/
- (KShortcut*) selectAll;

/**  Delete a word back from mouse/cursor position. Default: Ctrl-Backspace 
*/
- (KShortcut*) deleteWordBack;

/**  Delete a word forward from mouse/cursor position. Default: Ctrl-Delete 
*/
- (KShortcut*) deleteWordForward;

/**  Find, search. Default: Ctrl-f 
*/
- (KShortcut*) find;

/**  Find/search next. Default: F3 
*/
- (KShortcut*) findNext;

/**  Find/search previous. Default: Shift-F3 
*/
- (KShortcut*) findPrev;

/**  Find and replace matches. Default: Ctrl-r 
*/
- (KShortcut*) replace;

/**  Zoom in. Default: Ctrl-Plus 
*/
- (KShortcut*) zoomIn;

/**  Zoom out. Default: Ctrl-Minus 
*/
- (KShortcut*) zoomOut;

/**  Toggle insert/overwrite (with visual feedback, e.g. in the statusbar). Default: Insert 
*/
//- (KShortcut*) insert;

/**  Goto beginning of current line. Default: Home 
*/
- (KShortcut*) home;

/**  Goto end of current line. Default: End 
*/
- (KShortcut*) end;

/**  Scroll up one page. Default: Prior 
*/
- (KShortcut*) prior;

/**  Scroll down one page. Default: Next 
*/
- (KShortcut*) next;

/**  Go to line. Default: Ctrl+G 
*/
- (KShortcut*) gotoLine;

/**  Add current page to bookmarks. Default: Ctrl+B 
*/
- (KShortcut*) addBookmark;

/**  Help the user in the current situation. Default: F1 
*/
- (KShortcut*) help;

/**  Complete text in input widgets. Default Ctrl+E *
*/
- (KShortcut*) completion;

/**  Iterate through a list when completion returns
      mutiple items. Default: Ctrl+Up *
*/
- (KShortcut*) prevCompletion;

/**  Iterate through a list when completion returns
      mutiple items. Default: Ctrl+Down *
*/
- (KShortcut*) nextCompletion;

/**  Find a string within another string or list of strings.
      Default: Ctrl-T 
*/
- (KShortcut*) substringCompletion;

/**  Help users iterate through a list of entries. Default: Up *
*/
- (KShortcut*) rotateUp;

/**  Help users iterate through a list of entries. Default: Down *
*/
- (KShortcut*) rotateDown;

/**  popup a context menu. Default: Menu *
*/
- (KShortcut*) popupMenuContext;

/**  What's This button. Default: Shift+F1 *
*/
- (KShortcut*) whatsThis;

/**  Reload. Default: F5 *
*/
- (KShortcut*) reload;

/**  Up. Default: Alt+Up *
*/
- (KShortcut*) up;

/**  Back. Default: Alt+Left *
*/
- (KShortcut*) back;

/**  Forward. Default: ALT+Right *
*/
- (KShortcut*) forward;

/**  Show Menu Bar.  Default: Ctrl-M *
*/
- (KShortcut*) showMenubar;

/**  Obsolete.  Use -name.  Returns a string representation for @p accel. 
*/
- (NSString *) action: (int)identifier;

/**  Obsolete.  Use -desc.  Returns a localized description of @p accel. 
*/
- (NSString *) description: (int)identifier;

/**  Obsolete.  Use -shortcut.  Returns the keybinding for @p accel. 
*/
- (int) key: (int)arg1;

/**  Obsolete.  Use -shortcutDefault. 
*/
- (int) defaultKey: (int)accel;

/** 
 @depricated.  Use KKey(const QKeyEvent*) == KKey(int).

 Compare the keys generated by the key event with
 the value of the integer.

 If a modifier (Shift, Alt, Ctrl) key is present in
 @ref QKeyEvent, its sum with the actual key value
 is used for comparing it with the integer parameter.

*/
- (BOOL) isEqual: (QKeyEvent*)pEvent keyQt: (int)keyQt;
+ (int) AccelNone;
+ (int) Open;
+ (int) New;
+ (int) Close;
+ (int) Save;
+ (int) Print;
+ (int) Quit;
+ (int) Undo;
+ (int) Redo;
+ (int) Cut;
+ (int) Copy;
+ (int) Paste;
+ (int) SelectAll;
+ (int) Deselect;
+ (int) DeleteWordBack;
+ (int) DeleteWordForward;
+ (int) Find;
+ (int) FindNext;
+ (int) FindPrev;
+ (int) Replace;
+ (int) Home;
+ (int) End;
+ (int) Prior;
+ (int) Next;
+ (int) GotoLine;
+ (int) AddBookmark;
+ (int) ZoomIn;
+ (int) ZoomOut;
+ (int) Up;
+ (int) Back;
+ (int) Forward;
+ (int) Reload;
+ (int) PopupMenuContext;
+ (int) ShowMenubar;
+ (int) Help;
+ (int) WhatsThis;
+ (int) TextCompletion;
+ (int) PrevCompletion;
+ (int) NextCompletion;
+ (int) SubstringCompletion;
+ (int) RotateUp;
+ (int) RotateDown;
+ (int) WhatThis;
@end

#endif
