/***************************************************************************
                            KTipDatabase.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KTIPDATABASE_H
#define KTIPDATABASE_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**

 A database for tips-of-the-day.

 This class provides convenient access to a database containing
 tips of the day. The database is stored in a XML file and parsed
 when a KTipDatabase object is created.

 Once the file is read in, you can access the tips to display
 them in the tip of the day dialog.

 The state of the tipdialog is saved to the applications's config file
 in the group "TipOfDay" with a bool entry "RunOnStart". Check this value
 if you want to allow the user to enable/disable the tipdialog in the
 application's configuration dialog.

 
 @author Matthias Hoelzer-Kluepfel <mhk@caldera.de>

 @short 
 A database for tips-of-the-day.
*/
@interface  KTipDatabase : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}

/** 
 The constructor.

 This reads in the tips from a file with the given name. If no name is
 given, a file called 'application-name/tips' will be loaded.

*/
- initWithText: (NSString *)tipFile;
- init;

/** 
 Returns the current tip.
   
*/
- (NSString *) tip;

/** 
 The next tip will become the current one.
   
*/
- nextTip;

/** 
 The previous tip will become the current one.
   
*/
- prevTip;
@end

#endif
