#!/usr/bin/env kjscmd

function makeShape()
{
        var img = new Pixmap(this);
        var mask = new Pixmap(this);
        var painter = new Painter(this);

        var brush = new Brush(this);
        brush.setColor("black");
        brush.setStyle(Brush.SolidBrush);
        var pen = new Pen(this);
        pen.setColor("black");

        mask.resize(128,64);
        img.resize(128,64);
        img.fill("white");


        if( painter.begin( img ) )
        {
                painter.setPen(pen);
                painter.setBrush(brush);
                painter.drawRoundRect( 2,2,126,62, 25, 25 );
                if( painter.end() )
                        img = painter.pixmap();
        }

        img.setMask( img.createHeuristicMask(true) );
        return img;
}

function makeGradient(size)
{
	var img = new Image();
	img.gradient(size, "white", "black", img.PyramidGradient, 0);
	return img;
	
}

function bump()
{
    var img1 = new Image();
    var map = new Image();
    var mask = new Pixmap();

    img1.load( img1Loc );
    map.load( img2Loc );
    if ( !img1.isOk() && !map.isOk() ) {
	var pix = makeShape();
	img1.setPixmap(pix);	
	map = makeGradient( pix.size() );	
        mask = pix.mask();
    }

    println("Size 1: " + img1.width() + "x" + img1.height() );
    println("Size 2: " + map.width() + "x" + map.height() );
    var azmiuth = ui.child('azimuth').value; //135.0;
    var elevation = ui.child('elevation').value; //45;
    var depth = ui.child('depth').value; //3;
    var xofs = ui.child('xofs').value; //5;
    var yofs = ui.child('yofs').value; //5;
    var waterlevel = ui.child('waterlevel').value; //0;
    var ambient = ui.child('ambient').value; //0;
    var compensate = ui.child('compensate').checked; //false;
    var invert = ui.child('invert').checked; //false;
    var type= ui.child('type').currentItem; //Image.Linear;
    var tiled = ui.child('tiled').checked; //false;
    img1.bumpmap(map, azmiuth, elevation, depth, xofs, yofs, waterlevel, ambient, compensate, invert, type, tiled);
    var pix = img1.pixmap();
//    var pix = map.pixmap();
//    pix.setMask(mask);
    view.pixmap = pix;
}

    var img1Loc = application.args[0];
    var img2Loc = application.args[1];

    var ui = Factory.loadui('bump.ui');
    var go = ui.child('go');
    var view = ui.child('view');

    go.connect(go, "clicked()", this, "bump");

    ui.show();

    application.exec();
