/***************************************************************************
                           quizwidget.cpp  -  description
                             -------------------
    begin                : Tue Feb 12 2002
    copyright            : (C) 2002 by Scott Wheeler
    email                : wheeler@kde.org
***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
***************************************************************************/

#include <stdlib.h>
#include <time.h>

#include <kmessagebox.h>
#include <kprogress.h>
#include <kstatusbar.h>
#include <klineedit.h>
#include <klocale.h>
#include <kdebug.h>

#include <qlayout.h>
#include <qtimer.h>

#include "quizwidget.h"

////////////////////////////////////////////////////////////////////////////////
// public members
////////////////////////////////////////////////////////////////////////////////

QuizWidget::~QuizWidget()
{
    delete mainStatusBar;
}

void QuizWidget::setCardList(const CardList &list)
{
  completeCardList = list;
  remainingCardList = list;
}

bool QuizWidget::frontBackReversed() const
{
  return reversed;
}

////////////////////////////////////////////////////////////////////////////////
// public slots
////////////////////////////////////////////////////////////////////////////////

Card QuizWidget::nextCard(bool random)
{
  if(!completeCardList.isEmpty()) {
    if(remainingCardList.isEmpty()) {
      KMessageBox::information(this, completeMessage(), i18n("FlashKard"));
      remainingCardList = completeCardList;
    }

    int cardNumber;
    if(random)
      cardNumber = rand() % remainingCardList.count();
    else
      cardNumber = 0;

    currentCard = remainingCardList[cardNumber];
    remainingCardList.remove(remainingCardList.at(cardNumber));

    currentCard.setFrontBackReversed(reversed);

    showCard(currentCard);

    if(completeCardList.count() > 0)
      progressBar->setValue(int(100.0 * (1.0 - float(remainingCardList.count()) / float(completeCardList.count() - 1)) + .5));

    return currentCard;
  }
  else {
    return Card(QString::null, QString::null);
  }
}

void QuizWidget::setFrontBackReversed(bool reverse)
{
  if(reversed != reverse) {
    currentCard.setFrontBackReversed(reverse);
    showCard(currentCard);
  }

  reversed = reverse;
}

void QuizWidget::setShowAnswerLength(int length)
{
  showAnswer = length;
}

////////////////////////////////////////////////////////////////////////////////
// protected members
////////////////////////////////////////////////////////////////////////////////

QuizWidget::QuizWidget(KStatusBar *statusBar, QWidget *parent, const char *name) :
  QWidget(parent, name),
  mainStatusBar(statusBar),
  feedbackLabel(0),
  progressBar(0),
  reversed(false),
  showAnswer(2)
{
  srand(time(0));
  setupLayout();
}

QBoxLayout *QuizWidget::layout() const
{
  return mainLayout;
}

void QuizWidget::setFeedbackMessage(const QString &message)
{
  if(feedbackLabel) {
    feedbackLabel->setText(message);
    QTimer::singleShot( 2 * 1000, feedbackLabel, SLOT(clear())); // clear the label after 2 seconds
  }
}

void QuizWidget::showFeedbackLabel(bool show)
{
  if(feedbackLabel) {
    if(show)
      feedbackLabel->show();
    else
      feedbackLabel->hide();
  }
}

// This should be the same as DataWidget::eventFilter() -- I'm just too lazy at the
// moment to create a base class for QuizWidget and DataWidget that has just this.

bool QuizWidget::eventFilter(QObject *object, QEvent *event)
{
  if(event && event->type() == QEvent::FocusIn) {
    if(dynamic_cast<KLineEdit *>(object))
      emit editWidgetFocusIn();
  }
  if(event && event->type() == QEvent::FocusOut) {
    QFocusEvent *focusEvent = static_cast<QFocusEvent *>(event);
    if(dynamic_cast<KLineEdit *>(object) && focusEvent->reason() != QFocusEvent::Popup)
      emit editWidgetFocusOut();
  }
  return QWidget::eventFilter(object, event);
}

QString QuizWidget::completeMessage() const
{
  return i18n("Restarting the deck.");
}

int QuizWidget::numberOfCards() const
{
  return completeCardList.size();
}

int QuizWidget::showAnswerLength() const
{
  return showAnswer;
}

////////////////////////////////////////////////////////////////////////////////
// private members
////////////////////////////////////////////////////////////////////////////////

void QuizWidget::setupLayout()
{
  // setup statusbar
  if(mainStatusBar) {

    feedbackLabel = new QLabel(mainStatusBar);
    feedbackLabel->setAlignment(AlignHCenter | AlignAuto | AlignVCenter | ExpandTabs);
    feedbackLabel->setFixedWidth(100);
    mainStatusBar->addWidget(feedbackLabel, 1);
    showFeedbackLabel(false);

    progressBar = new KProgress(mainStatusBar);
    progressBar->setMaximumHeight(mainStatusBar->height() - 12);
    mainStatusBar->addWidget(progressBar, 3);
  }

  // main layout
  mainLayout = new QVBoxLayout(this, 3, 2 , "mainLayout");
}

#include "quizwidget.moc"
