/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 1999-2000 by Matthias Kiefer
                            <matthias.kiefer@gmx.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**************************************************************************** */
#include "catalogsettings.h"
#include <kconfig.h>
#include <kdebug.h>
#include <kemailsettings.h>
#include <kglobal.h>
#include <klocale.h>
#include <kprocess.h>
#include <ktempfile.h>

#include <stdlib.h>

#include <qfile.h>
#include <qtextcodec.h>
#include <qregexp.h>

#include <stdlib.h>

using namespace KBabel;

const bool           Defaults::Save::autoUpdate=true;
const bool           Defaults::Save::updateLastTranslator=true;
const bool           Defaults::Save::updateRevisionDate=true;
const bool           Defaults::Save::updateLanguageTeam=true;
const bool           Defaults::Save::updateCharset=true;
const bool           Defaults::Save::updateEncoding=true;
const bool           Defaults::Save::updateProject=true;
const bool           Defaults::Save::updateTranslatorCopyright=true;
const CopyrightUpdate Defaults::Save::FSFCopyright=Update;
const bool           Defaults::Save::updateDescription=true;
const FileEncoding   Defaults::Save::encoding=UTF8;
const bool           Defaults::Save::useOldEncoding=true;
const Qt::DateFormat Defaults::Save::dateFormat=Qt::ISODate;
const bool           Defaults::Save::autoSyntaxCheck=true;
const bool	     Defaults::Save::saveObsolete=false;
const int            Defaults::Save::autoSaveDelay = 0;

const QString Defaults::Save::customDateFormat()
{
    return QString("%Y-%m-%d %H:%M%z");
}

QString KBabel::charsetString(const QTextCodec *codec)
{
    QString encodingStr = "";
    if(codec)
    {
        encodingStr = codec->name();
        encodingStr=encodingStr.upper();
	if( encodingStr.startsWith("CP" ) )
    	    encodingStr.replace(" ","");
	else if( encodingStr == "EUCKR" ) 
	    encodingStr = "EUC-KR";
	else
    	    encodingStr.replace(" ","-");
    }

    return encodingStr;
}

QString KBabel::GNUPluralForms(const QString& lang)
{
    KTempFile infile, outfile;
    
    QTextStream* str = infile.textStream();
    
    *str << "# SOME DESCRIPTIVE TITLE." << endl;
    *str << "# Copyright (C) YEAR Free Software Foundation, Inc." << endl;
    *str << "# FIRST AUTHOR <EMAIL@ADDRESS>, YEAR." << endl;
    *str << "#" << endl;
    *str << "#, fuzzy" << endl;
    *str << "msgid \"\"" << endl;
    *str << "msgstr \"\"" << endl;
    *str << "\"Project-Id-Version: PACKAGE VERSION\\n\"" << endl;
    *str << "\"POT-Creation-Date: 2002-06-25 03:23+0200\\n\"" << endl;
    *str << "\"PO-Revision-Date: YEAR-MO-DA HO:MI+ZONE\\n\"" << endl;
    *str << "\"Last-Translator: FULL NAME <EMAIL@ADDRESS>\\n\"" << endl;
    *str << "\"Language-Team: LANGUAGE <LL@li.org>\\n\"" << endl;
    *str << "\"MIME-Version: 1.0\\n\"" << endl;
    *str << "\"Content-Type: text/plain; charset=CHARSET\\n\"" << endl;
    *str << "\"Content-Transfer-Encoding: ENCODING\\n\"" << endl;
    
    infile.close();

    KProcess msginit;
    
    msginit << "msginit";
    msginit 
	<< "-l" 
	<< lang 
	<< "-i" 
	<< infile.name() 
	<< "-o" 
	<< outfile.name() 
	<< "--no-translator" 
	<< "--no-wrap" ;
    
    msginit.start( KProcess::Block );
    
    QString res("");
    
    if( msginit.normalExit() )
    {
	// parse out the plural form string
	QFile f(outfile.name());
	if( f.open (IO_ReadOnly) )
	{
	    QTextStream str(&f);
	    
	    QString line;
	    do {
		line = str.readLine();
		
		if( line.startsWith( "\"Plural-Forms:" ) )
		{
		    kdDebug() << "Plural form line: " << line << endl;
		    QRegExp re( "^\"Plural-Forms: *(.*)\\\\n\"" );
		    re.search( line );
		    res = re.cap(1);
		    break;
		}
	    } while (!str.atEnd() );	    
	}
	else 
	{
	    kdWarning() << "Cannot open the file with plural form definition" << endl;
	}
    }
    
    infile.unlink();
    outfile.unlink();
    
    return res;
}

QString KBabel::charsetString(FileEncoding e)
{
    QString encodingStr = "";

    switch(e)
    {
        case Locale:
        {
            QTextCodec *codec=QTextCodec::codecForLocale();
            if(codec)
               encodingStr=charsetString(codec);
            else
               encodingStr="unknown";

            break;
        }
        case UTF8:
        {
            encodingStr="UTF-8";
            break;
        }
        case UTF16:
        {
            encodingStr="UTF-16";
            break;
        }
    }

    return encodingStr;
}

const QString Defaults::Save::projectString()
{
    return QString("@PACKAGE@");
}

const QString Defaults::Save::descriptionString()
{
    return QString("translation of @PACKAGE@.po to @LANGUAGE@");
}

Defaults::Identity::Identity(): 
    numberOfPluralForms(2), 
    checkPluralArgument(true),
    gnuPluralFormHeader("")
{
    _authorName=QString::null;
    _authorLocalizedName=QString::null;
    _authorEmail=QString::null;
    _mailingList=QString::null;
    _timezone=QString::null;
    _languageName=QString::null;
    _languageCode=QString::null;
}

QString Defaults::Identity::authorName()
{
   if(_authorName.isNull())
   {
       KEMailSettings emSet;
      _authorName=emSet.getSetting(KEMailSettings::RealName);
   }

   return _authorName;
}

QString Defaults::Identity::authorLocalizedName()
{
    _authorLocalizedName=_authorName;
    return _authorLocalizedName;
}

QString Defaults::Identity::authorEmail()
{
   if(_authorEmail.isNull())
   {
       KEMailSettings emSet;
      _authorEmail=emSet.getSetting(KEMailSettings::EmailAddress);
   }

   return _authorEmail;
}

QString Defaults::Identity::mailingList()
{
   if(_mailingList.isNull())
   {
      QString lang=Defaults::Identity::languageCode();
      int temp=lang.find("_");
      lang=lang.left(temp);
      _mailingList=lang+"@li.org";
   }

   return _mailingList;
}

QString Defaults::Identity::languageName()
{
   if(_languageName.isNull())
   {
      _languageName="";
   }

   return _languageName;
}

QString Defaults::Identity::languageCode()
{   
   if(_languageCode.isNull())
   {     
      // first try to get the language from KDE settings
      KLocale *locale = KGlobal::locale();
      QString lang;
      if(locale)
      {
          lang=locale->languageList().first();
      }

      if(lang.isEmpty())
      {
         lang=getenv("LC_ALL");
         if(lang.isEmpty())
         {
            lang=getenv("LC_MESSAGES");
            if(lang.isEmpty())
            {
               lang=getenv("LANG");
            }
         }
      }

      _languageCode=lang;
   }

   return _languageCode;
}

QString Defaults::Identity::timezone()
{
   if(_timezone.isNull())
   {
     _timezone=getenv("TIMEZONE");
     if(_timezone.isEmpty())
       _timezone="GMT";
   }

   return _timezone;
}


const bool Defaults::Misc::useBzip = true;
const bool Defaults::Misc::compressSingleFile = true;

QChar Defaults::Misc::accelMarker()
{
    return QChar('&');
}

QRegExp Defaults::Misc::contextInfo()
{
    return QRegExp("^_:((?!\\\\n\\n).)+\\\\n\\n");
}

QRegExp Defaults::Misc::singularPlural()
{
    return QRegExp("_n:\\s");
}

QStringList Defaults::Tag::tagExpressions()
{
    QStringList list;

    list.append("</[A-Za-z0-9\\n]+>");
    list.append("<[A-Za-z0-9\\n]+[^>]*/?>");
    list.append("http:\\/\\/[a-zA-Z0-9\\.\\-_/~]+");
    list.append("mailto:[a-z0-9\\.\\-_]+@[a-z0-9\\.\\-_]+");
    list.append("<?[a-z0-9\\.\\-_]+@[a-z0-9\\.\\-_]+>?");
    list.append("&[a-z,A-Z,\\-,0-9,#\\.]*;");

    return list;
}

QStringList Defaults::Tag::argExpressions()
{
    QStringList list;

    list.append("%[ndioxXucsfeEgGp]");
    list.append("%([0-9]+(\\$))?[-+'#0]?[0-9]*(.[0-9]+)?[hlL]?[dioxXucsfeEgGp]");
    list.append("%[0-9]+");

    return list;
}
