
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*  This code generated by:
 *      Author : thomas
 *      Date   : Fri Jul 25 2003
 */

#include "javacodeclassfielddeclarationblock.h"

#include "javacodeclassfield.h"
#include "javaclassifiercodedocument.h"

// Constructors/Destructors
//  

JavaCodeClassFieldDeclarationBlock::JavaCodeClassFieldDeclarationBlock ( CodeClassField * parent ) 
    : CodeClassFieldDeclarationBlock ( parent ) 
{
	setOverallIndentationLevel(1);
	updateContent();
}

JavaCodeClassFieldDeclarationBlock::~JavaCodeClassFieldDeclarationBlock ( ) { }

//  
// Methods
//  



// Other methods
//  

/**
 */
void JavaCodeClassFieldDeclarationBlock::updateContent( ) 
{

	CodeClassField * cf = getParentClassField();
	ClassifierCodeDocument * doc = cf->getParentDocument();
	JavaCodeClassField * jcf = (JavaCodeClassField*) cf;
        JavaClassifierCodeDocument* jdoc = (JavaClassifierCodeDocument*) doc;

        // Set the comment
        QString notes = getParentObject()->getDoc();
        getComment()->setText(notes);

        // Set the body
        QString staticValue = getParentObject()->getStatic() ? "static " : "";
        QString scopeStr = jdoc->scopeToJavaDecl(getParentObject()->getScope());

        QString typeName = jcf->getTypeName();
        QString fieldName = jcf->getFieldName();
        QString initialV = jcf->getInitialValue();

	if (!cf->parentIsAttribute() && !cf->fieldIsSingleValue())
		typeName = "List";

        QString body = staticValue+scopeStr+" "+typeName+" "+fieldName;
        if (!initialV.isEmpty())
                body.append(" = " + initialV);
	else if (!cf->parentIsAttribute())
	{
		// FIX?: IF a constructor method exists in the classifiercodedoc
		// of the parent Object, then we can use that instead (if its empty).
 		if(cf->fieldIsSingleValue())
		{
			if(!typeName.isEmpty())
                		body.append(" = new " + typeName + " ( )");
		} else
                	body.append(" = new Vector ( )");
	}

        setText(body+";");

}



#include "javacodeclassfielddeclarationblock.moc"
