/*
** FAAD2 - Freeware Advanced Audio (AAC) Decoder including SBR decoding
** Copyright (C) 2003-2004 M. Bakker, Ahead Software AG, http://www.nero.com
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
** Any non-GPL usage of this software or parts of this software is strictly
** forbidden.
**
** Commercial non-GPL licensing of this software is possible.
** For more info contact Ahead Software through Mpeg4AAClicense@nero.com.
**
** $Id: sbr_dct.c,v 1.3 2004/01/26 22:34:11 jstembridge Exp $
**/

#include "common.h"

#ifdef SBR_DEC

#ifdef _MSC_VER
#pragma warning(disable:4305)
#pragma warning(disable:4244)
#endif


#include "sbr_dct.h"

#ifdef SBR_LOW_POWER

void DCT3_32_unscaled(real_t *y, real_t *x)
{
    real_t f0, f1, f2, f3, f4, f5, f6, f7, f8, f9, f10;
    real_t f11, f12, f13, f14, f15, f16, f17, f18, f19, f20;
    real_t f21, f22, f23, f24, f25, f26, f27, f28, f29, f30;
    real_t f31, f32, f33, f34, f35, f36, f37, f38, f39, f40;
    real_t f41, f42, f43, f44, f45, f46, f47, f48, f49, f50;
    real_t f51, f52, f53, f54, f55, f56, f57, f58, f59, f60;
    real_t f61, f62, f63, f64, f65, f66, f67, f68, f69, f70;
    real_t f71, f72, f73, f74, f75, f76, f77, f78, f79, f80;
    real_t f81, f82, f83, f84, f85, f86, f87, f88, f89, f90;
    real_t f91, f92, f93, f94, f95, f96, f97, f98, f99, f100;
    real_t f101, f102, f103, f104, f105, f106, f107, f108, f109, f110;
    real_t f111, f112, f113, f114, f115, f116, f117, f118, f119, f120;
    real_t f121, f122, f123, f124, f125, f126, f127, f128, f129, f130;
    real_t f131, f132, f133, f134, f135, f136, f137, f138, f139, f140;
    real_t f141, f142, f143, f144, f145, f146, f147, f148, f149, f150;
    real_t f151, f152, f153, f154, f155, f156, f157, f158, f159, f160;
    real_t f161, f162, f163, f164, f165, f166, f167, f168, f169, f170;
    real_t f171, f172, f173, f174, f175, f176, f177, f178, f179, f180;
    real_t f181, f182, f183, f184, f185, f186, f187, f188, f189, f190;
    real_t f191, f192, f193, f194, f195, f196, f197, f198, f199, f200;
    real_t f201, f202, f203, f204, f205, f206, f207, f208, f209, f210;
    real_t f211, f212, f213, f214, f215, f216, f217, f218, f219, f220;
    real_t f221, f222, f223, f224, f225, f226, f227, f228, f229, f230;
    real_t f231, f232, f233, f234, f235, f236, f237, f238, f239, f240;
    real_t f241, f242, f243, f244, f245, f246, f247, f248, f249, f250;
    real_t f251, f252, f253, f254, f255, f256, f257, f258, f259, f260;
    real_t f261, f262, f263, f264, f265, f266, f267, f268, f269, f270;
    real_t f271, f272;

    f0 = MUL_C(COEF_CONST(0.7071067811865476), x[16]);
    f1 = x[0] - f0;
    f2 = x[0] + f0;
    f3 = x[8] + x[24];
    f4 = MUL_C(COEF_CONST(1.3065629648763766), x[8]);
    f5 = MUL_C(COEF_CONST((-0.9238795325112866)), f3);
    f6 = MUL_C(COEF_CONST((-0.5411961001461967)), x[24]);
    f7 = f4 + f5;
    f8 = f6 - f5;
    f9 = f2 - f8;
    f10 = f2 + f8;
    f11 = f1 - f7;
    f12 = f1 + f7;
    f13 = x[4] + x[28];
    f14 = MUL_C(COEF_CONST(1.1758756024193588), x[4]);
    f15 = MUL_C(COEF_CONST((-0.9807852804032304)), f13);
    f16 = MUL_C(COEF_CONST((-0.7856949583871021)), x[28]);
    f17 = f14 + f15;
    f18 = f16 - f15;
    f19 = x[12] + x[20];
    f20 = MUL_C(COEF_CONST(1.3870398453221473), x[12]);
    f21 = MUL_C(COEF_CONST((-0.8314696123025455)), f19);
    f22 = MUL_C(COEF_CONST((-0.2758993792829436)), x[20]);
    f23 = f20 + f21;
    f24 = f22 - f21;
    f25 = f18 - f24;
    f26 = f18 + f24;
    f27 = MUL_C(COEF_CONST(0.7071067811865476), f25);
    f28 = f17 - f23;
    f29 = f17 + f23;
    f30 = MUL_C(COEF_CONST(0.7071067811865476), f29);
    f31 = f27 - f30;
    f32 = f27 + f30;
    f33 = f10 - f26;
    f34 = f10 + f26;
    f35 = f12 - f32;
    f36 = f12 + f32;
    f37 = f11 - f31;
    f38 = f11 + f31;
    f39 = f9 - f28;
    f40 = f9 + f28;
    f41 = x[2] + x[30];
    f42 = MUL_C(COEF_CONST(1.0932018670017569), x[2]);
    f43 = MUL_C(COEF_CONST((-0.9951847266721969)), f41);
    f44 = MUL_C(COEF_CONST((-0.8971675863426368)), x[30]);
    f45 = f42 + f43;
    f46 = f44 - f43;
    f47 = x[6] + x[26];
    f48 = MUL_C(COEF_CONST(1.2472250129866711), x[6]);
    f49 = MUL_C(COEF_CONST((-0.9569403357322089)), f47);
    f50 = MUL_C(COEF_CONST((-0.6666556584777469)), x[26]);
    f51 = f48 + f49;
    f52 = f50 - f49;
    f53 = x[10] + x[22];
    f54 = MUL_C(COEF_CONST(1.3533180011743526), x[10]);
    f55 = MUL_C(COEF_CONST((-0.8819212643483551)), f53);
    f56 = MUL_C(COEF_CONST((-0.4105245275223575)), x[22]);
    f57 = f54 + f55;
    f58 = f56 - f55;
    f59 = x[14] + x[18];
    f60 = MUL_C(COEF_CONST(1.4074037375263826), x[14]);
    f61 = MUL_C(COEF_CONST((-0.7730104533627369)), f59);
    f62 = MUL_C(COEF_CONST((-0.1386171691990913)), x[18]);
    f63 = f60 + f61;
    f64 = f62 - f61;
    f65 = f46 - f64;
    f66 = f46 + f64;
    f67 = f52 - f58;
    f68 = f52 + f58;
    f69 = f66 - f68;
    f70 = f66 + f68;
    f71 = MUL_C(COEF_CONST(0.7071067811865476), f69);
    f72 = f65 + f67;
    f73 = MUL_C(COEF_CONST(1.3065629648763766), f65);
    f74 = MUL_C(COEF_CONST((-0.9238795325112866)), f72);
    f75 = MUL_C(COEF_CONST((-0.5411961001461967)), f67);
    f76 = f73 + f74;
    f77 = f75 - f74;
    f78 = f45 - f63;
    f79 = f45 + f63;
    f80 = f51 - f57;
    f81 = f51 + f57;
    f82 = f79 + f81;
    f83 = MUL_C(COEF_CONST(1.3065629648763770), f79);
    f84 = MUL_C(COEF_CONST((-0.3826834323650904)), f82);
    f85 = MUL_C(COEF_CONST(0.5411961001461961), f81);
    f86 = f83 + f84;
    f87 = f85 - f84;
    f88 = f78 - f80;
    f89 = f78 + f80;
    f90 = MUL_C(COEF_CONST(0.7071067811865476), f89);
    f91 = f77 - f87;
    f92 = f77 + f87;
    f93 = f71 - f90;
    f94 = f71 + f90;
    f95 = f76 - f86;
    f96 = f76 + f86;
    f97 = f34 - f70;
    f98 = f34 + f70;
    f99 = f36 - f92;
    f100 = f36 + f92;
    f101 = f38 - f91;
    f102 = f38 + f91;
    f103 = f40 - f94;
    f104 = f40 + f94;
    f105 = f39 - f93;
    f106 = f39 + f93;
    f107 = f37 - f96;
    f108 = f37 + f96;
    f109 = f35 - f95;
    f110 = f35 + f95;
    f111 = f33 - f88;
    f112 = f33 + f88;
    f113 = x[1] + x[31];
    f114 = MUL_C(COEF_CONST(1.0478631305325901), x[1]);
    f115 = MUL_C(COEF_CONST((-0.9987954562051724)), f113);
    f116 = MUL_C(COEF_CONST((-0.9497277818777548)), x[31]);
    f117 = f114 + f115;
    f118 = f116 - f115;
    f119 = x[5] + x[27];
    f120 = MUL_C(COEF_CONST(1.2130114330978077), x[5]);
    f121 = MUL_C(COEF_CONST((-0.9700312531945440)), f119);
    f122 = MUL_C(COEF_CONST((-0.7270510732912803)), x[27]);
    f123 = f120 + f121;
    f124 = f122 - f121;
    f125 = x[9] + x[23];
    f126 = MUL_C(COEF_CONST(1.3315443865537255), x[9]);
    f127 = MUL_C(COEF_CONST((-0.9039892931234433)), f125);
    f128 = MUL_C(COEF_CONST((-0.4764341996931612)), x[23]);
    f129 = f126 + f127;
    f130 = f128 - f127;
    f131 = x[13] + x[19];
    f132 = MUL_C(COEF_CONST(1.3989068359730781), x[13]);
    f133 = MUL_C(COEF_CONST((-0.8032075314806453)), f131);
    f134 = MUL_C(COEF_CONST((-0.2075082269882124)), x[19]);
    f135 = f132 + f133;
    f136 = f134 - f133;
    f137 = x[17] + x[15];
    f138 = MUL_C(COEF_CONST(1.4125100802019777), x[17]);
    f139 = MUL_C(COEF_CONST((-0.6715589548470187)), f137);
    f140 = MUL_C(COEF_CONST(0.0693921705079402), x[15]);
    f141 = f138 + f139;
    f142 = f140 - f139;
    f143 = x[21] + x[11];
    f144 = MUL_C(COEF_CONST(1.3718313541934939), x[21]);
    f145 = MUL_C(COEF_CONST((-0.5141027441932219)), f143);
    f146 = MUL_C(COEF_CONST(0.3436258658070501), x[11]);
    f147 = f144 + f145;
    f148 = f146 - f145;
    f149 = x[25] + x[7];
    f150 = MUL_C(COEF_CONST(1.2784339185752409), x[25]);
    f151 = MUL_C(COEF_CONST((-0.3368898533922200)), f149);
    f152 = MUL_C(COEF_CONST(0.6046542117908008), x[7]);
    f153 = f150 + f151;
    f154 = f152 - f151;
    f155 = x[29] + x[3];
    f156 = MUL_C(COEF_CONST(1.1359069844201433), x[29]);
    f157 = MUL_C(COEF_CONST((-0.1467304744553624)), f155);
    f158 = MUL_C(COEF_CONST(0.8424460355094185), x[3]);
    f159 = f156 + f157;
    f160 = f158 - f157;
    f161 = f118 - f142;
    f162 = f118 + f142;
    f163 = f117 - f141;
    f164 = f117 + f141;
    f165 = f124 - f148;
    f166 = f124 + f148;
    f167 = f123 - f147;
    f168 = f123 + f147;
    f169 = f130 - f154;
    f170 = f130 + f154;
    f171 = f129 - f153;
    f172 = f129 + f153;
    f173 = f136 - f160;
    f174 = f136 + f160;
    f175 = f135 - f159;
    f176 = f135 + f159;
    f177 = f161 + f163;
    f178 = MUL_C(COEF_CONST(1.1758756024193588), f161);
    f179 = MUL_C(COEF_CONST((-0.9807852804032304)), f177);
    f180 = MUL_C(COEF_CONST((-0.7856949583871021)), f163);
    f181 = f178 + f179;
    f182 = f180 - f179;
    f183 = f165 + f167;
    f184 = MUL_C(COEF_CONST(1.3870398453221475), f165);
    f185 = MUL_C(COEF_CONST((-0.5555702330196022)), f183);
    f186 = MUL_C(COEF_CONST(0.2758993792829431), f167);
    f187 = f184 + f185;
    f188 = f186 - f185;
    f189 = f169 + f171;
    f190 = MUL_C(COEF_CONST(0.7856949583871022), f169);
    f191 = MUL_C(COEF_CONST(0.1950903220161283), f189);
    f192 = MUL_C(COEF_CONST(1.1758756024193586), f171);
    f193 = f190 + f191;
    f194 = f192 - f191;
    f195 = f173 + f175;
    f196 = MUL_C(COEF_CONST((-0.2758993792829430)), f173);
    f197 = MUL_C(COEF_CONST(0.8314696123025452), f195);
    f198 = MUL_C(COEF_CONST(1.3870398453221475), f175);
    f199 = f196 + f197;
    f200 = f198 - f197;
    f201 = f162 - f170;
    f202 = f162 + f170;
    f203 = f164 - f172;
    f204 = f164 + f172;
    f205 = f166 - f174;
    f206 = f166 + f174;
    f207 = f168 - f176;
    f208 = f168 + f176;
    f209 = f182 - f194;
    f210 = f182 + f194;
    f211 = f181 - f193;
    f212 = f181 + f193;
    f213 = f188 - f200;
    f214 = f188 + f200;
    f215 = f187 - f199;
    f216 = f187 + f199;
    f217 = f201 + f203;
    f218 = MUL_C(COEF_CONST(1.3065629648763766), f201);
    f219 = MUL_C(COEF_CONST((-0.9238795325112866)), f217);
    f220 = MUL_C(COEF_CONST((-0.5411961001461967)), f203);
    f221 = f218 + f219;
    f222 = f220 - f219;
    f223 = f205 + f207;
    f224 = MUL_C(COEF_CONST(0.5411961001461969), f205);
    f225 = MUL_C(COEF_CONST(0.3826834323650898), f223);
    f226 = MUL_C(COEF_CONST(1.3065629648763766), f207);
    f227 = f224 + f225;
    f228 = f226 - f225;
    f229 = f209 + f211;
    f230 = MUL_C(COEF_CONST(1.3065629648763766), f209);
    f231 = MUL_C(COEF_CONST((-0.9238795325112866)), f229);
    f232 = MUL_C(COEF_CONST((-0.5411961001461967)), f211);
    f233 = f230 + f231;
    f234 = f232 - f231;
    f235 = f213 + f215;
    f236 = MUL_C(COEF_CONST(0.5411961001461969), f213);
    f237 = MUL_C(COEF_CONST(0.3826834323650898), f235);
    f238 = MUL_C(COEF_CONST(1.3065629648763766), f215);
    f239 = f236 + f237;
    f240 = f238 - f237;
    f241 = f202 - f206;
    f242 = f202 + f206;
    f243 = f204 - f208;
    f244 = f204 + f208;
    f245 = f222 - f228;
    f246 = f222 + f228;
    f247 = f221 - f227;
    f248 = f221 + f227;
    f249 = f210 - f214;
    f250 = f210 + f214;
    f251 = f212 - f216;
    f252 = f212 + f216;
    f253 = f234 - f240;
    f254 = f234 + f240;
    f255 = f233 - f239;
    f256 = f233 + f239;
    f257 = f241 - f243;
    f258 = f241 + f243;
    f259 = MUL_C(COEF_CONST(0.7071067811865474), f257);
    f260 = MUL_C(COEF_CONST(0.7071067811865474), f258);
    f261 = f245 - f247;
    f262 = f245 + f247;
    f263 = MUL_C(COEF_CONST(0.7071067811865474), f261);
    f264 = MUL_C(COEF_CONST(0.7071067811865474), f262);
    f265 = f249 - f251;
    f266 = f249 + f251;
    f267 = MUL_C(COEF_CONST(0.7071067811865474), f265);
    f268 = MUL_C(COEF_CONST(0.7071067811865474), f266);
    f269 = f253 - f255;
    f270 = f253 + f255;
    f271 = MUL_C(COEF_CONST(0.7071067811865474), f269);
    f272 = MUL_C(COEF_CONST(0.7071067811865474), f270);
    y[31] = f98 - f242;
    y[0] = f98 + f242;
    y[30] = f100 - f250;
    y[1] = f100 + f250;
    y[29] = f102 - f254;
    y[2] = f102 + f254;
    y[28] = f104 - f246;
    y[3] = f104 + f246;
    y[27] = f106 - f264;
    y[4] = f106 + f264;
    y[26] = f108 - f272;
    y[5] = f108 + f272;
    y[25] = f110 - f268;
    y[6] = f110 + f268;
    y[24] = f112 - f260;
    y[7] = f112 + f260;
    y[23] = f111 - f259;
    y[8] = f111 + f259;
    y[22] = f109 - f267;
    y[9] = f109 + f267;
    y[21] = f107 - f271;
    y[10] = f107 + f271;
    y[20] = f105 - f263;
    y[11] = f105 + f263;
    y[19] = f103 - f248;
    y[12] = f103 + f248;
    y[18] = f101 - f256;
    y[13] = f101 + f256;
    y[17] = f99 - f252;
    y[14] = f99 + f252;
    y[16] = f97 - f244;
    y[15] = f97 + f244;
}

void DCT2_64_unscaled(real_t *y, real_t *x)
{
    int16_t i0;
    real_t f2, f3, f4, f5, f6, f7, f8, f9, f10;
    real_t f11, f12, f13, f14, f15, f16, f17, f18, f19, f20;
    real_t f21, f22, f23, f24, f25, f26, f27, f28, f29, f30;
    real_t f31, f32, f33, f34, f35, f36, f37, f38, f39, f40;
    real_t f41, f42, f43, f44, f45, f46, f47, f48, f49, f50;
    real_t f51, f52, f53, f54, f55, f56, f57, f58, f59, f60;
    real_t f61, f62, f65, f66, f67, f68, f71, f72, f73, f74;
    real_t f75, f76, f77, f78, f79, f80, f81, f82, f83, f85;
    real_t f87, f88, f91, f92, f93, f94, f95, f96, f97, f98;
    real_t f99, f100, f101, f102, f103, f104, f105, f106, f107, f108;
    real_t f109, f110, f111, f112, f113, f114, f115, f116, f117, f118;
    real_t f119, f120, f121, f122, f123, f124, f125, f126, f129, f130;
    real_t f131, f132, f135, f136, f137, f138, f141, f142, f143, f144;
    real_t f147, f148, f149, f150, f151, f152, f153, f154, f155, f156;
    real_t f157, f158, f159, f160, f161, f162, f163, f164, f165, f166;
    real_t f167, f168, f169, f170, f171, f172, f173, f174, f175, f176;
    real_t f177, f178, f179, f180, f181, f182, f183, f184, f185, f186;
    real_t f187, f188, f189, f190, f191, f192, f193, f194, f195, f196;
    real_t f197, f198, f199, f200, f201, f202, f203, f204, f205, f206;
    real_t f207, f208, f209, f210, f211, f212, f213, f214, f215, f216;
    real_t f217, f218, f219, f220, f221, f222, f223, f224, f225, f226;
    real_t f227, f228, f229, f230, f231, f232, f233, f234, f235, f236;
    real_t f237, f238, f239, f240, f241, f242, f243, f244, f245, f246;
    real_t f247, f248, f249, f250, f251, f252, f253, f254, f255, f256;
    real_t f257, f258, f259, f260, f261, f262, f265, f266, f267, f268;
    real_t f271, f272, f273, f274, f277, f278, f279, f280, f283, f284;
    real_t f285, f286, f289, f290, f291, f292, f295, f296, f297, f298;
    real_t f301, f302, f303, f304, f307, f308, f309, f310, f311, f312;
    real_t f313, f314, f315, f316, f317, f318, f319, f320, f321, f322;
    real_t f323, f324, f325, f326, f327, f328, f329, f330, f331, f332;
    real_t f333, f334, f335, f336, f337, f338, f339, f340, f341, f342;
    real_t f343, f344, f345, f346, f347, f348, f349, f350, f351, f352;
    real_t f353, f354, f355, f356, f357, f358, f359, f360, f361, f362;
    real_t f363, f364, f365, f366, f367, f368, f369, f370, f371, f372;
    real_t f373, f374, f375, f376, f377, f378, f379, f380, f381, f382;
    real_t f383, f384, f385, f386, f387, f388, f389, f390, f391, f392;
    real_t f393, f394, f395, f396, f397, f398, f399, f400, f401, f402;
    real_t f403, f404, f405, f406, f407, f408, f409, f410, f411, f412;
    real_t f413, f414, f415, f416, f417, f418, f419, f420, f421, f422;
    real_t f423, f424, f425, f426, f427, f428, f429, f430, f431, f433;
    real_t f434, f435, f436, f437, f438, f439, f440, f441, f442, f443;
    real_t f444, f445, f446, f447, f448, f449, f450, f451, f452, f453;
    real_t f454, f455, f456, f457, f458, f459, f460, f461, f462, f463;
    real_t f464, f465, f466, f467, f468, f469, f470, f471, f472, f473;
    real_t f474, f475, f476, f477, f478, f479, f480, f481, f482, f483;
    real_t f484, f485, f486, f487, f488, f489, f490, f491, f492, f493;
    real_t f494, f495, f496, f497, f498, f499, f500, f501, f502, f503;
    real_t f504, f505, f506, f507, f508, f509, f510, f511, f512, f513;
    real_t f514, f515, f516, f517, f518, f519, f520, f521, f522, f523;
    real_t f524, f525, f526, f527, f528, f529, f530, f531, f532, f533;
    real_t f534, f535, f536, f537, f538, f539, f540, f541, f542, f543;
    real_t f544, f546, f547, f548, f549, f550, f551, f552, f553, f554;
    real_t f555, f556, f557, f558, f559, f560, f561, f562, f563, f564;
    real_t f565, f566, f567, f568, f569, f570, f571, f572, f573, f574;
    real_t f575, f576, f577, f578, f579, f580, f581, f582, f583, f584;
    real_t f585, f586, f587, f588, f589, f590, f591, f592, f593, f594;
    real_t f595, f596, f597, f598, f599, f600, f601, f602, f603, f604;
    real_t f605, f606, f607, f608, f609, f610, f611, f612, f613, f614;
    real_t f615, f616, f617, f618, f619, f620, f621, f622, f623, f624;
    real_t f625, f626, f627, f628;
    ALIGN static real_t t2[64];

    for (i0=0; i0<32; i0++)
    {
        t2[2*i0+1] = x[i0] - x[-i0+63];
        t2[2*i0] = x[i0] + x[-i0+63];
    }
    f2 = t2[0] - t2[62];
    f3 = t2[0] + t2[62];
    f4 = t2[2] - t2[60];
    f5 = t2[2] + t2[60];
    f6 = t2[4] - t2[58];
    f7 = t2[4] + t2[58];
    f8 = t2[6] - t2[56];
    f9 = t2[6] + t2[56];
    f10 = t2[8] - t2[54];
    f11 = t2[8] + t2[54];
    f12 = t2[10] - t2[52];
    f13 = t2[10] + t2[52];
    f14 = t2[12] - t2[50];
    f15 = t2[12] + t2[50];
    f16 = t2[14] - t2[48];
    f17 = t2[14] + t2[48];
    f18 = t2[16] - t2[46];
    f19 = t2[16] + t2[46];
    f20 = t2[18] - t2[44];
    f21 = t2[18] + t2[44];
    f22 = t2[20] - t2[42];
    f23 = t2[20] + t2[42];
    f24 = t2[22] - t2[40];
    f25 = t2[22] + t2[40];
    f26 = t2[24] - t2[38];
    f27 = t2[24] + t2[38];
    f28 = t2[26] - t2[36];
    f29 = t2[26] + t2[36];
    f30 = t2[28] - t2[34];
    f31 = t2[28] + t2[34];
    f32 = t2[30] - t2[32];
    f33 = t2[30] + t2[32];
    f34 = f3 - f33;
    f35 = f3 + f33;
    f36 = f5 - f31;
    f37 = f5 + f31;
    f38 = f7 - f29;
    f39 = f7 + f29;
    f40 = f9 - f27;
    f41 = f9 + f27;
    f42 = f11 - f25;
    f43 = f11 + f25;
    f44 = f13 - f23;
    f45 = f13 + f23;
    f46 = f15 - f21;
    f47 = f15 + f21;
    f48 = f17 - f19;
    f49 = f17 + f19;
    f50 = f35 - f49;
    f51 = f35 + f49;
    f52 = f37 - f47;
    f53 = f37 + f47;
    f54 = f39 - f45;
    f55 = f39 + f45;
    f56 = f41 - f43;
    f57 = f41 + f43;
    f58 = f51 - f57;
    f59 = f51 + f57;
    f60 = f53 - f55;
    f61 = f53 + f55;
    f62 = f59 - f61;
    y[0] = f59 + f61;
    y[32] = MUL_C(COEF_CONST(0.7071067811865476), f62);
    f65 = f58 + f60;
    f66 = MUL_C(COEF_CONST(1.3065629648763766), f58);
    f67 = MUL_C(COEF_CONST((-0.9238795325112866)), f65);
    f68 = MUL_C(COEF_CONST((-0.5411961001461967)), f60);
    y[48] = f66 + f67;
    y[16] = f68 - f67;
    f71 = f50 + f56;
    f72 = MUL_C(COEF_CONST(1.1758756024193588), f50);
    f73 = MUL_C(COEF_CONST((-0.9807852804032304)), f71);
    f74 = MUL_C(COEF_CONST((-0.7856949583871021)), f56);
    f75 = f72 + f73;
    f76 = f74 - f73;
    f77 = f52 + f54;
    f78 = MUL_C(COEF_CONST(1.3870398453221473), f52);
    f79 = MUL_C(COEF_CONST((-0.8314696123025455)), f77);
    f80 = MUL_C(COEF_CONST((-0.2758993792829436)), f54);
    f81 = f78 + f79;
    f82 = f80 - f79;
    f83 = f76 - f82;
    y[8] = f76 + f82;
    f85 = MUL_C(COEF_CONST(0.7071067811865476), f83);
    y[56] = f75 - f81;
    f87 = f75 + f81;
    f88 = MUL_C(COEF_CONST(0.7071067811865476), f87);
    y[40] = f85 - f88;
    y[24] = f85 + f88;
    f91 = f36 - f38;
    f92 = f36 + f38;
    f93 = f40 - f42;
    f94 = f40 + f42;
    f95 = f44 - f46;
    f96 = f44 + f46;
    f97 = MUL_C(COEF_CONST(0.7071067811865476), f94);
    f98 = f34 - f97;
    f99 = f34 + f97;
    f100 = f92 + f96;
    f101 = MUL_C(COEF_CONST(1.3065629648763766), f92);
    f102 = MUL_C(COEF_CONST((-0.9238795325112866)), f100);
    f103 = MUL_C(COEF_CONST((-0.5411961001461967)), f96);
    f104 = f101 + f102;
    f105 = f103 - f102;
    f106 = f99 - f105;
    f107 = f99 + f105;
    f108 = f98 - f104;
    f109 = f98 + f104;
    f110 = f91 + f95;
    f111 = MUL_C(COEF_CONST(1.3065629648763770), f91);
    f112 = MUL_C(COEF_CONST((-0.3826834323650904)), f110);
    f113 = MUL_C(COEF_CONST(0.5411961001461961), f95);
    f114 = f111 + f112;
    f115 = f113 - f112;
    f116 = MUL_C(COEF_CONST(0.7071067811865476), f93);
    f117 = f116 - f48;
    f118 = f116 + f48;
    f119 = f115 - f118;
    f120 = f115 + f118;
    f121 = f114 - f117;
    f122 = f114 + f117;
    f123 = f120 + f107;
    f124 = MUL_C(COEF_CONST((-0.8971675863426361)), f120);
    f125 = MUL_C(COEF_CONST(0.9951847266721968), f123);
    f126 = MUL_C(COEF_CONST(1.0932018670017576), f107);
    y[4] = f124 + f125;
    y[60] = f126 - f125;
    f129 = f122 + f109;
    f130 = MUL_C(COEF_CONST((-0.6666556584777466)), f122);
    f131 = MUL_C(COEF_CONST(0.9569403357322089), f129);
    f132 = MUL_C(COEF_CONST(1.2472250129866713), f109);
    y[12] = f130 + f131;
    y[52] = f132 - f131;
    f135 = f121 + f108;
    f136 = MUL_C(COEF_CONST((-0.4105245275223571)), f121);
    f137 = MUL_C(COEF_CONST(0.8819212643483549), f135);
    f138 = MUL_C(COEF_CONST(1.3533180011743529), f108);
    y[20] = f136 + f137;
    y[44] = f138 - f137;
    f141 = f119 + f106;
    f142 = MUL_C(COEF_CONST((-0.1386171691990915)), f119);
    f143 = MUL_C(COEF_CONST(0.7730104533627370), f141);
    f144 = MUL_C(COEF_CONST(1.4074037375263826), f106);
    y[28] = f142 + f143;
    y[36] = f144 - f143;
    f147 = f16 - f18;
    f148 = f16 + f18;
    f149 = MUL_C(COEF_CONST(0.7071067811865476), f148);
    f150 = MUL_C(COEF_CONST(0.7071067811865476), f147);
    f151 = f10 - f24;
    f152 = f10 + f24;
    f153 = MUL_C(COEF_CONST(0.7071067811865476), f152);
    f154 = MUL_C(COEF_CONST(0.7071067811865476), f151);
    f155 = f14 - f20;
    f156 = f14 + f20;
    f157 = MUL_C(COEF_CONST(0.7071067811865476), f156);
    f158 = MUL_C(COEF_CONST(0.7071067811865476), f155);
    f159 = f12 - f22;
    f160 = f12 + f22;
    f161 = MUL_C(COEF_CONST(0.7071067811865476), f160);
    f162 = MUL_C(COEF_CONST(0.7071067811865476), f159);
    f163 = f2 - f149;
    f164 = f2 + f149;
    f165 = f32 - f150;
    f166 = f32 + f150;
    f167 = f8 - f153;
    f168 = f8 + f153;
    f169 = f26 - f154;
    f170 = f26 + f154;
    f171 = f4 - f157;
    f172 = f4 + f157;
    f173 = f30 - f158;
    f174 = f30 + f158;
    f175 = f6 - f161;
    f176 = f6 + f161;
    f177 = f28 - f162;
    f178 = f28 + f162;
    f179 = f170 + f168;
    f180 = MUL_C(COEF_CONST((-0.5411961001461969)), f170);
    f181 = MUL_C(COEF_CONST(0.9238795325112867), f179);
    f182 = MUL_C(COEF_CONST(1.3065629648763766), f168);
    f183 = f180 + f181;
    f184 = f182 - f181;
    f185 = f169 + f167;
    f186 = MUL_C(COEF_CONST(1.3065629648763770), f169);
    f187 = MUL_C(COEF_CONST((-0.3826834323650904)), f185);
    f188 = MUL_C(COEF_CONST(0.5411961001461961), f167);
    f189 = f186 + f187;
    f190 = f188 - f187;
    f191 = f178 + f176;
    f192 = MUL_C(COEF_CONST((-0.5411961001461969)), f178);
    f193 = MUL_C(COEF_CONST(0.9238795325112867), f191);
    f194 = MUL_C(COEF_CONST(1.3065629648763766), f176);
    f195 = f192 + f193;
    f196 = f194 - f193;
    f197 = f177 + f175;
    f198 = MUL_C(COEF_CONST(1.3065629648763770), f177);
    f199 = MUL_C(COEF_CONST((-0.3826834323650904)), f197);
    f200 = MUL_C(COEF_CONST(0.5411961001461961), f175);
    f201 = f198 + f199;
    f202 = f200 - f199;
    f203 = f164 - f183;
    f204 = f164 + f183;
    f205 = f166 - f184;
    f206 = f166 + f184;
    f207 = f163 - f189;
    f208 = f163 + f189;
    f209 = f165 - f190;
    f210 = f165 + f190;
    f211 = f172 - f195;
    f212 = f172 + f195;
    f213 = f174 - f196;
    f214 = f174 + f196;
    f215 = f171 - f201;
    f216 = f171 + f201;
    f217 = f173 - f202;
    f218 = f173 + f202;
    f219 = f214 + f212;
    f220 = MUL_C(COEF_CONST((-0.7856949583871021)), f214);
    f221 = MUL_C(COEF_CONST(0.9807852804032304), f219);
    f222 = MUL_C(COEF_CONST(1.1758756024193588), f212);
    f223 = f220 + f221;
    f224 = f222 - f221;
    f225 = f218 + f216;
    f226 = MUL_C(COEF_CONST(0.2758993792829431), f218);
    f227 = MUL_C(COEF_CONST(0.5555702330196022), f225);
    f228 = MUL_C(COEF_CONST(1.3870398453221475), f216);
    f229 = f226 + f227;
    f230 = f228 - f227;
    f231 = f213 + f211;
    f232 = MUL_C(COEF_CONST(1.1758756024193591), f213);
    f233 = MUL_C(COEF_CONST((-0.1950903220161287)), f231);
    f234 = MUL_C(COEF_CONST(0.7856949583871016), f211);
    f235 = f232 + f233;
    f236 = f234 - f233;
    f237 = f217 + f215;
    f238 = MUL_C(COEF_CONST(1.3870398453221473), f217);
    f239 = MUL_C(COEF_CONST((-0.8314696123025455)), f237);
    f240 = MUL_C(COEF_CONST((-0.2758993792829436)), f215);
    f241 = f238 + f239;
    f242 = f240 - f239;
    f243 = f204 - f223;
    f244 = f204 + f223;
    f245 = f206 - f224;
    f246 = f206 + f224;
    f247 = f208 - f229;
    f248 = f208 + f229;
    f249 = f210 - f230;
    f250 = f210 + f230;
    f251 = f203 - f235;
    f252 = f203 + f235;
    f253 = f205 - f236;
    f254 = f205 + f236;
    f255 = f207 - f241;
    f256 = f207 + f241;
    f257 = f209 - f242;
    f258 = f209 + f242;
    f259 = f246 + f244;
    f260 = MUL_C(COEF_CONST((-0.9497277818777543)), f246);
    f261 = MUL_C(COEF_CONST(0.9987954562051724), f259);
    f262 = MUL_C(COEF_CONST(1.0478631305325905), f244);
    y[2] = f260 + f261;
    y[62] = f262 - f261;
    f265 = f250 + f248;
    f266 = MUL_C(COEF_CONST((-0.7270510732912801)), f250);
    f267 = MUL_C(COEF_CONST(0.9700312531945440), f265);
    f268 = MUL_C(COEF_CONST(1.2130114330978079), f248);
    y[10] = f266 + f267;
    y[54] = f268 - f267;
    f271 = f254 + f252;
    f272 = MUL_C(COEF_CONST((-0.4764341996931611)), f254);
    f273 = MUL_C(COEF_CONST(0.9039892931234433), f271);
    f274 = MUL_C(COEF_CONST(1.3315443865537255), f252);
    y[18] = f272 + f273;
    y[46] = f274 - f273;
    f277 = f258 + f256;
    f278 = MUL_C(COEF_CONST((-0.2075082269882114)), f258);
    f279 = MUL_C(COEF_CONST(0.8032075314806448), f277);
    f280 = MUL_C(COEF_CONST(1.3989068359730783), f256);
    y[26] = f278 + f279;
    y[38] = f280 - f279;
    f283 = f245 + f243;
    f284 = MUL_C(COEF_CONST(0.0693921705079408), f245);
    f285 = MUL_C(COEF_CONST(0.6715589548470183), f283);
    f286 = MUL_C(COEF_CONST(1.4125100802019774), f243);
    y[34] = f284 + f285;
    y[30] = f286 - f285;
    f289 = f249 + f247;
    f290 = MUL_C(COEF_CONST(0.3436258658070505), f249);
    f291 = MUL_C(COEF_CONST(0.5141027441932217), f289);
    f292 = MUL_C(COEF_CONST(1.3718313541934939), f247);
    y[42] = f290 + f291;
    y[22] = f292 - f291;
    f295 = f253 + f251;
    f296 = MUL_C(COEF_CONST(0.6046542117908007), f253);
    f297 = MUL_C(COEF_CONST(0.3368898533922201), f295);
    f298 = MUL_C(COEF_CONST(1.2784339185752409), f251);
    y[50] = f296 + f297;
    y[14] = f298 - f297;
    f301 = f257 + f255;
    f302 = MUL_C(COEF_CONST(0.8424460355094192), f257);
    f303 = MUL_C(COEF_CONST(0.1467304744553618), f301);
    f304 = MUL_C(COEF_CONST(1.1359069844201428), f255);
    y[58] = f302 + f303;
    y[6] = f304 - f303;
    f307 = t2[1] + t2[63];
    f308 = MUL_C(COEF_CONST(1.0242400472191162), t2[1]);
    f309 = MUL_C(COEF_CONST((-0.9996988186962043)), f307);
    f310 = MUL_C(COEF_CONST((-0.9751575901732922)), t2[63]);
    f311 = f308 + f309;
    f312 = f310 - f309;
    f313 = t2[3] + t2[61];
    f314 = MUL_C(COEF_CONST(1.0708550202783571),t2[3]);
    f315 = MUL_C(COEF_CONST((-0.9972904566786902)), f313);
    f316 = MUL_C(COEF_CONST((-0.9237258930790232)), t2[61]);
    f317 = f314 + f315;
    f318 = f316 - f315;
    f319 = t2[5] + t2[59];
    f320 = MUL_C(COEF_CONST(1.1148902097979256), t2[5]);
    f321 = MUL_C(COEF_CONST((-0.9924795345987101)), f319);
    f322 = MUL_C(COEF_CONST((-0.8700688593994945)), t2[59]);
    f323 = f320 + f321;
    f324 = f322 - f321;
    f325 = t2[7] + t2[57];
    f326 = MUL_C(COEF_CONST(1.1562395311492426), t2[7]);
    f327 = MUL_C(COEF_CONST((-0.9852776423889412)), f325);
    f328 = MUL_C(COEF_CONST((-0.8143157536286398)), t2[57]);
    f329 = f326 + f327;
    f330 = f328 - f327;
    f331 = t2[9] + t2[55];
    f332 = MUL_C(COEF_CONST(1.1948033701953984), t2[9]);
    f333 = MUL_C(COEF_CONST((-0.9757021300385286)), f331);
    f334 = MUL_C(COEF_CONST((-0.7566008898816589)), t2[55]);
    f335 = f332 + f333;
    f336 = f334 - f333;
    f337 = t2[11] + t2[53];
    f338 = MUL_C(COEF_CONST(1.2304888232703382), t2[11]);
    f339 = MUL_C(COEF_CONST((-0.9637760657954400)), f337);
    f340 = MUL_C(COEF_CONST((-0.6970633083205418)), t2[53]);
    f341 = f338 + f339;
    f342 = f340 - f339;
    f343 = t2[13] + t2[51];
    f344 = MUL_C(COEF_CONST(1.2632099209919279), t2[13]);
    f345 = MUL_C(COEF_CONST((-0.9495281805930368)), f343);
    f346 = MUL_C(COEF_CONST((-0.6358464401941457)), t2[51]);
    f347 = f344 + f345;
    f348 = f346 - f345;
    f349 = t2[15] + t2[49];
    f350 = MUL_C(COEF_CONST(1.2928878353697266), t2[15]);
    f351 = MUL_C(COEF_CONST((-0.9329927988347391)), f349);
    f352 = MUL_C(COEF_CONST((-0.5730977622997515)), t2[49]);
    f353 = f350 + f351;
    f354 = f352 - f351;
    f355 = t2[17] + t2[47];
    f356 = MUL_C(COEF_CONST(1.3194510697085207), t2[17]);
    f357 = MUL_C(COEF_CONST((-0.9142097557035306)), f355);
    f358 = MUL_C(COEF_CONST((-0.5089684416985405)), t2[47]);
    f359 = f356 + f357;
    f360 = f358 - f357;
    f361 = t2[19] + t2[45];
    f362 = MUL_C(COEF_CONST(1.3428356308501219), t2[19]);
    f363 = MUL_C(COEF_CONST((-0.8932243011955153)), f361);
    f364 = MUL_C(COEF_CONST((-0.4436129715409087)), t2[45]);
    f365 = f362 + f363;
    f366 = f364 - f363;
    f367 = t2[21] + t2[43];
    f368 = MUL_C(COEF_CONST(1.3629851833384954), t2[21]);
    f369 = MUL_C(COEF_CONST((-0.8700869911087115)), f367);
    f370 = MUL_C(COEF_CONST((-0.3771887988789276)), t2[43]);
    f371 = f368 + f369;
    f372 = f370 - f369;
    f373 = t2[23] + t2[41];
    f374 = MUL_C(COEF_CONST(1.3798511851368040), t2[23]);
    f375 = MUL_C(COEF_CONST((-0.8448535652497072)), f373);
    f376 = MUL_C(COEF_CONST((-0.3098559453626103)), t2[41]);
    f377 = f374 + f375;
    f378 = f376 - f375;
    f379 = t2[25] + t2[39];
    f380 = MUL_C(COEF_CONST(1.3933930045694289), t2[25]);
    f381 = MUL_C(COEF_CONST((-0.8175848131515840)), f379);
    f382 = MUL_C(COEF_CONST((-0.2417766217337392)), t2[39]);
    f383 = f380 + f381;
    f384 = f382 - f381;
    f385 = t2[27] + t2[37];
    f386 = MUL_C(COEF_CONST(1.4035780182072330), t2[27]);
    f387 = MUL_C(COEF_CONST((-0.7883464276266061)), f385);
    f388 = MUL_C(COEF_CONST((-0.1731148370459791)), t2[37]);
    f389 = f386 + f387;
    f390 = f388 - f387;
    f391 = t2[29] + t2[35];
    f392 = MUL_C(COEF_CONST(1.4103816894602614), t2[29]);
    f393 = MUL_C(COEF_CONST((-0.7572088465064846)), f391);
    f394 = MUL_C(COEF_CONST((-0.1040360035527078)), t2[35]);
    f395 = f392 + f393;
    f396 = f394 - f393;
    f397 = t2[31] + t2[33];
    f398 = MUL_C(COEF_CONST(1.4137876276885337), t2[31]);
    f399 = MUL_C(COEF_CONST((-0.7242470829514670)), f397);
    f400 = MUL_C(COEF_CONST((-0.0347065382144002)), t2[33]);
    f401 = f398 + f399;
    f402 = f400 - f399;
    f403 = f312 - f402;
    f404 = f312 + f402;
    f405 = f318 - f396;
    f406 = f318 + f396;
    f407 = f324 - f390;
    f408 = f324 + f390;
    f409 = f330 - f384;
    f410 = f330 + f384;
    f411 = f336 - f378;
    f412 = f336 + f378;
    f413 = f342 - f372;
    f414 = f342 + f372;
    f415 = f348 - f366;
    f416 = f348 + f366;
    f417 = f354 - f360;
    f418 = f354 + f360;
    f419 = f404 - f418;
    f420 = f404 + f418;
    f421 = f406 - f416;
    f422 = f406 + f416;
    f423 = f408 - f414;
    f424 = f408 + f414;
    f425 = f410 - f412;
    f426 = f410 + f412;
    f427 = f420 - f426;
    f428 = f420 + f426;
    f429 = f422 - f424;
    f430 = f422 + f424;
    f431 = f428 - f430;
    y[1] = f428 + f430;
    f433 = MUL_C(COEF_CONST(0.7071067811865476), f431);
    f434 = f427 + f429;
    f435 = MUL_C(COEF_CONST(1.3065629648763766), f427);
    f436 = MUL_C(COEF_CONST((-0.9238795325112866)), f434);
    f437 = MUL_C(COEF_CONST((-0.5411961001461967)), f429);
    f438 = f435 + f436;
    f439 = f437 - f436;
    f440 = f419 + f425;
    f441 = MUL_C(COEF_CONST(1.1758756024193588), f419);
    f442 = MUL_C(COEF_CONST((-0.9807852804032304)), f440);
    f443 = MUL_C(COEF_CONST((-0.7856949583871021)), f425);
    f444 = f441 + f442;
    f445 = f443 - f442;
    f446 = f421 + f423;
    f447 = MUL_C(COEF_CONST(1.3870398453221473), f421);
    f448 = MUL_C(COEF_CONST((-0.8314696123025455)), f446);
    f449 = MUL_C(COEF_CONST((-0.2758993792829436)), f423);
    f450 = f447 + f448;
    f451 = f449 - f448;
    f452 = f445 - f451;
    f453 = f445 + f451;
    f454 = MUL_C(COEF_CONST(0.7071067811865476), f452);
    f455 = f444 - f450;
    f456 = f444 + f450;
    f457 = MUL_C(COEF_CONST(0.7071067811865476), f456);
    f458 = f454 - f457;
    f459 = f454 + f457;
    f460 = f405 - f407;
    f461 = f405 + f407;
    f462 = f409 - f411;
    f463 = f409 + f411;
    f464 = f413 - f415;
    f465 = f413 + f415;
    f466 = MUL_C(COEF_CONST(0.7071067811865476), f463);
    f467 = f403 - f466;
    f468 = f403 + f466;
    f469 = f461 + f465;
    f470 = MUL_C(COEF_CONST(1.3065629648763766), f461);
    f471 = MUL_C(COEF_CONST((-0.9238795325112866)), f469);
    f472 = MUL_C(COEF_CONST((-0.5411961001461967)), f465);
    f473 = f470 + f471;
    f474 = f472 - f471;
    f475 = f468 - f474;
    f476 = f468 + f474;
    f477 = f467 - f473;
    f478 = f467 + f473;
    f479 = f460 + f464;
    f480 = MUL_C(COEF_CONST(1.3065629648763770), f460);
    f481 = MUL_C(COEF_CONST((-0.3826834323650904)), f479);
    f482 = MUL_C(COEF_CONST(0.5411961001461961), f464);
    f483 = f480 + f481;
    f484 = f482 - f481;
    f485 = MUL_C(COEF_CONST(0.7071067811865476), f462);
    f486 = f485 - f417;
    f487 = f485 + f417;
    f488 = f484 - f487;
    f489 = f484 + f487;
    f490 = f483 - f486;
    f491 = f483 + f486;
    f492 = f489 + f476;
    f493 = MUL_C(COEF_CONST((-0.8971675863426361)), f489);
    f494 = MUL_C(COEF_CONST(0.9951847266721968), f492);
    f495 = MUL_C(COEF_CONST(1.0932018670017576), f476);
    f496 = f493 + f494;
    f497 = f495 - f494;
    f498 = f491 + f478;
    f499 = MUL_C(COEF_CONST((-0.6666556584777466)), f491);
    f500 = MUL_C(COEF_CONST(0.9569403357322089), f498);
    f501 = MUL_C(COEF_CONST(1.2472250129866713), f478);
    f502 = f499 + f500;
    f503 = f501 - f500;
    f504 = f490 + f477;
    f505 = MUL_C(COEF_CONST((-0.4105245275223571)), f490);
    f506 = MUL_C(COEF_CONST(0.8819212643483549), f504);
    f507 = MUL_C(COEF_CONST(1.3533180011743529), f477);
    f508 = f505 + f506;
    f509 = f507 - f506;
    f510 = f488 + f475;
    f511 = MUL_C(COEF_CONST((-0.1386171691990915)), f488);
    f512 = MUL_C(COEF_CONST(0.7730104533627370), f510);
    f513 = MUL_C(COEF_CONST(1.4074037375263826), f475);
    f514 = f511 + f512;
    f515 = f513 - f512;
    f516 = f311 + f401;
    f517 = f311 - f401;
    f518 = f317 + f395;
    f519 = f395 - f317;
    f520 = f323 + f389;
    f521 = f323 - f389;
    f522 = f329 + f383;
    f523 = f383 - f329;
    f524 = f335 + f377;
    f525 = f335 - f377;
    f526 = f341 + f371;
    f527 = f371 - f341;
    f528 = f347 + f365;
    f529 = f347 - f365;
    f530 = f353 + f359;
    f531 = f359 - f353;
    f532 = f517 - f531;
    f533 = f517 + f531;
    f534 = f519 - f529;
    f535 = f519 + f529;
    f536 = f521 - f527;
    f537 = f521 + f527;
    f538 = f523 - f525;
    f539 = f523 + f525;
    f540 = f533 - f539;
    f541 = f533 + f539;
    f542 = f535 - f537;
    f543 = f535 + f537;
    f544 = f541 - f543;
    y[63] = f541 + f543;
    f546 = MUL_C(COEF_CONST(0.7071067811865476), f544);
    f547 = f540 + f542;
    f548 = MUL_C(COEF_CONST(1.3065629648763766), f540);
    f549 = MUL_C(COEF_CONST((-0.9238795325112866)), f547);
    f550 = MUL_C(COEF_CONST((-0.5411961001461967)), f542);
    f551 = f548 + f549;
    f552 = f550 - f549;
    f553 = f532 + f538;
    f554 = MUL_C(COEF_CONST(1.1758756024193588), f532);
    f555 = MUL_C(COEF_CONST((-0.9807852804032304)), f553);
    f556 = MUL_C(COEF_CONST((-0.7856949583871021)), f538);
    f557 = f554 + f555;
    f558 = f556 - f555;
    f559 = f534 + f536;
    f560 = MUL_C(COEF_CONST(1.3870398453221473), f534);
    f561 = MUL_C(COEF_CONST((-0.8314696123025455)), f559);
    f562 = MUL_C(COEF_CONST((-0.2758993792829436)), f536);
    f563 = f560 + f561;
    f564 = f562 - f561;
    f565 = f558 - f564;
    f566 = f558 + f564;
    f567 = MUL_C(COEF_CONST(0.7071067811865476), f565);
    f568 = f557 - f563;
    f569 = f557 + f563;
    f570 = MUL_C(COEF_CONST(0.7071067811865476), f569);
    f571 = f567 - f570;
    f572 = f567 + f570;
    f573 = MUL_C(COEF_CONST(0.5024192861881557), f516);
    f574 = MUL_C(COEF_CONST(0.5224986149396889), f518);
    f575 = MUL_C(COEF_CONST(0.5669440348163577), f520);
    f576 = MUL_C(COEF_CONST(0.6468217833599901), f522);
    f577 = MUL_C(COEF_CONST(0.7881546234512502), f524);
    f578 = MUL_C(COEF_CONST(1.0606776859903471), f526);
    f579 = MUL_C(COEF_CONST(1.7224470982383342), f528);
    f580 = MUL_C(COEF_CONST(5.1011486186891553), f530);
    f581 = f573 + f580;
    f582 = f573 - f580;
    f583 = f574 + f579;
    f584 = f579 - f574;
    f585 = f575 + f578;
    f586 = f575 - f578;
    f587 = f576 + f577;
    f588 = f577 - f576;
    f589 = f582 - f588;
    f590 = f582 + f588;
    f591 = f584 - f586;
    f592 = f584 + f586;
    f593 = f590 - f592;
    f594 = f590 + f592;
    f595 = MUL_C(COEF_CONST(0.7071067811865476), f593);
    f596 = f589 + f591;
    f597 = MUL_C(COEF_CONST(1.3065629648763766), f589);
    f598 = MUL_C(COEF_CONST((-0.9238795325112866)), f596);
    f599 = MUL_C(COEF_CONST((-0.5411961001461967)), f591);
    f600 = f597 + f598;
    f601 = f599 - f598;
    f602 = f583 + f585;
    f603 = f585 - f583;
    f604 = MUL_C(COEF_CONST(0.7071067811865476), f603);
    f605 = MUL_C(COEF_CONST(0.7071067811865476), f602);
    f606 = f581 - f604;
    f607 = f581 + f604;
    f608 = f605 - f587;
    f609 = f587 + f605;
    f610 = f607 - f609;
    f611 = MUL_C(COEF_CONST((-0.7856949583871021)), f609);
    f612 = MUL_C(COEF_CONST(0.9807852804032304), f610);
    f613 = MUL_C(COEF_CONST(1.1758756024193588), f607);
    f614 = f612 - f611;
    f615 = f613 - f612;
    f616 = f608 + f606;
    f617 = MUL_C(COEF_CONST(0.2758993792829431), f608);
    f618 = MUL_C(COEF_CONST(0.5555702330196022), f616);
    f619 = MUL_C(COEF_CONST(1.3870398453221475), f606);
    f620 = f617 + f618;
    f621 = f619 - f618;
    f622 = f594 + f614;
    f623 = f614 + f601;
    f624 = f601 + f621;
    f625 = f621 + f595;
    f626 = f595 + f620;
    f627 = f620 + f600;
    f628 = f600 + f615;
    y[5] = f496 - f615;
    y[3] = f496 + f615;
    y[9] = f453 - f568;
    y[7] = f453 + f568;
    y[13] = f502 - f628;
    y[11] = f502 + f628;
    y[17] = f439 - f551;
    y[15] = f439 + f551;
    y[21] = f508 - f627;
    y[19] = f508 + f627;
    y[25] = f459 - f571;
    y[23] = f459 + f571;
    y[29] = f514 - f626;
    y[27] = f514 + f626;
    y[33] = f433 - f546;
    y[31] = f433 + f546;
    y[37] = f515 - f625;
    y[35] = f515 + f625;
    y[41] = f458 - f572;
    y[39] = f458 + f572;
    y[45] = f509 - f624;
    y[43] = f509 + f624;
    y[49] = f438 - f552;
    y[47] = f438 + f552;
    y[53] = f503 - f623;
    y[51] = f503 + f623;
    y[57] = f455 - f566;
    y[55] = f455 + f566;
    y[61] = f497 - f622;
    y[59] = f497 + f622;
}

void DST2_64_unscaled(real_t *y, real_t *x)
{
    int16_t i0;
    real_t f2, f3, f4, f5, f6, f7;
    real_t f8, f9, f10, f11, f12, f13;
    real_t f14, f15, f16, f17, f18, f19;
    real_t f20, f21, f22, f23, f24, f25;
    real_t f26, f27, f28, f29, f30, f31;
    real_t f32, f33, f34, f35, f36, f37;
    real_t f38, f39, f40, f41, f42, f43;
    real_t f44, f45, f46, f47, f48, f49;
    real_t f50, f51, f52, f53, f54, f55;
    real_t f56, f57, f58, f59, f60, f61;
    real_t f62, f63, f64, f65, f66, f67;
    real_t f68, f69, f70, f71, f72, f73;
    real_t f74, f75, f76, f77, f78, f79;
    real_t f80, f81, f82, f83, f84, f85;
    real_t f86, f87, f88, f89, f90, f91;
    real_t f92, f93, f94, f95, f96, f97;
    real_t f98, f99, f100, f101, f102, f103;
    real_t f104, f105, f106, f107, f108, f109;
    real_t f110, f111, f112, f113, f114, f115;
    real_t f116, f117, f118, f119, f120, f121;
    real_t f122, f123, f124, f125, f126, f127;
    real_t f128, f129, f130, f131, f132, f133;
    real_t f134, f135, f136, f137, f138, f139;
    real_t f140, f141, f142, f143, f144, f145;
    real_t f146, f147, f148, f149, f150, f151;
    real_t f152, f153, f154, f155, f156, f157;
    real_t f158, f159, f160, f161, f162, f163;
    real_t f164, f165, f166, f167, f168, f169;
    real_t f170, f171, f172, f173, f174, f175;
    real_t f176, f177, f178, f179, f180, f181;
    real_t f182, f183, f184, f185, f186, f187;
    real_t f188, f189, f190, f191, f192, f193;
    real_t f194, f195, f196, f197, f198, f199;
    real_t f200, f201, f202, f203, f204, f205;
    real_t f206, f207, f208, f209, f210, f211;
    real_t f212, f213, f214, f215, f216, f217;
    real_t f218, f219, f220, f221, f222, f223;
    real_t f224, f225, f226, f227, f228, f229;
    real_t f230, f231, f232, f233, f234, f235;
    real_t f236, f237, f238, f239, f240, f241;
    real_t f242, f243, f244, f245, f246, f247;
    real_t f248, f249, f250, f251, f252, f253;
    real_t f254, f255, f256, f257, f258, f259;
    real_t f260, f261, f264, f265, f266, f267;
    real_t f270, f271, f272, f273, f276, f277;
    real_t f278, f279, f282, f283, f284, f285;
    real_t f288, f289, f290, f291, f294, f295;
    real_t f296, f297, f300, f301, f302, f303;
    real_t f306, f307, f308, f309, f312, f313;
    real_t f314, f315, f318, f319, f320, f321;
    real_t f324, f325, f326, f327, f330, f331;
    real_t f332, f333, f336, f337, f338, f339;
    real_t f342, f343, f344, f345, f348, f349;
    real_t f350, f351, f354, f355, f356, f357;
    real_t f358, f359, f360, f361, f362, f363;
    real_t f364, f365, f366, f367, f368, f369;
    real_t f370, f371, f372, f373, f374, f375;
    real_t f376, f377, f378, f379, f380, f381;
    real_t f382, f383, f384, f385, f386, f387;
    real_t f388, f389, f390, f391, f392, f393;
    real_t f394, f395, f396, f397, f398, f399;
    real_t f400, f401, f402, f403, f404, f405;
    real_t f406, f407, f408, f409, f410, f411;
    real_t f412, f413, f414, f415, f416, f417;
    real_t f418, f419, f420, f421, f422, f423;
    real_t f424, f425, f426, f427, f428, f429;
    real_t f430, f431, f432, f433, f434, f435;
    real_t f436, f437, f438, f439, f440, f441;
    real_t f442, f443, f444, f445, f446, f447;
    real_t f448, f449, f450, f451, f452, f453;
    real_t f454, f455, f456, f457, f458, f459;
    real_t f460, f461, f462, f463, f464, f465;
    real_t f466, f467, f468, f469, f470, f471;
    real_t f472, f473, f474, f475, f476, f477;
    real_t f478, f479, f480, f481, f482, f483;
    real_t f484, f485, f486, f487, f488, f489;
    real_t f490, f491, f492, f493, f494, f495;
    real_t f496, f497, f498, f499, f500, f501;
    real_t f504, f505, f506, f507, f510, f511;
    real_t f512, f513, f516, f517, f518, f519;
    real_t f522, f523, f524, f525, f528, f529;
    real_t f530, f531, f534, f535, f536, f537;
    real_t f540, f541, f542, f543, f546, f547;
    real_t f548, f549, f550, f551, f552, f553;
    real_t f554, f555, f556, f557, f558, f559;
    real_t f560, f561, f562, f563, f564, f565;
    real_t f566, f567, f568, f569, f570, f571;
    real_t f572, f573, f574, f577, f578, f579;
    real_t f580, f583, f584, f585, f586, f587;
    real_t f588, f589, f590, f591, f592, f593;
    real_t f594, f595, f596, f597, f598, f603;
    real_t f604, f605, f606, f607, f608, f609;
    real_t f610, f611, f612, f613, f614, f615;
    real_t f616, f617, f618, f619, f620, f621;
    real_t f622, f623, f624, f625, f626, f627;
    real_t f628, f629, f630, f631, f632, f633;
    real_t f634, f635, f636, f637, f638, f639;
    real_t f640, f641, f642, f643, f644, f645;
    real_t f646, f647, f648, f649, f650;
    ALIGN static real_t t2[64];

    for (i0=0; i0<32; i0++)
    {
        t2[2*i0+1] = x[i0] - x[-i0+63];
        t2[2*i0] = x[i0] + x[-i0+63];
    }
    f2 = t2[2] + t2[4];
    f3 = t2[4] - t2[2];
    f4 = t2[6] + t2[8];
    f5 = t2[8] - t2[6];
    f6 = t2[10] + t2[12];
    f7 = t2[12] - t2[10];
    f8 = t2[14] + t2[16];
    f9 = t2[16] - t2[14];
    f10 = t2[18] + t2[20];
    f11 = t2[20] - t2[18];
    f12 = t2[22] + t2[24];
    f13 = t2[24] - t2[22];
    f14 = t2[26] + t2[28];
    f15 = t2[28] - t2[26];
    f16 = t2[30] + t2[32];
    f17 = t2[32] - t2[30];
    f18 = t2[34] + t2[36];
    f19 = t2[36] - t2[34];
    f20 = t2[38] + t2[40];
    f21 = t2[40] - t2[38];
    f22 = t2[42] + t2[44];
    f23 = t2[44] - t2[42];
    f24 = t2[46] + t2[48];
    f25 = t2[48] - t2[46];
    f26 = t2[50] + t2[52];
    f27 = t2[52] - t2[50];
    f28 = t2[54] + t2[56];
    f29 = t2[56] - t2[54];
    f30 = t2[58] + t2[60];
    f31 = t2[60] - t2[58];
    f32 = MUL_C(COEF_CONST(0.7071067811865476), f17);
    f33 = t2[0] - f32;
    f34 = t2[0] + f32;
    f35 = f9 + f25;
    f36 = MUL_C(COEF_CONST(1.3065629648763766), f9);
    f37 = MUL_C(COEF_CONST((-0.9238795325112866)), f35);
    f38 = MUL_C(COEF_CONST((-0.5411961001461967)), f25);
    f39 = f36 + f37;
    f40 = f38 - f37;
    f41 = f34 - f40;
    f42 = f34 + f40;
    f43 = f33 - f39;
    f44 = f33 + f39;
    f45 = MUL_C(COEF_CONST(2.5629154477415064), f5);
    f46 = MUL_C(COEF_CONST(0.8999762231364158), f13);
    f47 = MUL_C(COEF_CONST(0.5097955791041592), f29);
    f48 = MUL_C(COEF_CONST(0.6013448869350453), f21);
    f49 = f45 - f47;
    f50 = f45 + f47;
    f51 = f46 - f48;
    f52 = f46 + f48;
    f53 = f50 + f52;
    f54 = MUL_C(COEF_CONST(1.3065629648763770), f50);
    f55 = MUL_C(COEF_CONST((-0.3826834323650904)), f53);
    f56 = MUL_C(COEF_CONST(0.5411961001461961), f52);
    f57 = f54 + f55;
    f58 = f56 - f55;
    f59 = f51 - f49;
    f60 = f49 + f51;
    f61 = MUL_C(COEF_CONST(0.7071067811865476), f60);
    f62 = f58 - f61;
    f63 = f57 - f61;
    f64 = f59 + f57;
    f65 = f42 - f58;
    f66 = f42 + f58;
    f67 = f44 + f62;
    f68 = f44 - f62;
    f69 = f43 - f63;
    f70 = f43 + f63;
    f71 = f41 + f64;
    f72 = f41 - f64;
    f73 = f7 - f11;
    f74 = f7 + f11;
    f75 = f15 - f19;
    f76 = f15 + f19;
    f77 = f23 - f27;
    f78 = f23 + f27;
    f79 = MUL_C(COEF_CONST(0.7071067811865476), f76);
    f80 = f3 - f79;
    f81 = f3 + f79;
    f82 = f74 + f78;
    f83 = MUL_C(COEF_CONST(1.3065629648763766), f74);
    f84 = MUL_C(COEF_CONST((-0.9238795325112866)), f82);
    f85 = MUL_C(COEF_CONST((-0.5411961001461967)), f78);
    f86 = f83 + f84;
    f87 = f85 - f84;
    f88 = f81 - f87;
    f89 = f81 + f87;
    f90 = f80 - f86;
    f91 = f80 + f86;
    f92 = MUL_C(COEF_CONST(0.7071067811865476), f75);
    f93 = f31 - f92;
    f94 = f31 + f92;
    f95 = f77 + f73;
    f96 = MUL_C(COEF_CONST(1.3065629648763766), f77);
    f97 = MUL_C(COEF_CONST((-0.9238795325112866)), f95);
    f98 = MUL_C(COEF_CONST((-0.5411961001461967)), f73);
    f99 = f96 + f97;
    f100 = f98 - f97;
    f101 = f94 - f100;
    f102 = f94 + f100;
    f103 = f93 - f99;
    f104 = f93 + f99;
    f105 = f102 + f89;
    f106 = MUL_C(COEF_CONST((-0.8971675863426361)), f102);
    f107 = MUL_C(COEF_CONST(0.9951847266721968), f105);
    f108 = MUL_C(COEF_CONST(1.0932018670017576), f89);
    f109 = f106 + f107;
    f110 = f108 - f107;
    f111 = f91 - f104;
    f112 = MUL_C(COEF_CONST((-0.6666556584777466)), f104);
    f113 = MUL_C(COEF_CONST(0.9569403357322089), f111);
    f114 = MUL_C(COEF_CONST(1.2472250129866713), f91);
    f115 = f113 - f112;
    f116 = f114 - f113;
    f117 = f103 + f90;
    f118 = MUL_C(COEF_CONST((-0.4105245275223571)), f103);
    f119 = MUL_C(COEF_CONST(0.8819212643483549), f117);
    f120 = MUL_C(COEF_CONST(1.3533180011743529), f90);
    f121 = f118 + f119;
    f122 = f120 - f119;
    f123 = f88 - f101;
    f124 = MUL_C(COEF_CONST((-0.1386171691990915)), f101);
    f125 = MUL_C(COEF_CONST(0.7730104533627370), f123);
    f126 = MUL_C(COEF_CONST(1.4074037375263826), f88);
    f127 = f125 - f124;
    f128 = f126 - f125;
    f129 = f66 - f109;
    f130 = f66 + f109;
    f131 = f68 - f115;
    f132 = f68 + f115;
    f133 = f70 - f121;
    f134 = f70 + f121;
    f135 = f72 - f127;
    f136 = f72 + f127;
    f137 = f71 - f128;
    f138 = f71 + f128;
    f139 = f69 - f122;
    f140 = f69 + f122;
    f141 = f67 - f116;
    f142 = f67 + f116;
    f143 = f65 - f110;
    f144 = f65 + f110;
    f145 = f26 + f30;
    f146 = f22 + f26;
    f147 = f18 + f22;
    f148 = f14 + f18;
    f149 = f10 + f14;
    f150 = f6 + f10;
    f151 = f2 + f6;
    f152 = MUL_C(COEF_CONST(0.7071067811865476), f148);
    f153 = f152 - f30;
    f154 = f30 + f152;
    f155 = f146 + f150;
    f156 = MUL_C(COEF_CONST(1.3065629648763766), f146);
    f157 = MUL_C(COEF_CONST((-0.9238795325112866)), f155);
    f158 = MUL_C(COEF_CONST((-0.5411961001461967)), f150);
    f159 = f156 + f157;
    f160 = f157 - f158;
    f161 = f154 + f160;
    f162 = f160 - f154;
    f163 = f153 + f159;
    f164 = f153 - f159;
    f165 = f147 + f145;
    f166 = f149 + f147;
    f167 = f151 + f149;
    f168 = MUL_C(COEF_CONST(0.7071067811865476), f166);
    f169 = f168 - f145;
    f170 = f145 + f168;
    f171 = f165 + f167;
    f172 = MUL_C(COEF_CONST(1.3065629648763766), f165);
    f173 = MUL_C(COEF_CONST((-0.9238795325112866)), f171);
    f174 = MUL_C(COEF_CONST((-0.5411961001461967)), f167);
    f175 = f172 + f173;
    f176 = f173 - f174;
    f177 = f170 + f176;
    f178 = f176 - f170;
    f179 = f169 + f175;
    f180 = f169 - f175;
    f181 = MUL_C(COEF_CONST(0.5097955791041592), f178);
    f182 = MUL_C(COEF_CONST(0.6013448869350453), f180);
    f183 = MUL_C(COEF_CONST(0.8999762231364156), f179);
    f184 = MUL_C(COEF_CONST(2.5629154477415055), f177);
    f185 = f162 - f181;
    f186 = f162 + f181;
    f187 = f164 - f182;
    f188 = f164 + f182;
    f189 = f163 - f183;
    f190 = f163 + f183;
    f191 = f184 - f161;
    f192 = f161 + f184;
    f193 = MUL_C(COEF_CONST(0.5024192861881557), f186);
    f194 = MUL_C(COEF_CONST(0.5224986149396889), f188);
    f195 = MUL_C(COEF_CONST(0.5669440348163577), f190);
    f196 = MUL_C(COEF_CONST(0.6468217833599901), f192);
    f197 = MUL_C(COEF_CONST(0.7881546234512502), f191);
    f198 = MUL_C(COEF_CONST(1.0606776859903471), f189);
    f199 = MUL_C(COEF_CONST(1.7224470982383342), f187);
    f200 = MUL_C(COEF_CONST(5.1011486186891553), f185);
    f201 = MUL_C(COEF_CONST(0.7071067811865476), f16);
    f202 = f201 - t2[62];
    f203 = t2[62] + f201;
    f204 = f24 + f8;
    f205 = MUL_C(COEF_CONST(1.3065629648763766), f24);
    f206 = MUL_C(COEF_CONST((-0.9238795325112866)), f204);
    f207 = MUL_C(COEF_CONST((-0.5411961001461967)), f8);
    f208 = f205 + f206;
    f209 = f206 - f207;
    f210 = f203 + f209;
    f211 = f209 - f203;
    f212 = f202 + f208;
    f213 = f202 - f208;
    f214 = f20 + f28;
    f215 = f12 + f20;
    f216 = f4 + f12;
    f217 = MUL_C(COEF_CONST(0.7071067811865476), f215);
    f218 = f217 - f28;
    f219 = f28 + f217;
    f220 = f214 + f216;
    f221 = MUL_C(COEF_CONST(1.3065629648763766), f214);
    f222 = MUL_C(COEF_CONST((-0.9238795325112866)), f220);
    f223 = MUL_C(COEF_CONST((-0.5411961001461967)), f216);
    f224 = f221 + f222;
    f225 = f222 - f223;
    f226 = f219 + f225;
    f227 = f225 - f219;
    f228 = f218 + f224;
    f229 = f218 - f224;
    f230 = MUL_C(COEF_CONST(0.5097955791041592), f227);
    f231 = MUL_C(COEF_CONST(0.6013448869350453), f229);
    f232 = MUL_C(COEF_CONST(0.8999762231364156), f228);
    f233 = MUL_C(COEF_CONST(2.5629154477415055), f226);
    f234 = f211 - f230;
    f235 = f211 + f230;
    f236 = f213 - f231;
    f237 = f213 + f231;
    f238 = f212 - f232;
    f239 = f212 + f232;
    f240 = f233 - f210;
    f241 = f210 + f233;
    f242 = f193 - f235;
    f243 = f193 + f235;
    f244 = f237 - f194;
    f245 = f194 + f237;
    f246 = f195 - f239;
    f247 = f195 + f239;
    f248 = f196 - f241;
    f249 = f196 + f241;
    f250 = f197 - f240;
    f251 = f197 + f240;
    f252 = f238 - f198;
    f253 = f198 + f238;
    f254 = f199 - f236;
    f255 = f199 + f236;
    f256 = f234 - f200;
    f257 = f200 + f234;
    f258 = f243 + f130;
    f259 = MUL_C(COEF_CONST((-0.9751575901732920)), f243);
    f260 = MUL_C(COEF_CONST(0.9996988186962043), f258);
    f261 = MUL_C(COEF_CONST(1.0242400472191164), f130);
    y[62] = f259 + f260;
    y[0] = f261 - f260;
    f264 = f132 - f245;
    f265 = MUL_C(COEF_CONST((-0.9237258930790228)), f245);
    f266 = MUL_C(COEF_CONST(0.9972904566786902), f264);
    f267 = MUL_C(COEF_CONST(1.0708550202783576), f132);
    y[60] = f266 - f265;
    y[2] = f267 - f266;
    f270 = f247 + f134;
    f271 = MUL_C(COEF_CONST((-0.8700688593994936)), f247);
    f272 = MUL_C(COEF_CONST(0.9924795345987100), f270);
    f273 = MUL_C(COEF_CONST(1.1148902097979263), f134);
    y[58] = f271 + f272;
    y[4] = f273 - f272;
    f276 = f249 + f136;
    f277 = MUL_C(COEF_CONST((-0.8143157536286398)), f249);
    f278 = MUL_C(COEF_CONST(0.9852776423889412), f276);
    f279 = MUL_C(COEF_CONST(1.1562395311492426), f136);
    y[56] = f277 + f278;
    y[6] = f279 - f278;
    f282 = f251 + f138;
    f283 = MUL_C(COEF_CONST((-0.7566008898816587)), f251);
    f284 = MUL_C(COEF_CONST(0.9757021300385286), f282);
    f285 = MUL_C(COEF_CONST(1.1948033701953984), f138);
    y[54] = f283 + f284;
    y[8] = f285 - f284;
    f288 = f140 - f253;
    f289 = MUL_C(COEF_CONST((-0.6970633083205414)), f253);
    f290 = MUL_C(COEF_CONST(0.9637760657954398), f288);
    f291 = MUL_C(COEF_CONST(1.2304888232703384), f140);
    y[52] = f290 - f289;
    y[10] = f291 - f290;
    f294 = f255 + f142;
    f295 = MUL_C(COEF_CONST((-0.6358464401941451)), f255);
    f296 = MUL_C(COEF_CONST(0.9495281805930367), f294);
    f297 = MUL_C(COEF_CONST(1.2632099209919283), f142);
    y[50] = f295 + f296;
    y[12] = f297 - f296;
    f300 = f144 - f257;
    f301 = MUL_C(COEF_CONST((-0.5730977622997506)), f257);
    f302 = MUL_C(COEF_CONST(0.9329927988347389), f300);
    f303 = MUL_C(COEF_CONST(1.2928878353697271), f144);
    y[48] = f302 - f301;
    y[14] = f303 - f302;
    f306 = f256 + f143;
    f307 = MUL_C(COEF_CONST((-0.5089684416985408)), f256);
    f308 = MUL_C(COEF_CONST(0.9142097557035307), f306);
    f309 = MUL_C(COEF_CONST(1.3194510697085207), f143);
    y[46] = f307 + f308;
    y[16] = f309 - f308;
    f312 = f254 + f141;
    f313 = MUL_C(COEF_CONST((-0.4436129715409087)), f254);
    f314 = MUL_C(COEF_CONST(0.8932243011955153), f312);
    f315 = MUL_C(COEF_CONST(1.3428356308501219), f141);
    y[44] = f313 + f314;
    y[18] = f315 - f314;
    f318 = f252 + f139;
    f319 = MUL_C(COEF_CONST((-0.3771887988789273)), f252);
    f320 = MUL_C(COEF_CONST(0.8700869911087114), f318);
    f321 = MUL_C(COEF_CONST(1.3629851833384954), f139);
    y[42] = f319 + f320;
    y[20] = f321 - f320;
    f324 = f250 + f137;
    f325 = MUL_C(COEF_CONST((-0.3098559453626097)), f250);
    f326 = MUL_C(COEF_CONST(0.8448535652497070), f324);
    f327 = MUL_C(COEF_CONST(1.3798511851368043), f137);
    y[40] = f325 + f326;
    y[22] = f327 - f326;
    f330 = f248 + f135;
    f331 = MUL_C(COEF_CONST((-0.2417766217337384)), f248);
    f332 = MUL_C(COEF_CONST(0.8175848131515837), f330);
    f333 = MUL_C(COEF_CONST(1.3933930045694289), f135);
    y[38] = f331 + f332;
    y[24] = f333 - f332;
    f336 = f246 + f133;
    f337 = MUL_C(COEF_CONST((-0.1731148370459794)), f246);
    f338 = MUL_C(COEF_CONST(0.7883464276266062), f336);
    f339 = MUL_C(COEF_CONST(1.4035780182072330), f133);
    y[36] = f337 + f338;
    y[26] = f339 - f338;
    f342 = f244 + f131;
    f343 = MUL_C(COEF_CONST((-0.1040360035527077)), f244);
    f344 = MUL_C(COEF_CONST(0.7572088465064845), f342);
    f345 = MUL_C(COEF_CONST(1.4103816894602612), f131);
    y[34] = f343 + f344;
    y[28] = f345 - f344;
    f348 = f242 + f129;
    f349 = MUL_C(COEF_CONST((-0.0347065382144000)), f242);
    f350 = MUL_C(COEF_CONST(0.7242470829514669), f348);
    f351 = MUL_C(COEF_CONST(1.4137876276885337), f129);
    y[32] = f349 + f350;
    y[30] = f351 - f350;
    f354 = t2[1] - t2[63];
    f355 = t2[1] + t2[63];
    f356 = t2[3] - t2[61];
    f357 = t2[3] + t2[61];
    f358 = t2[5] - t2[59];
    f359 = t2[5] + t2[59];
    f360 = t2[7] - t2[57];
    f361 = t2[7] + t2[57];
    f362 = t2[9] - t2[55];
    f363 = t2[9] + t2[55];
    f364 = t2[11] - t2[53];
    f365 = t2[11] + t2[53];
    f366 = t2[13] - t2[51];
    f367 = t2[13] + t2[51];
    f368 = t2[15] - t2[49];
    f369 = t2[15] + t2[49];
    f370 = t2[17] - t2[47];
    f371 = t2[17] + t2[47];
    f372 = t2[19] - t2[45];
    f373 = t2[19] + t2[45];
    f374 = t2[21] - t2[43];
    f375 = t2[21] + t2[43];
    f376 = t2[23] - t2[41];
    f377 = t2[23] + t2[41];
    f378 = t2[25] - t2[39];
    f379 = t2[25] + t2[39];
    f380 = t2[27] - t2[37];
    f381 = t2[27] + t2[37];
    f382 = t2[29] - t2[35];
    f383 = t2[29] + t2[35];
    f384 = t2[31] - t2[33];
    f385 = t2[31] + t2[33];
    f386 = f369 + f371;
    f387 = f371 - f369;
    f388 = MUL_C(COEF_CONST(0.7071067811865476), f387);
    f389 = MUL_C(COEF_CONST(0.7071067811865476), f386);
    f390 = f363 + f377;
    f391 = f363 - f377;
    f392 = MUL_C(COEF_CONST(0.7071067811865476), f391);
    f393 = MUL_C(COEF_CONST(0.7071067811865476), f390);
    f394 = f367 + f373;
    f395 = f367 - f373;
    f396 = MUL_C(COEF_CONST(0.7071067811865476), f395);
    f397 = MUL_C(COEF_CONST(0.7071067811865476), f394);
    f398 = f365 + f375;
    f399 = f375 - f365;
    f400 = MUL_C(COEF_CONST(0.7071067811865476), f399);
    f401 = MUL_C(COEF_CONST(0.7071067811865476), f398);
    f402 = f355 - f388;
    f403 = f355 + f388;
    f404 = f389 - f385;
    f405 = f385 + f389;
    f406 = f361 + f392;
    f407 = f392 - f361;
    f408 = f379 - f393;
    f409 = f379 + f393;
    f410 = f357 + f396;
    f411 = f396 - f357;
    f412 = f383 - f397;
    f413 = f383 + f397;
    f414 = f359 - f400;
    f415 = f359 + f400;
    f416 = f401 - f381;
    f417 = f381 + f401;
    f418 = f409 + f407;
    f419 = MUL_C(COEF_CONST((-0.5411961001461969)), f409);
    f420 = MUL_C(COEF_CONST(0.9238795325112867), f418);
    f421 = MUL_C(COEF_CONST(1.3065629648763766), f407);
    f422 = f419 + f420;
    f423 = f421 - f420;
    f424 = f408 - f406;
    f425 = MUL_C(COEF_CONST(1.3065629648763770), f408);
    f426 = MUL_C(COEF_CONST((-0.3826834323650904)), f424);
    f427 = MUL_C(COEF_CONST(0.5411961001461961), f406);
    f428 = f425 + f426;
    f429 = f426 + f427;
    f430 = f415 - f417;
    f431 = MUL_C(COEF_CONST((-0.5411961001461969)), f417);
    f432 = MUL_C(COEF_CONST(0.9238795325112867), f430);
    f433 = MUL_C(COEF_CONST(1.3065629648763766), f415);
    f434 = f432 - f431;
    f435 = f433 - f432;
    f436 = f416 + f414;
    f437 = MUL_C(COEF_CONST(1.3065629648763770), f416);
    f438 = MUL_C(COEF_CONST((-0.3826834323650904)), f436);
    f439 = MUL_C(COEF_CONST(0.5411961001461961), f414);
    f440 = f437 + f438;
    f441 = f439 - f438;
    f442 = f403 - f422;
    f443 = f403 + f422;
    f444 = f405 + f423;
    f445 = f423 - f405;
    f446 = f402 - f428;
    f447 = f402 + f428;
    f448 = f404 + f429;
    f449 = f404 - f429;
    f450 = f411 - f434;
    f451 = f411 + f434;
    f452 = f413 - f435;
    f453 = f413 + f435;
    f454 = f410 + f440;
    f455 = f440 - f410;
    f456 = f412 - f441;
    f457 = f412 + f441;
    f458 = f453 + f451;
    f459 = MUL_C(COEF_CONST((-0.7856949583871021)), f453);
    f460 = MUL_C(COEF_CONST(0.9807852804032304), f458);
    f461 = MUL_C(COEF_CONST(1.1758756024193588), f451);
    f462 = f459 + f460;
    f463 = f461 - f460;
    f464 = f457 + f455;
    f465 = MUL_C(COEF_CONST(0.2758993792829431), f457);
    f466 = MUL_C(COEF_CONST(0.5555702330196022), f464);
    f467 = MUL_C(COEF_CONST(1.3870398453221475), f455);
    f468 = f465 + f466;
    f469 = f467 - f466;
    f470 = f452 + f450;
    f471 = MUL_C(COEF_CONST(1.1758756024193591), f452);
    f472 = MUL_C(COEF_CONST((-0.1950903220161287)), f470);
    f473 = MUL_C(COEF_CONST(0.7856949583871016), f450);
    f474 = f471 + f472;
    f475 = f473 - f472;
    f476 = f456 - f454;
    f477 = MUL_C(COEF_CONST(1.3870398453221473), f456);
    f478 = MUL_C(COEF_CONST((-0.8314696123025455)), f476);
    f479 = MUL_C(COEF_CONST((-0.2758993792829436)), f454);
    f480 = f477 + f478;
    f481 = f478 + f479;
    f482 = f443 - f462;
    f483 = f443 + f462;
    f484 = f445 - f463;
    f485 = f445 + f463;
    f486 = f447 - f468;
    f487 = f447 + f468;
    f488 = f449 - f469;
    f489 = f449 + f469;
    f490 = f442 - f474;
    f491 = f442 + f474;
    f492 = f444 + f475;
    f493 = f475 - f444;
    f494 = f446 - f480;
    f495 = f446 + f480;
    f496 = f448 + f481;
    f497 = f448 - f481;
    f498 = f485 + f483;
    f499 = MUL_C(COEF_CONST((-0.9497277818777543)), f485);
    f500 = MUL_C(COEF_CONST(0.9987954562051724), f498);
    f501 = MUL_C(COEF_CONST(1.0478631305325905), f483);
    y[61] = f499 + f500;
    y[1] = f501 - f500;
    f504 = f489 + f487;
    f505 = MUL_C(COEF_CONST((-0.7270510732912801)), f489);
    f506 = MUL_C(COEF_CONST(0.9700312531945440), f504);
    f507 = MUL_C(COEF_CONST(1.2130114330978079), f487);
    y[53] = f505 + f506;
    y[9] = f507 - f506;
    f510 = f493 + f491;
    f511 = MUL_C(COEF_CONST((-0.4764341996931611)), f493);
    f512 = MUL_C(COEF_CONST(0.9039892931234433), f510);
    f513 = MUL_C(COEF_CONST(1.3315443865537255), f491);
    y[45] = f511 + f512;
    y[17] = f513 - f512;
    f516 = f497 + f495;
    f517 = MUL_C(COEF_CONST((-0.2075082269882114)), f497);
    f518 = MUL_C(COEF_CONST(0.8032075314806448), f516);
    f519 = MUL_C(COEF_CONST(1.3989068359730783), f495);
    y[37] = f517 + f518;
    y[25] = f519 - f518;
    f522 = f484 + f482;
    f523 = MUL_C(COEF_CONST(0.0693921705079408), f484);
    f524 = MUL_C(COEF_CONST(0.6715589548470183), f522);
    f525 = MUL_C(COEF_CONST(1.4125100802019774), f482);
    y[29] = f523 + f524;
    y[33] = f525 - f524;
    f528 = f488 + f486;
    f529 = MUL_C(COEF_CONST(0.3436258658070505), f488);
    f530 = MUL_C(COEF_CONST(0.5141027441932217), f528);
    f531 = MUL_C(COEF_CONST(1.3718313541934939), f486);
    y[21] = f529 + f530;
    y[41] = f531 - f530;
    f534 = f490 - f492;
    f535 = MUL_C(COEF_CONST(0.6046542117908007), f492);
    f536 = MUL_C(COEF_CONST(0.3368898533922201), f534);
    f537 = MUL_C(COEF_CONST(1.2784339185752409), f490);
    y[13] = f536 - f535;
    y[49] = f537 - f536;
    f540 = f496 + f494;
    f541 = MUL_C(COEF_CONST(0.8424460355094192), f496);
    f542 = MUL_C(COEF_CONST(0.1467304744553618), f540);
    f543 = MUL_C(COEF_CONST(1.1359069844201428), f494);
    y[5] = f541 + f542;
    y[57] = f543 - f542;
    f546 = f354 + f384;
    f547 = f354 - f384;
    f548 = f356 + f382;
    f549 = f382 - f356;
    f550 = f358 + f380;
    f551 = f358 - f380;
    f552 = f360 + f378;
    f553 = f378 - f360;
    f554 = f362 + f376;
    f555 = f362 - f376;
    f556 = f364 + f374;
    f557 = f374 - f364;
    f558 = f366 + f372;
    f559 = f366 - f372;
    f560 = f368 + f370;
    f561 = f370 - f368;
    f562 = f547 - f561;
    f563 = f547 + f561;
    f564 = f549 - f559;
    f565 = f549 + f559;
    f566 = f551 - f557;
    f567 = f551 + f557;
    f568 = f553 - f555;
    f569 = f553 + f555;
    f570 = f563 - f569;
    f571 = f563 + f569;
    f572 = f565 - f567;
    f573 = f565 + f567;
    f574 = f571 - f573;
    y[63] = f571 + f573;
    y[31] = MUL_C(COEF_CONST(0.7071067811865476), f574);
    f577 = f570 + f572;
    f578 = MUL_C(COEF_CONST(1.3065629648763766), f570);
    f579 = MUL_C(COEF_CONST((-0.9238795325112866)), f577);
    f580 = MUL_C(COEF_CONST((-0.5411961001461967)), f572);
    y[15] = f578 + f579;
    y[47] = f580 - f579;
    f583 = f564 + f562;
    f584 = f566 + f564;
    f585 = f568 + f566;
    f586 = MUL_C(COEF_CONST(0.7071067811865476), f584);
    f587 = f562 - f586;
    f588 = f562 + f586;
    f589 = f583 + f585;
    f590 = MUL_C(COEF_CONST(1.3065629648763766), f583);
    f591 = MUL_C(COEF_CONST((-0.9238795325112866)), f589);
    f592 = MUL_C(COEF_CONST((-0.5411961001461967)), f585);
    f593 = f590 + f591;
    f594 = f592 - f591;
    f595 = f588 - f594;
    f596 = f588 + f594;
    f597 = f587 - f593;
    f598 = f587 + f593;
    y[55] = MUL_C(COEF_CONST(0.5097955791041592), f596);
    y[39] = MUL_C(COEF_CONST(0.6013448869350453), f598);
    y[23] = MUL_C(COEF_CONST(0.8999762231364156), f597);
    y[7] = MUL_C(COEF_CONST(2.5629154477415055), f595);
    f603 = MUL_C(COEF_CONST(0.5024192861881557), f546);
    f604 = MUL_C(COEF_CONST(0.5224986149396889), f548);
    f605 = MUL_C(COEF_CONST(0.5669440348163577), f550);
    f606 = MUL_C(COEF_CONST(0.6468217833599901), f552);
    f607 = MUL_C(COEF_CONST(0.7881546234512502), f554);
    f608 = MUL_C(COEF_CONST(1.0606776859903471), f556);
    f609 = MUL_C(COEF_CONST(1.7224470982383342), f558);
    f610 = MUL_C(COEF_CONST(5.1011486186891553), f560);
    f611 = f603 + f610;
    f612 = f603 - f610;
    f613 = f604 + f609;
    f614 = f609 - f604;
    f615 = f605 + f608;
    f616 = f605 - f608;
    f617 = f606 + f607;
    f618 = f607 - f606;
    f619 = f612 - f618;
    f620 = f612 + f618;
    f621 = f614 - f616;
    f622 = f614 + f616;
    f623 = f620 - f622;
    f624 = f620 + f622;
    f625 = MUL_C(COEF_CONST(0.7071067811865476), f623);
    f626 = f619 + f621;
    f627 = MUL_C(COEF_CONST(1.3065629648763766), f619);
    f628 = MUL_C(COEF_CONST((-0.9238795325112866)), f626);
    f629 = MUL_C(COEF_CONST((-0.5411961001461967)), f621);
    f630 = f627 + f628;
    f631 = f629 - f628;
    f632 = f611 - f613;
    f633 = f615 - f613;
    f634 = f615 - f617;
    f635 = MUL_C(COEF_CONST(0.7071067811865476), f633);
    f636 = f611 - f635;
    f637 = f611 + f635;
    f638 = f632 + f634;
    f639 = MUL_C(COEF_CONST(1.3065629648763766), f632);
    f640 = MUL_C(COEF_CONST((-0.9238795325112866)), f638);
    f641 = MUL_C(COEF_CONST((-0.5411961001461967)), f634);
    f642 = f639 + f640;
    f643 = f641 - f640;
    f644 = f637 - f643;
    f645 = f637 + f643;
    f646 = f636 - f642;
    f647 = f636 + f642;
    f648 = MUL_C(COEF_CONST(0.5097955791041592), f645);
    f649 = MUL_C(COEF_CONST(0.6013448869350453), f647);
    f650 = MUL_C(COEF_CONST(0.8999762231364156), f646);
    y[3] = MUL_C(COEF_CONST(2.5629154477415055), f644);
    y[59] = f624 + f648;
    y[51] = f648 + f631;
    y[43] = f631 + f649;
    y[35] = f649 + f625;
    y[27] = f625 + f650;
    y[19] = f650 + f630;
    y[11] = f630 + y[3];
}

#else

void DCT4_64(real_t *y, real_t *x)
{
    int16_t i0;
    ALIGN static real_t t2[64];

    t2[0] = x[0];
    for (i0=0; i0<31; i0++)
    {
        t2[2*i0+1] = x[2*i0+1] - x[2*i0+2];
        t2[2*i0+2] = x[2*i0+1] + x[2*i0+2];
    }
    t2[63] = x[63];

    DCT4_64_kernel(y, t2);
}

void DCT4_64_kernel(real_t *y, real_t *t2)
{
    real_t f2, f3, f4, f5, f6, f7, f8;
    real_t f9, f10, f11, f12, f13, f14, f15;
    real_t f16, f17, f18, f19, f20, f21, f22;
    real_t f23, f24, f25, f26, f27, f28, f29;
    real_t f30, f31, f32, f33, f34, f35, f36;
    real_t f37, f38, f39, f40, f41, f42, f43;
    real_t f44, f45, f46, f47, f48, f49, f50;
    real_t f51, f52, f53, f54, f55, f56, f57;
    real_t f58, f59, f60, f61, f62, f63, f64;
    real_t f65, f66, f67, f68, f69, f70, f71;
    real_t f72, f73, f74, f75, f76, f77, f78;
    real_t f79, f80, f81, f82, f83, f84, f85;
    real_t f86, f87, f88, f89, f90, f91, f92;
    real_t f93, f94, f95, f96, f97, f98, f99;
    real_t f100, f101, f102, f103, f104, f105, f106;
    real_t f107, f108, f109, f110, f111, f112, f113;
    real_t f114, f115, f116, f117, f118, f119, f120;
    real_t f121, f122, f123, f124, f125, f126, f127;
    real_t f128, f129, f130, f131, f132, f133, f134;
    real_t f135, f136, f137, f138, f139, f140, f141;
    real_t f142, f143, f144, f145, f146, f147, f148;
    real_t f149, f150, f151, f152, f153, f154, f155;
    real_t f156, f157, f158, f159, f160, f161, f162;
    real_t f163, f164, f165, f166, f167, f168, f169;
    real_t f170, f171, f172, f173, f174, f175, f176;
    real_t f177, f178, f179, f180, f181, f182, f183;
    real_t f184, f185, f186, f187, f188, f189, f190;
    real_t f191, f192, f193, f194, f195, f196, f197;
    real_t f198, f199, f200, f201, f202, f203, f204;
    real_t f205, f206, f207, f208, f209, f210, f211;
    real_t f212, f213, f214, f215, f216, f217, f218;
    real_t f219, f220, f221, f222, f223, f224, f225;
    real_t f226, f227, f228, f229, f230, f231, f232;
    real_t f233, f234, f235, f236, f237, f238, f239;
    real_t f240, f241, f242, f243, f244, f245, f246;
    real_t f247, f248, f249, f250, f251, f252, f253;
    real_t f254, f255, f256, f257, f258, f259, f260;
    real_t f261, f262, f263, f264, f265, f266, f267;
    real_t f268, f269, f270, f271, f272, f273, f274;
    real_t f275, f276, f277, f278, f279, f280, f281;
    real_t f282, f283, f284, f285, f286, f287, f288;
    real_t f289, f290, f291, f292, f293, f294, f295;
    real_t f296, f297, f298, f299, f300, f301, f302;
    real_t f303, f304, f305, f306, f307, f308, f309;
    real_t f310, f311, f312, f313, f314, f315, f316;
    real_t f317, f318, f319, f320, f321, f322, f323;
    real_t f324, f325, f326, f327, f328, f329, f330;
    real_t f331, f332, f333, f334, f335, f336, f337;
    real_t f338, f339, f340, f341, f342, f343, f344;
    real_t f345, f346, f347, f348, f349, f350, f351;
    real_t f352, f353, f354, f355, f356, f357, f358;
    real_t f359, f360, f361, f362, f363, f364, f365;
    real_t f366, f367, f368, f369, f370, f371, f372;
    real_t f373, f374, f375, f376, f377, f378, f379;
    real_t f380, f381, f382, f383, f384, f385, f386;
    real_t f387, f388, f389, f390, f391, f392, f393;
    real_t f394, f395, f396, f397, f398, f399, f400;
    real_t f401, f402, f403, f404, f405, f406, f407;
    real_t f408, f409, f410, f411, f412, f413, f414;
    real_t f415, f416, f417, f418, f419, f420, f421;
    real_t f422, f423, f424, f425, f426, f427, f428;
    real_t f429, f430, f431, f432, f433, f434, f435;
    real_t f436, f437, f438, f439, f440, f441, f442;
    real_t f443, f444, f445, f446, f447, f448, f449;
    real_t f450, f451, f452, f453, f454, f455, f456;
    real_t f457, f458, f459, f460, f461, f462, f463;
    real_t f464, f465, f466, f467, f468, f469, f470;
    real_t f471, f472, f473, f474, f475, f476, f477;
    real_t f478, f479, f480, f481, f482, f483, f484;
    real_t f485, f486, f487, f488, f489, f490, f491;
    real_t f492, f493, f494, f495, f496, f497, f498;
    real_t f499, f500, f501, f502, f503, f504, f505;
    real_t f506, f507, f508, f509, f510, f511, f512;
    real_t f513, f514, f515, f516, f517, f518, f519;
    real_t f520, f521, f522, f523, f524, f525, f526;
    real_t f527, f528, f529, f530, f531, f532, f533;
    real_t f534, f535, f536, f537, f538, f539, f540;
    real_t f541, f542, f543, f544, f545, f546, f547;
    real_t f548, f549, f550, f551, f552, f553, f554;
    real_t f555, f556, f557, f558, f559, f560, f561;
    real_t f562, f563, f564, f565, f566, f567, f568;
    real_t f569, f570, f571, f572, f573, f574, f575;
    real_t f576, f577, f578, f579, f580, f581, f582;
    real_t f583, f584, f585, f586, f587, f588, f589;
    real_t f590, f591, f592, f593, f594, f595, f596;
    real_t f597, f598, f599, f600, f601, f602, f603;
    real_t f604, f605, f606, f607, f608, f609, f610;
    real_t f611, f612, f613, f614, f615, f618, f619;
    real_t f620, f621, f624, f625, f626, f627, f630;
    real_t f631, f632, f633, f636, f637, f638, f639;
    real_t f642, f643, f644, f645, f648, f649, f650;
    real_t f651, f654, f655, f656, f657, f660, f661;
    real_t f662, f663, f666, f667, f668, f669, f672;
    real_t f673, f674, f675, f678, f679, f680, f681;
    real_t f684, f685, f686, f687, f690, f691, f692;
    real_t f693, f696, f697, f698, f699, f702, f703;
    real_t f704, f705, f708, f709, f710, f711, f714;
    real_t f715, f716, f717, f720, f721, f722, f723;
    real_t f726, f727, f728, f729, f732, f733, f734;
    real_t f735, f738, f739, f740, f741, f744, f745;
    real_t f746, f747, f750, f751, f752, f753, f756;
    real_t f757, f758, f759, f762, f763, f764, f765;
    real_t f768, f769, f770, f771, f774, f775, f776;
    real_t f777, f780, f781, f782, f783, f786, f787;
    real_t f788, f789, f792, f793, f794, f795, f798;
    real_t f799, f800, f801;

    f2 = 0.7071067811865476 * t2[32];
    f3 = t2[0] - f2;
    f4 = t2[0] + f2;
    f5 = t2[16] + t2[48];
    f6 = 1.3065629648763766 * t2[16];
    f7 = (-0.9238795325112866) * f5;
    f8 = (-0.5411961001461967) * t2[48];
    f9 = f6 + f7;
    f10 = f8 - f7;
    f11 = f4 - f10;
    f12 = f4 + f10;
    f13 = f3 - f9;
    f14 = f3 + f9;
    f15 = t2[8] + t2[56];
    f16 = 1.1758756024193588 * t2[8];
    f17 = (-0.9807852804032304) * f15;
    f18 = (-0.7856949583871021) * t2[56];
    f19 = f16 + f17;
    f20 = f18 - f17;
    f21 = t2[24] + t2[40];
    f22 = 1.3870398453221473 * t2[24];
    f23 = (-0.8314696123025455) * f21;
    f24 = (-0.2758993792829436) * t2[40];
    f25 = f22 + f23;
    f26 = f24 - f23;
    f27 = f20 - f26;
    f28 = f20 + f26;
    f29 = 0.7071067811865476 * f27;
    f30 = f19 - f25;
    f31 = f19 + f25;
    f32 = 0.7071067811865476 * f31;
    f33 = f29 - f32;
    f34 = f29 + f32;
    f35 = f12 - f28;
    f36 = f12 + f28;
    f37 = f14 - f34;
    f38 = f14 + f34;
    f39 = f13 - f33;
    f40 = f13 + f33;
    f41 = f11 - f30;
    f42 = f11 + f30;
    f43 = t2[4] + t2[60];
    f44 = 1.0932018670017569 * t2[4];
    f45 = (-0.9951847266721969) * f43;
    f46 = (-0.8971675863426368) * t2[60];
    f47 = f44 + f45;
    f48 = f46 - f45;
    f49 = t2[12] + t2[52];
    f50 = 1.2472250129866711 * t2[12];
    f51 = (-0.9569403357322089) * f49;
    f52 = (-0.6666556584777469) * t2[52];
    f53 = f50 + f51;
    f54 = f52 - f51;
    f55 = t2[20] + t2[44];
    f56 = 1.3533180011743526 * t2[20];
    f57 = (-0.8819212643483551) * f55;
    f58 = (-0.4105245275223575) * t2[44];
    f59 = f56 + f57;
    f60 = f58 - f57;
    f61 = t2[28] + t2[36];
    f62 = 1.4074037375263826 * t2[28];
    f63 = (-0.7730104533627369) * f61;
    f64 = (-0.1386171691990913) * t2[36];
    f65 = f62 + f63;
    f66 = f64 - f63;
    f67 = f48 - f66;
    f68 = f48 + f66;
    f69 = f54 - f60;
    f70 = f54 + f60;
    f71 = f68 - f70;
    f72 = f68 + f70;
    f73 = 0.7071067811865476 * f71;
    f74 = f67 + f69;
    f75 = 1.3065629648763766 * f67;
    f76 = (-0.9238795325112866) * f74;
    f77 = (-0.5411961001461967) * f69;
    f78 = f75 + f76;
    f79 = f77 - f76;
    f80 = f47 - f65;
    f81 = f47 + f65;
    f82 = f53 - f59;
    f83 = f53 + f59;
    f84 = f81 + f83;
    f85 = 1.3065629648763770 * f81;
    f86 = (-0.3826834323650904) * f84;
    f87 = 0.5411961001461961 * f83;
    f88 = f85 + f86;
    f89 = f87 - f86;
    f90 = f80 - f82;
    f91 = f80 + f82;
    f92 = 0.7071067811865476 * f91;
    f93 = f79 - f89;
    f94 = f79 + f89;
    f95 = f73 - f92;
    f96 = f73 + f92;
    f97 = f78 - f88;
    f98 = f78 + f88;
    f99 = f36 - f72;
    f100 = f36 + f72;
    f101 = f38 - f94;
    f102 = f38 + f94;
    f103 = f40 - f93;
    f104 = f40 + f93;
    f105 = f42 - f96;
    f106 = f42 + f96;
    f107 = f41 - f95;
    f108 = f41 + f95;
    f109 = f39 - f98;
    f110 = f39 + f98;
    f111 = f37 - f97;
    f112 = f37 + f97;
    f113 = f35 - f90;
    f114 = f35 + f90;
    f115 = t2[2] + t2[62];
    f116 = 1.0478631305325901 * t2[2];
    f117 = (-0.9987954562051724) * f115;
    f118 = (-0.9497277818777548) * t2[62];
    f119 = f116 + f117;
    f120 = f118 - f117;
    f121 = t2[10] + t2[54];
    f122 = 1.2130114330978077 * t2[10];
    f123 = (-0.9700312531945440) * f121;
    f124 = (-0.7270510732912803) * t2[54];
    f125 = f122 + f123;
    f126 = f124 - f123;
    f127 = t2[18] + t2[46];
    f128 = 1.3315443865537255 * t2[18];
    f129 = (-0.9039892931234433) * f127;
    f130 = (-0.4764341996931612) * t2[46];
    f131 = f128 + f129;
    f132 = f130 - f129;
    f133 = t2[26] + t2[38];
    f134 = 1.3989068359730781 * t2[26];
    f135 = (-0.8032075314806453) * f133;
    f136 = (-0.2075082269882124) * t2[38];
    f137 = f134 + f135;
    f138 = f136 - f135;
    f139 = t2[34] + t2[30];
    f140 = 1.4125100802019777 * t2[34];
    f141 = (-0.6715589548470187) * f139;
    f142 = 0.0693921705079402 * t2[30];
    f143 = f140 + f141;
    f144 = f142 - f141;
    f145 = t2[42] + t2[22];
    f146 = 1.3718313541934939 * t2[42];
    f147 = (-0.5141027441932219) * f145;
    f148 = 0.3436258658070501 * t2[22];
    f149 = f146 + f147;
    f150 = f148 - f147;
    f151 = t2[50] + t2[14];
    f152 = 1.2784339185752409 * t2[50];
    f153 = (-0.3368898533922200) * f151;
    f154 = 0.6046542117908008 * t2[14];
    f155 = f152 + f153;
    f156 = f154 - f153;
    f157 = t2[58] + t2[6];
    f158 = 1.1359069844201433 * t2[58];
    f159 = (-0.1467304744553624) * f157;
    f160 = 0.8424460355094185 * t2[6];
    f161 = f158 + f159;
    f162 = f160 - f159;
    f163 = f120 - f144;
    f164 = f120 + f144;
    f165 = f119 - f143;
    f166 = f119 + f143;
    f167 = f126 - f150;
    f168 = f126 + f150;
    f169 = f125 - f149;
    f170 = f125 + f149;
    f171 = f132 - f156;
    f172 = f132 + f156;
    f173 = f131 - f155;
    f174 = f131 + f155;
    f175 = f138 - f162;
    f176 = f138 + f162;
    f177 = f137 - f161;
    f178 = f137 + f161;
    f179 = f163 + f165;
    f180 = 1.1758756024193588 * f163;
    f181 = (-0.9807852804032304) * f179;
    f182 = (-0.7856949583871021) * f165;
    f183 = f180 + f181;
    f184 = f182 - f181;
    f185 = f167 + f169;
    f186 = 1.3870398453221475 * f167;
    f187 = (-0.5555702330196022) * f185;
    f188 = 0.2758993792829431 * f169;
    f189 = f186 + f187;
    f190 = f188 - f187;
    f191 = f171 + f173;
    f192 = 0.7856949583871022 * f171;
    f193 = 0.1950903220161283 * f191;
    f194 = 1.1758756024193586 * f173;
    f195 = f192 + f193;
    f196 = f194 - f193;
    f197 = f175 + f177;
    f198 = (-0.2758993792829430) * f175;
    f199 = 0.8314696123025452 * f197;
    f200 = 1.3870398453221475 * f177;
    f201 = f198 + f199;
    f202 = f200 - f199;
    f203 = f164 - f172;
    f204 = f164 + f172;
    f205 = f166 - f174;
    f206 = f166 + f174;
    f207 = f168 - f176;
    f208 = f168 + f176;
    f209 = f170 - f178;
    f210 = f170 + f178;
    f211 = f184 - f196;
    f212 = f184 + f196;
    f213 = f183 - f195;
    f214 = f183 + f195;
    f215 = f190 - f202;
    f216 = f190 + f202;
    f217 = f189 - f201;
    f218 = f189 + f201;
    f219 = f203 + f205;
    f220 = 1.3065629648763766 * f203;
    f221 = (-0.9238795325112866) * f219;
    f222 = (-0.5411961001461967) * f205;
    f223 = f220 + f221;
    f224 = f222 - f221;
    f225 = f207 + f209;
    f226 = 0.5411961001461969 * f207;
    f227 = 0.3826834323650898 * f225;
    f228 = 1.3065629648763766 * f209;
    f229 = f226 + f227;
    f230 = f228 - f227;
    f231 = f211 + f213;
    f232 = 1.3065629648763766 * f211;
    f233 = (-0.9238795325112866) * f231;
    f234 = (-0.5411961001461967) * f213;
    f235 = f232 + f233;
    f236 = f234 - f233;
    f237 = f215 + f217;
    f238 = 0.5411961001461969 * f215;
    f239 = 0.3826834323650898 * f237;
    f240 = 1.3065629648763766 * f217;
    f241 = f238 + f239;
    f242 = f240 - f239;
    f243 = f204 - f208;
    f244 = f204 + f208;
    f245 = f206 - f210;
    f246 = f206 + f210;
    f247 = f224 - f230;
    f248 = f224 + f230;
    f249 = f223 - f229;
    f250 = f223 + f229;
    f251 = f212 - f216;
    f252 = f212 + f216;
    f253 = f214 - f218;
    f254 = f214 + f218;
    f255 = f236 - f242;
    f256 = f236 + f242;
    f257 = f235 - f241;
    f258 = f235 + f241;
    f259 = f243 - f245;
    f260 = f243 + f245;
    f261 = 0.7071067811865474 * f259;
    f262 = 0.7071067811865474 * f260;
    f263 = f247 - f249;
    f264 = f247 + f249;
    f265 = 0.7071067811865474 * f263;
    f266 = 0.7071067811865474 * f264;
    f267 = f251 - f253;
    f268 = f251 + f253;
    f269 = 0.7071067811865474 * f267;
    f270 = 0.7071067811865474 * f268;
    f271 = f255 - f257;
    f272 = f255 + f257;
    f273 = 0.7071067811865474 * f271;
    f274 = 0.7071067811865474 * f272;
    f275 = f100 - f244;
    f276 = f100 + f244;
    f277 = f102 - f252;
    f278 = f102 + f252;
    f279 = f104 - f256;
    f280 = f104 + f256;
    f281 = f106 - f248;
    f282 = f106 + f248;
    f283 = f108 - f266;
    f284 = f108 + f266;
    f285 = f110 - f274;
    f286 = f110 + f274;
    f287 = f112 - f270;
    f288 = f112 + f270;
    f289 = f114 - f262;
    f290 = f114 + f262;
    f291 = f113 - f261;
    f292 = f113 + f261;
    f293 = f111 - f269;
    f294 = f111 + f269;
    f295 = f109 - f273;
    f296 = f109 + f273;
    f297 = f107 - f265;
    f298 = f107 + f265;
    f299 = f105 - f250;
    f300 = f105 + f250;
    f301 = f103 - f258;
    f302 = f103 + f258;
    f303 = f101 - f254;
    f304 = f101 + f254;
    f305 = f99 - f246;
    f306 = f99 + f246;
    f307 = t2[1] - t2[61];
    f308 = 1.0478631305325901 * t2[1];
    f309 = (-0.9987954562051724) * f307;
    f310 = (-0.9497277818777548) * t2[61];
    f311 = f308 + f309;
    f312 = f309 + f310;
    f313 = t2[9] - t2[53];
    f314 = 1.2130114330978077 * t2[9];
    f315 = (-0.9700312531945440) * f313;
    f316 = (-0.7270510732912803) * t2[53];
    f317 = f314 + f315;
    f318 = f315 + f316;
    f319 = t2[17] - t2[45];
    f320 = 1.3315443865537255 * t2[17];
    f321 = (-0.9039892931234433) * f319;
    f322 = (-0.4764341996931612) * t2[45];
    f323 = f320 + f321;
    f324 = f321 + f322;
    f325 = t2[25] - t2[37];
    f326 = 1.3989068359730781 * t2[25];
    f327 = (-0.8032075314806453) * f325;
    f328 = (-0.2075082269882124) * t2[37];
    f329 = f326 + f327;
    f330 = f327 + f328;
    f331 = t2[33] - t2[29];
    f332 = 1.4125100802019777 * t2[33];
    f333 = (-0.6715589548470187) * f331;
    f334 = 0.0693921705079402 * t2[29];
    f335 = f332 + f333;
    f336 = f333 + f334;
    f337 = t2[41] - t2[21];
    f338 = 1.3718313541934939 * t2[41];
    f339 = (-0.5141027441932219) * f337;
    f340 = 0.3436258658070501 * t2[21];
    f341 = f338 + f339;
    f342 = f339 + f340;
    f343 = t2[49] - t2[13];
    f344 = 1.2784339185752409 * t2[49];
    f345 = (-0.3368898533922200) * f343;
    f346 = 0.6046542117908008 * t2[13];
    f347 = f344 + f345;
    f348 = f345 + f346;
    f349 = t2[57] - t2[5];
    f350 = 1.1359069844201433 * t2[57];
    f351 = (-0.1467304744553624) * f349;
    f352 = 0.8424460355094185 * t2[5];
    f353 = f350 + f351;
    f354 = f351 + f352;
    f355 = f336 - f312;
    f356 = f312 + f336;
    f357 = f311 - f335;
    f358 = f311 + f335;
    f359 = f342 - f318;
    f360 = f318 + f342;
    f361 = f317 - f341;
    f362 = f317 + f341;
    f363 = f348 - f324;
    f364 = f324 + f348;
    f365 = f323 - f347;
    f366 = f323 + f347;
    f367 = f354 - f330;
    f368 = f330 + f354;
    f369 = f329 - f353;
    f370 = f329 + f353;
    f371 = f355 + f357;
    f372 = 1.1758756024193588 * f355;
    f373 = (-0.9807852804032304) * f371;
    f374 = (-0.7856949583871021) * f357;
    f375 = f372 + f373;
    f376 = f374 - f373;
    f377 = f359 + f361;
    f378 = 1.3870398453221475 * f359;
    f379 = (-0.5555702330196022) * f377;
    f380 = 0.2758993792829431 * f361;
    f381 = f378 + f379;
    f382 = f380 - f379;
    f383 = f363 + f365;
    f384 = 0.7856949583871022 * f363;
    f385 = 0.1950903220161283 * f383;
    f386 = 1.1758756024193586 * f365;
    f387 = f384 + f385;
    f388 = f386 - f385;
    f389 = f367 + f369;
    f390 = (-0.2758993792829430) * f367;
    f391 = 0.8314696123025452 * f389;
    f392 = 1.3870398453221475 * f369;
    f393 = f390 + f391;
    f394 = f392 - f391;
    f395 = f364 - f356;
    f396 = f356 + f364;
    f397 = f358 - f366;
    f398 = f358 + f366;
    f399 = f368 - f360;
    f400 = f360 + f368;
    f401 = f362 - f370;
    f402 = f362 + f370;
    f403 = f376 - f388;
    f404 = f376 + f388;
    f405 = f375 - f387;
    f406 = f375 + f387;
    f407 = f382 - f394;
    f408 = f382 + f394;
    f409 = f381 - f393;
    f410 = f381 + f393;
    f411 = f395 + f397;
    f412 = 1.3065629648763766 * f395;
    f413 = (-0.9238795325112866) * f411;
    f414 = (-0.5411961001461967) * f397;
    f415 = f412 + f413;
    f416 = f414 - f413;
    f417 = f399 + f401;
    f418 = 0.5411961001461969 * f399;
    f419 = 0.3826834323650898 * f417;
    f420 = 1.3065629648763766 * f401;
    f421 = f418 + f419;
    f422 = f420 - f419;
    f423 = f403 + f405;
    f424 = 1.3065629648763766 * f403;
    f425 = (-0.9238795325112866) * f423;
    f426 = (-0.5411961001461967) * f405;
    f427 = f424 + f425;
    f428 = f426 - f425;
    f429 = f407 + f409;
    f430 = 0.5411961001461969 * f407;
    f431 = 0.3826834323650898 * f429;
    f432 = 1.3065629648763766 * f409;
    f433 = f430 + f431;
    f434 = f432 - f431;
    f435 = f400 - f396;
    f436 = f396 + f400;
    f437 = f398 - f402;
    f438 = f398 + f402;
    f439 = f416 - f422;
    f440 = f416 + f422;
    f441 = f415 - f421;
    f442 = f415 + f421;
    f443 = f404 - f408;
    f444 = f404 + f408;
    f445 = f406 - f410;
    f446 = f406 + f410;
    f447 = f428 - f434;
    f448 = f428 + f434;
    f449 = f427 - f433;
    f450 = f427 + f433;
    f451 = f435 - f437;
    f452 = f435 + f437;
    f453 = 0.7071067811865474 * f451;
    f454 = 0.7071067811865474 * f452;
    f455 = f439 - f441;
    f456 = f439 + f441;
    f457 = 0.7071067811865474 * f455;
    f458 = 0.7071067811865474 * f456;
    f459 = f443 - f445;
    f460 = f443 + f445;
    f461 = 0.7071067811865474 * f459;
    f462 = 0.7071067811865474 * f460;
    f463 = f447 - f449;
    f464 = f447 + f449;
    f465 = 0.7071067811865474 * f463;
    f466 = 0.7071067811865474 * f464;
    f467 = 0.7071067811865476 * t2[31];
    f468 = t2[63] - f467;
    f469 = t2[63] + f467;
    f470 = t2[47] + t2[15];
    f471 = 1.3065629648763766 * t2[47];
    f472 = (-0.9238795325112866) * f470;
    f473 = (-0.5411961001461967) * t2[15];
    f474 = f471 + f472;
    f475 = f473 - f472;
    f476 = f469 - f475;
    f477 = f469 + f475;
    f478 = f468 - f474;
    f479 = f468 + f474;
    f480 = t2[55] + t2[7];
    f481 = 1.1758756024193588 * t2[55];
    f482 = (-0.9807852804032304) * f480;
    f483 = (-0.7856949583871021) * t2[7];
    f484 = f481 + f482;
    f485 = f483 - f482;
    f486 = t2[39] + t2[23];
    f487 = 1.3870398453221473 * t2[39];
    f488 = (-0.8314696123025455) * f486;
    f489 = (-0.2758993792829436) * t2[23];
    f490 = f487 + f488;
    f491 = f489 - f488;
    f492 = f485 - f491;
    f493 = f485 + f491;
    f494 = 0.7071067811865476 * f492;
    f495 = f484 - f490;
    f496 = f484 + f490;
    f497 = 0.7071067811865476 * f496;
    f498 = f494 - f497;
    f499 = f494 + f497;
    f500 = f477 - f493;
    f501 = f477 + f493;
    f502 = f479 - f499;
    f503 = f479 + f499;
    f504 = f478 - f498;
    f505 = f478 + f498;
    f506 = f476 - f495;
    f507 = f476 + f495;
    f508 = t2[59] + t2[3];
    f509 = 1.0932018670017569 * t2[59];
    f510 = (-0.9951847266721969) * f508;
    f511 = (-0.8971675863426368) * t2[3];
    f512 = f509 + f510;
    f513 = f511 - f510;
    f514 = t2[51] + t2[11];
    f515 = 1.2472250129866711 * t2[51];
    f516 = (-0.9569403357322089) * f514;
    f517 = (-0.6666556584777469) * t2[11];
    f518 = f515 + f516;
    f519 = f517 - f516;
    f520 = t2[43] + t2[19];
    f521 = 1.3533180011743526 * t2[43];
    f522 = (-0.8819212643483551) * f520;
    f523 = (-0.4105245275223575) * t2[19];
    f524 = f521 + f522;
    f525 = f523 - f522;
    f526 = t2[35] + t2[27];
    f527 = 1.4074037375263826 * t2[35];
    f528 = (-0.7730104533627369) * f526;
    f529 = (-0.1386171691990913) * t2[27];
    f530 = f527 + f528;
    f531 = f529 - f528;
    f532 = f513 - f531;
    f533 = f513 + f531;
    f534 = f519 - f525;
    f535 = f519 + f525;
    f536 = f533 - f535;
    f537 = f533 + f535;
    f538 = 0.7071067811865476 * f536;
    f539 = f532 + f534;
    f540 = 1.3065629648763766 * f532;
    f541 = (-0.9238795325112866) * f539;
    f542 = (-0.5411961001461967) * f534;
    f543 = f540 + f541;
    f544 = f542 - f541;
    f545 = f512 - f530;
    f546 = f512 + f530;
    f547 = f518 - f524;
    f548 = f518 + f524;
    f549 = f546 + f548;
    f550 = 1.3065629648763770 * f546;
    f551 = (-0.3826834323650904) * f549;
    f552 = 0.5411961001461961 * f548;
    f553 = f550 + f551;
    f554 = f552 - f551;
    f555 = f545 - f547;
    f556 = f545 + f547;
    f557 = 0.7071067811865476 * f556;
    f558 = f544 - f554;
    f559 = f544 + f554;
    f560 = f538 - f557;
    f561 = f538 + f557;
    f562 = f543 - f553;
    f563 = f543 + f553;
    f564 = f501 - f537;
    f565 = f501 + f537;
    f566 = f503 - f559;
    f567 = f503 + f559;
    f568 = f505 - f558;
    f569 = f505 + f558;
    f570 = f507 - f561;
    f571 = f507 + f561;
    f572 = f506 - f560;
    f573 = f506 + f560;
    f574 = f504 - f563;
    f575 = f504 + f563;
    f576 = f502 - f562;
    f577 = f502 + f562;
    f578 = f500 - f555;
    f579 = f500 + f555;
    f580 = f438 - f565;
    f581 = f438 + f565;
    f582 = f446 + f567;
    f583 = f446 - f567;
    f584 = f450 - f569;
    f585 = f450 + f569;
    f586 = f442 + f571;
    f587 = f442 - f571;
    f588 = f457 - f573;
    f589 = f457 + f573;
    f590 = f465 + f575;
    f591 = f465 - f575;
    f592 = f461 - f577;
    f593 = f461 + f577;
    f594 = f453 + f579;
    f595 = f453 - f579;
    f596 = f454 - f578;
    f597 = f454 + f578;
    f598 = f462 + f576;
    f599 = f462 - f576;
    f600 = f466 - f574;
    f601 = f466 + f574;
    f602 = f458 + f572;
    f603 = f458 - f572;
    f604 = f440 - f570;
    f605 = f440 + f570;
    f606 = f448 + f568;
    f607 = f448 - f568;
    f608 = f444 - f566;
    f609 = f444 + f566;
    f610 = f564 - f436;
    f611 = f436 + f564;
    f612 = f581 + f276;
    f613 = (-0.9876531635534246) * f581;
    f614 = 0.9999247018391445 * f612;
    f615 = 1.0121962401248645 * f276;
    y[0] = f613 + f614;
    y[63] = f615 - f614;
    f618 = f583 + f278;
    f619 = (-0.9625151616469906) * f583;
    f620 = 0.9993223845883495 * f618;
    f621 = 1.0361296075297086 * f278;
    y[1] = f619 + f620;
    y[62] = f621 - f620;
    f624 = f585 + f280;
    f625 = (-0.9367973765979405) * f585;
    f626 = 0.9981181129001492 * f624;
    f627 = 1.0594388492023579 * f280;
    y[2] = f625 + f626;
    y[61] = f627 - f626;
    f630 = f587 + f282;
    f631 = (-0.9105152998383381) * f587;
    f632 = 0.9963126121827780 * f630;
    f633 = 1.0821099245272179 * f282;
    y[3] = f631 + f632;
    y[60] = f633 - f632;
    f636 = f589 + f284;
    f637 = (-0.8836847627084729) * f589;
    f638 = 0.9939069700023561 * f636;
    f639 = 1.1041291772962392 * f284;
    y[4] = f637 + f638;
    y[59] = f639 - f638;
    f642 = f591 + f286;
    f643 = (-0.8563219269206538) * f591;
    f644 = 0.9909026354277800 * f642;
    f645 = 1.1254833439349063 * f286;
    y[5] = f643 + f644;
    y[58] = f645 - f644;
    f648 = f593 + f288;
    f649 = (-0.8284432748239970) * f593;
    f650 = 0.9873014181578584 * f648;
    f651 = 1.1461595614917197 * f288;
    y[6] = f649 + f650;
    y[57] = f651 - f650;
    f654 = f595 + f290;
    f655 = (-0.8000655994760753) * f595;
    f656 = 0.9831054874312163 * f654;
    f657 = 1.1661453753863573 * f290;
    y[7] = f655 + f656;
    y[56] = f657 - f656;
    f660 = f597 + f292;
    f661 = (-0.7712059945274091) * f597;
    f662 = 0.9783173707196277 * f660;
    f663 = 1.1854287469118463 * f292;
    y[8] = f661 + f662;
    y[55] = f663 - f662;
    f666 = f599 + f294;
    f667 = (-0.7418818439248888) * f599;
    f668 = 0.9729399522055601 * f666;
    f669 = 1.2039980604862313 * f294;
    y[9] = f667 + f668;
    y[54] = f669 - f668;
    f672 = f601 + f296;
    f673 = (-0.7121108114403374) * f601;
    f674 = 0.9669764710448521 * f672;
    f675 = 1.2218421306493668 * f296;
    y[10] = f673 + f674;
    y[53] = f675 - f674;
    f678 = f603 + f298;
    f679 = (-0.6819108300305128) * f603;
    f680 = 0.9604305194155658 * f678;
    f681 = 1.2389502088006188 * f298;
    y[11] = f679 + f680;
    y[52] = f681 - f680;
    f684 = f605 + f300;
    f685 = (-0.6513000910349656) * f605;
    f686 = 0.9533060403541938 * f684;
    f687 = 1.2553119896734219 * f300;
    y[12] = f685 + f686;
    y[51] = f687 - f686;
    f690 = f607 + f302;
    f691 = (-0.6202970332182582) * f607;
    f692 = 0.9456073253805213 * f690;
    f693 = 1.2709176175427843 * f302;
    y[13] = f691 + f692;
    y[50] = f693 - f692;
    f696 = f609 + f304;
    f697 = (-0.5889203316631404) * f609;
    f698 = 0.9373390119125750 * f696;
    f699 = 1.2857576921620095 * f304;
    y[14] = f697 + f698;
    y[49] = f699 - f698;
    f702 = f306 - f611;
    f703 = (-0.5571888865213779) * f611;
    f704 = 0.9285060804732155 * f702;
    f705 = 1.2998232744250531 * f306;
    y[15] = f704 - f703;
    y[48] = f705 - f704;
    f708 = f610 + f305;
    f709 = (-0.5251218116290097) * f610;
    f710 = 0.9191138516900578 * f708;
    f711 = 1.3131058917511058 * f305;
    y[16] = f709 + f710;
    y[47] = f711 - f710;
    f714 = f608 + f303;
    f715 = (-0.4927384229928850) * f608;
    f716 = 0.9091679830905223 * f714;
    f717 = 1.3255975431881595 * f303;
    y[17] = f715 + f716;
    y[46] = f717 - f716;
    f720 = f606 + f301;
    f721 = (-0.4600582271554261) * f606;
    f722 = 0.8986744656939538 * f720;
    f723 = 1.3372907042324815 * f301;
    y[18] = f721 + f722;
    y[45] = f723 - f722;
    f726 = f604 + f299;
    f727 = (-0.4271009094446139) * f604;
    f728 = 0.8876396204028539 * f726;
    f729 = 1.3481783313610940 * f299;
    y[19] = f727 + f728;
    y[44] = f729 - f728;
    f732 = f602 + f297;
    f733 = (-0.3938863221162838) * f602;
    f734 = 0.8760700941954066 * f732;
    f735 = 1.3582538662745294 * f297;
    y[20] = f733 + f734;
    y[43] = f735 - f734;
    f738 = f600 + f295;
    f739 = (-0.3604344723958691) * f600;
    f740 = 0.8639728561215867 * f738;
    f741 = 1.3675112398473042 * f295;
    y[21] = f739 + f740;
    y[42] = f741 - f740;
    f744 = f598 + f293;
    f745 = (-0.3267655104267964) * f598;
    f746 = 0.8513551931052652 * f744;
    f747 = 1.3759448757837340 * f293;
    y[22] = f745 + f746;
    y[41] = f747 - f746;
    f750 = f596 + f291;
    f751 = (-0.2928997171327915) * f596;
    f752 = 0.8382247055548380 * f750;
    f753 = 1.3835496939768843 * f291;
    y[23] = f751 + f752;
    y[40] = f753 - f752;
    f756 = f594 + f289;
    f757 = (-0.2588574920014121) * f594;
    f758 = 0.8245893027850253 * f756;
    f759 = 1.3903211135686386 * f289;
    y[24] = f757 + f758;
    y[39] = f759 - f758;
    f762 = f592 + f287;
    f763 = (-0.2246593407961559) * f592;
    f764 = 0.8104571982525948 * f762;
    f765 = 1.3962550557090336 * f287;
    y[25] = f763 + f764;
    y[38] = f765 - f764;
    f768 = f590 + f285;
    f769 = (-0.1903258632045579) * f590;
    f770 = 0.7958369046088835 * f768;
    f771 = 1.4013479460132090 * f285;
    y[26] = f769 + f770;
    y[37] = f771 - f770;
    f774 = f588 + f283;
    f775 = (-0.1558777404297079) * f588;
    f776 = 0.7807372285720944 * f774;
    f777 = 1.4055967167144807 * f283;
    y[27] = f775 + f776;
    y[36] = f777 - f776;
    f780 = f586 + f281;
    f781 = (-0.1213357227326675) * f586;
    f782 = 0.7651672656224590 * f780;
    f783 = 1.4089988085122505 * f281;
    y[28] = f781 + f782;
    y[35] = f783 - f782;
    f786 = f584 + f279;
    f787 = (-0.0867206169332875) * f584;
    f788 = 0.7491363945234593 * f786;
    f789 = 1.4115521721136310 * f279;
    y[29] = f787 + f788;
    y[34] = f789 - f788;
    f792 = f582 + f277;
    f793 = (-0.0520532738769597) * f582;
    f794 = 0.7326542716724128 * f792;
    f795 = 1.4132552694678659 * f277;
    y[30] = f793 + f794;
    y[33] = f795 - f794;
    f798 = f580 + f275;
    f799 = (-0.0173545758748457) * f580;
    f800 = 0.7157308252838186 * f798;
    f801 = 1.4141070746927915 * f275;
    y[31] = f799 + f800;
    y[32] = f801 - f800;
}

#endif

#endif

