.\"
.\" "$Id: lp.man,v 1.15 2005/01/03 19:29:58 mike Exp $"
.\"
.\"   lp/cancel man page for the Common UNIX Printing System (CUPS).
.\"
.\"   Copyright 1997-2005 by Easy Software Products.
.\"
.\"   These coded instructions, statements, and computer programs are the
.\"   property of Easy Software Products and are protected by Federal
.\"   copyright law.  Distribution and use rights are outlined in the file
.\"   "LICENSE.txt" which should have been included with this file.  If this
.\"   file is missing or damaged please contact Easy Software Products
.\"   at:
.\"
.\"       Attn: CUPS Licensing Information
.\"       Easy Software Products
.\"       44141 Airport View Drive, Suite 204
.\"       Hollywood, Maryland 20636 USA
.\"
.\"       Voice: (301) 373-9600
.\"       EMail: cups-info@cups.org
.\"         WWW: http://www.cups.org
.\"
.TH lp 1 "Common UNIX Printing System" "1 May 2003" "Easy Software Products"
.SH NAME
lp \- print files
.br
cancel \- cancel jobs
.SH SYNOPSIS
.B lp
[ -E ] [ \-c ] [ \-d
.I destination
] [ \-h
.I server
] [ \-m ] [ \-n
.I num-copies
[ \-o
.I option
] [ \-q
.I priority
] [ \-s ] [ \-t
.I title
] [ \-H
.I handling
] [ \-P
.I page-list
] [
.I file(s)
]
.br
.B lp
[ -E ] [ \-c ] [ \-h
.I server
] [ \-i
.I job-id
] [ \-n
.I num-copies
[ \-o
.I option
] [ \-q
.I priority
] [ \-t
.I title
] [ \-H
.I handling
] [ \-P
.I page-list
]
.br
.B cancel
[ \-a ] [ -h
.I server
] [ -u 
.I username
] [
.I id
] [
.I destination
] [
.I destination-id
]
.SH DESCRIPTION
\fBlp\fR submits files for printing or alters a pending job. Use
a filename of "-" to force printing from the standard input.
.LP
\fBcancel\fR cancels existing print jobs. The \fI-a\fR option will remove
all jobs from the specified destination.
.SH OPTIONS
The following options are recognized by \fBlp\fR:
.TP 5
\-E
.br
Forces encryption when connecting to the server.
.TP 5
\-c
.br
This option is provided for backwards-compatibility only. On
systems that support it, this option forces the print file to be
copied to the spool directory before printing. In CUPS, print
files are always sent to the scheduler via IPP which has the
same effect.
.TP 5
\-d \fIdestination\fR
.br
Prints files to the named printer.
.TP 5
\-h \fIhostname\fR
.br
Specifies the print server hostname. The default is "localhost" or the value
of the CUPS_SERVER environment variable.
.TP 5
\-i \fIjob-id\fR
.br
Specifies an existing job to modify.
.TP 5
\-m
.br
Send email when the job is completed (not supported CUPS 1.1.)
.TP 5
\-n \fIcopies\fR
.br
Sets the number of copies to print from 1 to 100.
.TP 5
\-o \fIoption\fR
.br
Sets a job option.
.TP 5
\-q \fIpriority\fR
.br
Sets the job priority from 1 (lowest) to 100 (highest). The
default priority is 50.
.TP 5
\-s
.br
Do not report the resulting job IDs (silent mode.)
.TP 5
\-t \fIname\fR
.br
Sets the job name.
.TP 5
\-u \fIusername\fR
.br
Cancels jobs owned by \fIusername\fR.
.TP 5
\-H \fIhandling\fR
.br
Specifies when the job should be printed. A value of
\fIimmediate\fR will print the file immediately, a value of
\fIhold\fR will hold the job indefinitely, and a time value
(HH:MM) will hold the job until the specified time. Use a value
of \fIresume\fR with the \fI-i\fR option to resume a held job.
Use a value of \fIrestart\fR with the \fI-i\fR option to restart
a completed job.
.TP 5
\-P \fIpage-list\fR
.br
Specifies which pages to print in the document. The list can contain a
list of numbers and ranges (#-#) separated by commas (e.g. 1,3-5,16).
.SH COMPATIBILITY
Unlike the System V printing system, CUPS allows printer names to contain
any printable character except SPACE and TAB. Also, printer and class names are
\fBnot\fR case-sensitive. 
.LP
The "m" option is not functional in CUPS 1.1.
.LP
The "q" option accepts a different range of values than the
Solaris lp command, matching the IPP job priority values (1-100)
instead of the Solaris values (0-39).
.SH NOTES
Administrators wishing to prevent unauthorized cancellation of
jobs via the \fI-u\fR option should password-protect the /jobs
location in \fIcupsd.conf(5)\fR.
.SH SEE ALSO
lpstat(1),
CUPS Software Users Manual,
http://localhost:631/documentation.html
.SH COPYRIGHT
Copyright 1993-2005 by Easy Software Products, All Rights Reserved.
.\"
.\" End of "$Id: lp.man,v 1.15 2005/01/03 19:29:58 mike Exp $".
.\"
